class PYSIDE_LOCAL SingleShotTimer : public QTimer {
/**
 * This qptr must exists while this QTimer exists, so we know that exists
 * at least one qptr to this QTimer and it is tagged with release_ownership.
 * So, qptr wont delete this C++ object. If this qptr dies before QTimer,
 * boost could create another qptr to this instance, and when the new qptr dies
 * it will delete this C++ object resulting in a nice segfault, because we use
 * deleteLater to destroy ourself.
 **/
PySide::qptr<QTimer> ptr;

public:
    SingleShotTimer(int msec)  : ptr(this) {
        m_id = QObject::startTimer(msec);
        ptr.release_ownership();
    }

protected:
    void timerEvent(QTimerEvent* ev) {
        if (ev->timerId() == m_id) {
            QObject::killTimer(m_id);
            emit timeout();
            deleteLater();
        }
    }
private:
    int m_id; // timer id
};

static void
single_shot_python(int msec, python::object &py_func)
{
    QTimer *timer = new SingleShotTimer(msec);
    signal_manager::instance().connect(timer, pyqt_signal("timeout()"), py_func);
}
