/**
 * This wrapper function is used to avoid Qt C++ assert error and
 * throw a Python error if the index is out of range.
 **/
static python::object
QByteArray_get_item_by_pos(const QBitArray& self, const int& pos)
{
    int new_pos = pos;

    if (pos < 0)
        new_pos = self.size() + pos;

    if (new_pos < self.size() && new_pos >= 0) {
        return boost::python::object(self[new_pos]);
    } else {
        throw std::out_of_range("index out-of-range");
    }
}

