
static QList<QAbstractAnimation *>
qabstract_transition_animations(QAbstractTransition& self)
{
    PySide::qptr<QAbstractTransition> ptr_parent(&self);
    QList<QAbstractAnimation*> animations = self.animations();

    foreach(QAbstractAnimation *animation, animations) {
        python::object obj(PySide::ptr(animation));
        PySide::qptr<QAbstractAnimation> ptr_item(obj.ptr());
        ptr_parent.add_child(ptr_item);
    }

    return animations;
}

/**
 * This code is used to handle parent control in setTargetSates because this function receives a list as arg
 * then this list need to be splitted and all members setted as child of QAbstractTransition.
 **/

static void
qabstract_transition_set_target_states(QAbstractTransition& self, QList<QAbstractState*> targets)
{
    PySide::qptr<QAbstractTransition> ptr_parent(&self);

    //remove the old ones
    foreach(QAbstractState *state, self.targetStates()) {
        python::object obj(PySide::ptr(state));
        PySide::qptr<QAbstractState> ptr_item(obj.ptr());
        ptr_parent.remove_child(ptr_item);
    }

    //install the new ones
    foreach(QAbstractState *state, targets) {
        python::object obj(PySide::ptr(state));
        PySide::qptr<QAbstractState> ptr_item(obj.ptr());
        ptr_parent.add_child(ptr_item);
    }

    self.setTargetStates(targets);
}

static QList<QAbstractState*>
qabstract_transition_target_states(QAbstractTransition& self)
{
    PySide::qptr<QAbstractTransition> ptr_parent(&self);
    QList<QAbstractState*> states = self.targetStates();

    foreach(QAbstractState *state, states) {
        python::object obj(PySide::ptr(state));
        PySide::qptr<QAbstractState> ptr_item(obj.ptr());
        ptr_parent.add_child(ptr_item);
    }

    return states;
}
