# -*- coding: utf-8 -*-

''' Test case for signal to signal connections.'''

import unittest
from PySide.QtCore import *
from helper import UsesQApplication

class Foo(QObject):
    def __init__(self):
        QObject.__init__(self, None)
        self._called = False

    def markCalled(self):
        self._called = True

    def called(self):
        return self._called

class TestSignal2SignalConnect(UsesQApplication):
    '''Test case for signal to signal connections'''

    def callback(self):
        #Default callback without arguments
        self.called = True

    def testDynamicSignal(self):
        t = QTimer()
        f = Foo()
        QObject.connect(t, SIGNAL("timeout()"), f, SIGNAL("dynamic()"))
        QObject.connect(f, SIGNAL("dynamic()"), f.markCalled)
        t.start(1000)
        QTimer.singleShot(2000, self.app.quit)
        self.app.exec_()
        self.assert_(f.called())

    def testManuallyEmit(self):
        t = QTimer()
        f = Foo()
        QObject.connect(t, SIGNAL("timeout()"), f, SIGNAL("dynamic()"))
        QObject.connect(f, SIGNAL("dynamic()"), f.markCalled)
        f.emit(SIGNAL("dynamic()"))
        self.assert_(f.called())

if __name__ == '__main__':
    unittest.main()


