import unittest
import sys
from helper import UsesQCoreApplication

try:
    from PySide.QtCore import QState
except :
    sys.exit(0)

from PySide.QtCore import *

class QStateMachineTest(UsesQCoreApplication):

    def timeout(self):
        self._o.emit(SIGNAL("startAnimation()"))

    def testNatiVeSignal(self):
        o = QObject()
        o.setProperty("animation", QVariant(0.0));

        machine = QStateMachine()

        s1 = QState()
        s1.assignProperty(o, "animation",  QVariant(1.0))

        s2 = QState()
        s2.assignProperty(o, "animation",  QVariant(100.0))
        t = QTimer()
        s1.addTransition(t, SIGNAL("timeout()"), s2)

        machine.addState(s1)
        machine.addState(s2)
        machine.setInitialState(s1)
        machine.start()

        t.start(100)
        QTimer.singleShot(200, self.app.quit)
        self.app.exec_()
        self.assertEqual(o.property("animation").toDouble()[0], 100.0)


    def testSignalTransition(self):
        o = QObject()
        o.setProperty("animation", QVariant(0.0));

        machine = QStateMachine()

        s1 = QState()
        s1.assignProperty(o, "animation",  QVariant(1.0))

        s2 = QState()
        s2.assignProperty(o, "animation",  QVariant(100.0))

        machine.addState(s1)
        machine.addState(s2)
        machine.setInitialState(s1)

        s1.addTransition(o, SIGNAL("startAnimation()"), s2)

        machine.start()

        self._o = o

        QTimer.singleShot(100, self.timeout)
        QTimer.singleShot(200, self.app.quit)
        self.app.exec_()
        self.assertEqual(o.property("animation").toDouble()[0], 100.0)

if __name__ == '__main__':
        unittest.main()
