/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __NOTIFIER_WRAPPER__
#define __NOTIFIER_WRAPPER__

#include "pyside.hpp"
#include "backendcapabilities.h"

/**
 * Wrapper class to store a BackendCapabilities::Notifier used in Python
 * This class override metaObject function to return the metaObject from interanl_notifier
 * used to connect signals.
 **/
template<typename T> class qptr;
class PYSIDE_LOCAL phonon_backendcapabilities_notifier_wrapper : public QObject
{

private:
    typedef boost::python::class_< phonon_backendcapabilities_notifier_wrapper, boost::python::bases< QObject > , PySide::qptr < phonon_backendcapabilities_notifier_wrapper > , boost::noncopyable > class_type;
    Phonon::BackendCapabilities::Notifier *m_notifier;
    static phonon_backendcapabilities_notifier_wrapper *m_instance;
    ~phonon_backendcapabilities_notifier_wrapper() {}

public:
    phonon_backendcapabilities_notifier_wrapper(Phonon::BackendCapabilities::Notifier *notifier) : m_notifier(notifier) {}
    const QMetaObject* metaObject() const;

    static phonon_backendcapabilities_notifier_wrapper *instance();
    static void define_python_class() throw();
};

//Delete function
PYSIDE_LOCAL inline void delete_pointer(phonon_backendcapabilities_notifier_wrapper *p) {}

#endif // __NOTIFIER_WRAPPER__

