/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "phonon_backendcapabilities_notifier_wrapper.hpp"
//Base include
#include "pyside.hpp"

//Extra includes [global]
#include <backendcapabilities.h>
#include <qobject.h>


using namespace boost;
using namespace PySide;

phonon_backendcapabilities_notifier_wrapper* phonon_backendcapabilities_notifier_wrapper::m_instance = 0;

const QMetaObject *
phonon_backendcapabilities_notifier_wrapper::metaObject() const
{
    return m_notifier->metaObject();
}

phonon_backendcapabilities_notifier_wrapper*
phonon_backendcapabilities_notifier_wrapper::instance()
{
    if (m_instance == 0)
        m_instance = new phonon_backendcapabilities_notifier_wrapper(Phonon::BackendCapabilities::notifier());

    return m_instance;
}

void phonon_backendcapabilities_notifier_wrapper::define_python_class() throw() {
    class_type python_cls("Notifier", python::no_init);
}
