/**
 * Wrapper c++ [] operator to avoid qt assert error and throw a
 * Python errror message
 **/
static python::object
string_get_item_by_pos(const QString& self, const int& pos)
{
    int new_pos = pos;

    if (pos < 0)
        new_pos = self.length() + pos;

    if (new_pos < self.length() && new_pos >= 0) {
        return boost::python::object(QString(self[new_pos]));
    } else {
        throw std::out_of_range("index out-of-range");
    }
}

/**
 * Add operator support python string/unicode
 **/
static QString
qstring_operator_radd(QString& self, const python::object& boostObj)
{
    PyObject* pyObj = boostObj.ptr();
    if (PyUnicode_Check(pyObj)) {
        Py_ssize_t data_size = PyUnicode_GetSize(pyObj);
        wchar_t* data = new wchar_t[data_size];
        PyUnicode_AsWideChar((PyUnicodeObject*)pyObj, data, data_size);
        QString result(QString::fromWCharArray(data, data_size));
        result += self;
        delete[] data;
        return result;
    }
#if PY_VERSION_HEX < 0x03000000
    else if (PyString_Check(pyObj)) {
        QString result(PyString_AS_STRING(pyObj));
        result += self;
        return result;
    }
#endif
    else {
        // FIXME throw a type error
        python::throw_error_already_set();
        return QString();
    }
}

/**
 * Python buffer protocol related functions
 **/
static Py_ssize_t
qstring_getsegcount(PyObject *self, Py_ssize_t *lenp)
{
    if (lenp) {
        python::object boost_self = python::object(python::handle<>(python::detail::borrowed_reference(self)));
        QString qstring = python::extract<QString>(boost_self);
        *lenp = qstring.size() * sizeof(ushort);
    }
    return 1;
}

static Py_ssize_t
qstring_getreadbuffer(PyObject *self, Py_ssize_t segment, void **ptrptr)
{
    if (segment != 0) {
        PyErr_SetString(PyExc_SystemError, "accessing non-existent QString segment");
        return -1;
    }
    python::object boost_self = python::object(python::handle<>(python::detail::borrowed_reference(self)));
    QString qstring = python::extract<QString>(boost_self);
    *ptrptr = (void *)qstring.utf16();
    return qstring.size() * sizeof(ushort);
}

/**
 * 'textcodec' variable is initialized in the 'define_python_class' function
 **/
static QTextCodec *textcodec = 0;

static Py_ssize_t
qstring_getcharbuffer(PyObject *self, Py_ssize_t segment, const char **ptrptr)
{
    if (segment != 0) {
        PyErr_SetString(PyExc_SystemError,
                        "accessing non-existent QString segment");
        return -1;
    }
    python::object boost_self =
        python::object(python::handle<>(python::detail::borrowed_reference(self)));
    QString qstring = python::extract<QString>(boost_self);

    QByteArray buf;
    if (textcodec) {
        buf = textcodec->fromUnicode(qstring);
    } else {
        buf = qstring.toAscii();
    }
    *ptrptr = const_cast<char *>(buf.data());
    return buf.size();
}
