static python::object
qstatemachine_configuration(QStateMachine* self)
{
    PySide::qptr<QStateMachine> ptr_parent(self);
    python::list ret;

    QSet<QAbstractState *> list = self->configuration();
    foreach(QAbstractState *s, list) {
        python::object obj(PySide::ptr(s));
        PySide::qptr<QAbstractState> ptr_item(obj.ptr());
        ret.append(PySide::ptr(s));
        ptr_parent.add_child(ptr_item);
    }

    return ret;
}

static python::object
qstatemachine_defaultanimations(QStateMachine* self)
{
    PySide::qptr<QStateMachine> ptr_parent(self);
    python::list ret;

    QList<QAbstractAnimation *> list = self->defaultAnimations();
    foreach(QAbstractAnimation *s, list) {
        python::object obj(PySide::ptr(s));
        PySide::qptr<QAbstractAnimation> ptr_item(obj.ptr());
        ret.append(PySide::ptr(s));
        ptr_parent.add_child(ptr_item);
    }

    return ret;
}


