/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_VERSIT_PYTHON_H
#define SBK_VERSIT_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <qtmobility_contacts_python.h>
#include <pyside_qtcore_python.h>
#include <pyside_qtgui_python.h>

// Binded library includes
#include <qversitcontactexporter.h>
#include <qversitcontactimporter.h>
#include <qversitdocument.h>
#include <qversitwriter.h>
#include <qversitproperty.h>
#include <qversitreader.h>
#include <qversitresourcehandler.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QStack>
#include <QVector>
#include <QStringList>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QTMOBILITY_QVERSITPROPERTY_IDX                           0
#define SBK_QTMOBILITY_QVERSITPROPERTY_VALUETYPE_IDX                 1
#define SBK_QTMOBILITY_QVERSITCONTACTIMPORTER_IDX                    2
#define SBK_QTMOBILITY_QVERSITCONTACTIMPORTER_ERROR_IDX              3
#define SBK_QTMOBILITY_QVERSITCONTACTIMPORTERPROPERTYHANDLER_IDX     4
#define SBK_QTMOBILITY_QVERSITCONTACTEXPORTER_IDX                    5
#define SBK_QTMOBILITY_QVERSITCONTACTEXPORTER_ERROR_IDX              6
#define SBK_QTMOBILITY_QVERSITCONTACTEXPORTERDETAILHANDLER_IDX       7
#define SBK_QTMOBILITY_QVERSITRESOURCEHANDLER_IDX                    8
#define SBK_QTMOBILITY_QVERSITDEFAULTRESOURCEHANDLER_IDX             9
#define SBK_QTMOBILITY_QVERSITDOCUMENT_IDX                           10
#define SBK_QTMOBILITY_QVERSITDOCUMENT_VERSITTYPE_IDX                11
#define SBK_QTMOBILITY_QVERSITWRITER_IDX                             12
#define SBK_QTMOBILITY_QVERSITWRITER_ERROR_IDX                       13
#define SBK_QTMOBILITY_QVERSITWRITER_STATE_IDX                       14
#define SBK_QTMOBILITY_QVERSITREADER_IDX                             15
#define SBK_QTMOBILITY_QVERSITREADER_ERROR_IDX                       16
#define SBK_QTMOBILITY_QVERSITREADER_STATE_IDX                       17
#define SBK_Versit_IDX_COUNT                                         18

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_VersitTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QVersitProperty::ValueType >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITPROPERTY_VALUETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitProperty >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITPROPERTY_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitContactImporter::Error >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitContactImporter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitContactImporterPropertyHandler >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTERPROPERTYHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitContactExporter::Error >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitContactExporter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitContactExporterDetailHandler >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTERDETAILHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitResourceHandler >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITRESOURCEHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitDefaultResourceHandler >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITDEFAULTRESOURCEHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitDocument::VersitType >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITDOCUMENT_VERSITTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitDocument >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITDOCUMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitWriter::Error >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITWRITER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitWriter::State >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITWRITER_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitWriter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITWRITER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitReader::Error >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITREADER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitReader::State >() { return SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITREADER_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QVersitReader >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITREADER_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QVersitWriter >(const QtMobility::QVersitWriter* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QVersitWriter >()),const_cast<QtMobility::QVersitWriter*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QVersitReader >(const QtMobility::QVersitReader* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QVersitReader >()),const_cast<QtMobility::QVersitReader*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QVersitProperty::ValueType > : EnumConverter<QtMobility::QVersitProperty::ValueType >
{
};

template<>
struct Converter<QtMobility::QVersitProperty > : ValueTypeConverter<QtMobility::QVersitProperty >
{
};

template<>
struct Converter<QtMobility::QVersitContactImporter::Error > : EnumConverter<QtMobility::QVersitContactImporter::Error >
{
};

template<>
struct Converter<QtMobility::QVersitContactImporter > : ValueTypeConverter<QtMobility::QVersitContactImporter >
{
};

template<>
struct Converter<QtMobility::QVersitContactImporterPropertyHandler* > : ObjectTypeConverter<QtMobility::QVersitContactImporterPropertyHandler >
{
};

template<>
struct Converter<QtMobility::QVersitContactImporterPropertyHandler& > : ObjectTypeReferenceConverter<QtMobility::QVersitContactImporterPropertyHandler >
{
};

template<>
struct Converter<QtMobility::QVersitContactExporter::Error > : EnumConverter<QtMobility::QVersitContactExporter::Error >
{
};

template<>
struct Converter<QtMobility::QVersitContactExporter > : ValueTypeConverter<QtMobility::QVersitContactExporter >
{
};

template<>
struct Converter<QtMobility::QVersitContactExporterDetailHandler* > : ObjectTypeConverter<QtMobility::QVersitContactExporterDetailHandler >
{
};

template<>
struct Converter<QtMobility::QVersitContactExporterDetailHandler& > : ObjectTypeReferenceConverter<QtMobility::QVersitContactExporterDetailHandler >
{
};

template<>
struct Converter<QtMobility::QVersitResourceHandler* > : ObjectTypeConverter<QtMobility::QVersitResourceHandler >
{
};

template<>
struct Converter<QtMobility::QVersitResourceHandler& > : ObjectTypeReferenceConverter<QtMobility::QVersitResourceHandler >
{
};

template <>
struct SbkTypeInfo<QtMobility::QVersitDefaultResourceHandler >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QVersitDefaultResourceHandler > : ValueTypeConverter<QtMobility::QVersitDefaultResourceHandler >
{
};

template<>
struct Converter<QtMobility::QVersitDocument::VersitType > : EnumConverter<QtMobility::QVersitDocument::VersitType >
{
};

template<>
struct Converter<QtMobility::QVersitDocument > : ValueTypeConverter<QtMobility::QVersitDocument >
{
    static QtMobility::QVersitDocument toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QVersitWriter::Error > : EnumConverter<QtMobility::QVersitWriter::Error >
{
};

template<>
struct Converter<QtMobility::QVersitWriter::State > : EnumConverter<QtMobility::QVersitWriter::State >
{
};

template<>
struct Converter<QtMobility::QVersitWriter* > : ObjectTypeConverter<QtMobility::QVersitWriter >
{
};

template<>
struct Converter<QtMobility::QVersitWriter& > : ObjectTypeReferenceConverter<QtMobility::QVersitWriter >
{
};

template<>
struct Converter<QtMobility::QVersitReader::Error > : EnumConverter<QtMobility::QVersitReader::Error >
{
};

template<>
struct Converter<QtMobility::QVersitReader::State > : EnumConverter<QtMobility::QVersitReader::State >
{
};

template<>
struct Converter<QtMobility::QVersitReader* > : ObjectTypeConverter<QtMobility::QVersitReader >
{
};

template<>
struct Converter<QtMobility::QVersitReader& > : ObjectTypeReferenceConverter<QtMobility::QVersitReader >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QtMobility::QVersitDocument >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QVersitDocument >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QVersitDocument >());
    return Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QVersitDocument Shiboken::Converter<QtMobility::QVersitDocument >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QVersitDocument)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QVersitDocument >());
        if (Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::checkType(pyobj))
            return QtMobility::QVersitDocument(Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QVersitDocument* cptr = reinterpret_cast<QtMobility::QVersitDocument*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QVersitDocument > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(pyobj);
}


#endif // SBK_VERSIT_PYTHON_H

