/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitresourcehandler_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qversitproperty.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QVersitResourceHandlerWrapper::QVersitResourceHandlerWrapper() : QtMobility::QVersitResourceHandler() {
    // ... middle
}

bool QVersitResourceHandlerWrapper::loadResource(const QString & location, QByteArray * contents, QString * mimeType)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "loadResource"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitResourceHandler.loadResource()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QString >::toPython(location),
        Shiboken::Converter<QByteArray * >::toPython(contents),
        Shiboken::Converter<QString * >::toPython(mimeType)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitResourceHandler.loadResource", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QVersitResourceHandlerWrapper::saveResource(const QByteArray & contents, const QtMobility::QVersitProperty & property, QString * location)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveResource"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitResourceHandler.saveResource()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<const QByteArray & >::toPython(contents),
        Shiboken::Converter<const QtMobility::QVersitProperty & >::toPython(property),
        Shiboken::Converter<QString * >::toPython(location)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitResourceHandler.saveResource", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QVersitResourceHandlerWrapper::~QVersitResourceHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitResourceHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitResourceHandler >()))
        return -1;

    QVersitResourceHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITRESOURCEHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QVersitResourceHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QVersitResourceHandler()
            cptr = new QVersitResourceHandlerWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitResourceHandler >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QVersitResourceHandlerFunc_loadResource(PyObject* self, PyObject* args)
{
    QtMobility::QVersitResourceHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitResourceHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "loadResource", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: loadResource(QString,QByteArray*,QString*)
    if (numArgs == 3 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray * >::isConvertible(pyargs[1]) && Shiboken::Converter<QString * >::isConvertible(pyargs[2])) {
        overloadId = 0; // loadResource(QString,QByteArray*,QString*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitResourceHandlerFunc_loadResource_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            QString * cpp_arg2 = Shiboken::Converter<QString * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // loadResource(QString,QByteArray*,QString*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitResourceHandler.loadResource()' not implemented.");
                return 0;
            }
            bool cppResult = cppSelf->loadResource(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitResourceHandlerFunc_loadResource_TypeError:
        const char* overloads[] = {"QString, PySide.QtCore.QByteArray, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitResourceHandler.loadResource", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitResourceHandlerFunc_saveResource(PyObject* self, PyObject* args)
{
    QtMobility::QVersitResourceHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitResourceHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveResource", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: saveResource(QByteArray,QtMobility::QVersitProperty,QString*)
    if (numArgs == 3 && Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString * >::isConvertible(pyargs[2])) {
        overloadId = 0; // saveResource(QByteArray,QtMobility::QVersitProperty,QString*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitResourceHandlerFunc_saveResource_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QVersitProperty* cpp_arg1 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(pyargs[1]);
            QString * cpp_arg2 = Shiboken::Converter<QString * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // saveResource(QByteArray,QtMobility::QVersitProperty,QString*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitResourceHandler.saveResource()' not implemented.");
                return 0;
            }
            bool cppResult = cppSelf->saveResource(*cpp_arg0, *cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitResourceHandlerFunc_saveResource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, QtMobility.Versit.QtMobility::QVersitProperty, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitResourceHandler.saveResource", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitResourceHandler_methods[] = {
    {"loadResource", (PyCFunction)SbkQtMobility_QVersitResourceHandlerFunc_loadResource, METH_VARARGS},
    {"saveResource", (PyCFunction)SbkQtMobility_QVersitResourceHandlerFunc_saveResource, METH_VARARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitResourceHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitResourceHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitResourceHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitResourceHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitResourceHandler >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitResourceHandler*",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QVersitResourceHandler(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITRESOURCEHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitResourceHandler_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitResourceHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitResourceHandler_Type));
    PyModule_AddObject(module, "QVersitResourceHandler",
        ((PyObject*)&SbkQtMobility_QVersitResourceHandler_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitResourceHandler >("QtMobility::QVersitResourceHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitResourceHandler >(typeid(QtMobility::QVersitResourceHandler).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitResourceHandler >(typeid(QVersitResourceHandlerWrapper).name());
    PySide::initQtMetaType<QtMobility::QVersitResourceHandler* >();
}

