/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitreader_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qtextcodec.h>
#include <qthread.h>
#include <qversitdocument.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QVersitReaderWrapper::QVersitReaderWrapper() : QtMobility::QVersitReader(), m_metaObject(0) {
    // ... middle
}

QVersitReaderWrapper::QVersitReaderWrapper(QIODevice * inputDevice) : QtMobility::QVersitReader(inputDevice), m_metaObject(0) {
    // ... middle
}

QVersitReaderWrapper::QVersitReaderWrapper(const QByteArray & inputData) : QtMobility::QVersitReader(inputData), m_metaObject(0) {
    // ... middle
}

void QVersitReaderWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QVersitReaderWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QVersitReaderWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QVersitReaderWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QVersitReaderWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitReader.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QVersitReaderWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitReader.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QVersitReaderWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QVersitReaderWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QVersitReader::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QVersitReaderWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QVersitReader::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QVersitReaderWrapper::~QVersitReaderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitReader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitReader >()))
        return -1;

    QVersitReaderWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
                propertyKeys.push_back(argName);
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersitReader", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QVersitReader()
    // 1: QVersitReader(QIODevice*)
    // 2: QVersitReader(QByteArray)
    if (numArgs == 0) {
        overloadId = 0; // QVersitReader()
    } else if (numArgs == 1 && Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 2; // QVersitReader(QByteArray)
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        overloadId = 1; // QVersitReader(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitReader_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QVersitReader()
            {

                if(!PyErr_Occurred()) {
                // QVersitReader()
                cptr = new QVersitReaderWrapper();
                }
                break;
            }
            case 1: // QVersitReader(QIODevice*)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QVersitReader(QIODevice*)
                cptr = new QVersitReaderWrapper(cpp_arg0);
                }
                break;
            }
            case 2: // QVersitReader(QByteArray)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
                QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
                if (!Shiboken::Converter<QByteArray >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QVersitReader(QByteArray)
                cptr = new QVersitReaderWrapper(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitReader >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QVersitReader_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QVersitReader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice", "PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitReader", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_cancel(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // cancel()
            cppSelf->QtMobility::QVersitReader::cancel();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_defaultCodec(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // defaultCodec()const
            QTextCodec * cppResult = cppSelf->QtMobility::QVersitReader::defaultCodec();
            pyResult = Shiboken::Converter<QTextCodec * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_device(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = cppSelf->QtMobility::QVersitReader::device();
            pyResult = Shiboken::Converter<QIODevice * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_error(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QVersitReader::Error cppResult = cppSelf->QtMobility::QVersitReader::error();
            pyResult = Shiboken::Converter<QtMobility::QVersitReader::Error >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_results(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // results()const
            QList<QtMobility::QVersitDocument > cppResult = cppSelf->QtMobility::QVersitReader::results();
            pyResult = Shiboken::Converter<QList<QtMobility::QVersitDocument > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_setData(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setData(QByteArray)
    if (Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 0; // setData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitReaderFunc_setData_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
            if (!Shiboken::Converter<QByteArray >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setData(QByteArray)
            cppSelf->QtMobility::QVersitReader::setData(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitReaderFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitReader.setData", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_setDefaultCodec(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDefaultCodec(QTextCodec*)
    if (Shiboken::Converter<QTextCodec * >::isConvertible(arg)) {
        overloadId = 0; // setDefaultCodec(QTextCodec*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitReaderFunc_setDefaultCodec_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QTextCodec* cpp_arg0 = Shiboken::Converter<QTextCodec* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDefaultCodec(QTextCodec*)
            cppSelf->QtMobility::QVersitReader::setDefaultCodec(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitReaderFunc_setDefaultCodec_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextCodec", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitReader.setDefaultCodec", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_setDevice(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDevice(QIODevice*)
    if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitReaderFunc_setDevice_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->QtMobility::QVersitReader::setDevice(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitReaderFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitReader.setDevice", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_startReading(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // startReading()
            bool cppResult = cppSelf->QtMobility::QVersitReader::startReading();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_state(PyObject* self)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // state()const
            QtMobility::QVersitReader::State cppResult = cppSelf->QtMobility::QVersitReader::state();
            pyResult = Shiboken::Converter<QtMobility::QVersitReader::State >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitReaderFunc_waitForFinished(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QVersitReader* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitReader* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "msec" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Versit.QVersitReader.waitForFinished(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Versit.QVersitReader.waitForFinished(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForFinished", &arg))
        return 0;


    // Overloaded function decisor
    // 0: waitForFinished(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForFinished(int)
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // waitForFinished(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitReaderFunc_waitForFinished_TypeError;

    // Call function/method
    {
        Shiboken::ThreadStateSaver threadStateSaver;
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "msec");
                if (value) {
                    if (arg)
                        errorArgName = "msec";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Versit.QVersitReader.waitForFinished(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            int cpp_arg0 = arg ? Shiboken::Converter<int >::toCpp(arg) : -1;

            if(!PyErr_Occurred()) {
            // waitForFinished(int)
            threadStateSaver.save();
            bool cppResult = cppSelf->QtMobility::QVersitReader::waitForFinished(cpp_arg0);
            threadStateSaver.restore();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitReaderFunc_waitForFinished_TypeError:
        const char* overloads[] = {"int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitReader.waitForFinished", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitReader_methods[] = {
    {"cancel", (PyCFunction)SbkQtMobility_QVersitReaderFunc_cancel, METH_NOARGS},
    {"defaultCodec", (PyCFunction)SbkQtMobility_QVersitReaderFunc_defaultCodec, METH_NOARGS},
    {"device", (PyCFunction)SbkQtMobility_QVersitReaderFunc_device, METH_NOARGS},
    {"error", (PyCFunction)SbkQtMobility_QVersitReaderFunc_error, METH_NOARGS},
    {"results", (PyCFunction)SbkQtMobility_QVersitReaderFunc_results, METH_NOARGS},
    {"setData", (PyCFunction)SbkQtMobility_QVersitReaderFunc_setData, METH_O},
    {"setDefaultCodec", (PyCFunction)SbkQtMobility_QVersitReaderFunc_setDefaultCodec, METH_O},
    {"setDevice", (PyCFunction)SbkQtMobility_QVersitReaderFunc_setDevice, METH_O},
    {"startReading", (PyCFunction)SbkQtMobility_QVersitReaderFunc_startReading, METH_NOARGS},
    {"state", (PyCFunction)SbkQtMobility_QVersitReaderFunc_state, METH_NOARGS},
    {"waitForFinished", (PyCFunction)SbkQtMobility_QVersitReaderFunc_waitForFinished, METH_VARARGS|METH_KEYWORDS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitReader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitReader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitReader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitReader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitReader >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitReader*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QVersitReader_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QVersitReader*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QVersitReader_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Versit_QtMobility_QVersitReader_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Versit_QtMobility_QVersitReader_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Versit_QtMobility_QVersitReader_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Versit_QtMobility_QVersitReader_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Versit_QtMobility_QVersitReader_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Versit_QtMobility_QVersitReader_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Versit_QtMobility_QVersitReader_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Versit_QtMobility_QVersitReader_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Versit_QtMobility_QVersitReader_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Versit_QtMobility_QVersitReader_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QVersitReader(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITREADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitReader_Type);

    SbkQtMobility_QVersitReader_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QVersitReader_Type.type_discovery = &SbkQtMobility_QVersitReader_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QVersitReader_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitReader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitReader_Type));
    PyModule_AddObject(module, "QVersitReader",
        ((PyObject*)&SbkQtMobility_QVersitReader_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITREADER_ERROR_IDX] = &SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type);
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type,
        (long) QtMobility::QVersitReader::NoError, "NoError");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type,
        (long) QtMobility::QVersitReader::UnspecifiedError, "UnspecifiedError");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "UnspecifiedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type.tp_dict,
        "UnspecifiedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type,
        (long) QtMobility::QVersitReader::IOError, "IOError");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "IOError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type.tp_dict,
        "IOError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type,
        (long) QtMobility::QVersitReader::OutOfMemoryError, "OutOfMemoryError");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "OutOfMemoryError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type.tp_dict,
        "OutOfMemoryError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type,
        (long) QtMobility::QVersitReader::NotReadyError, "NotReadyError");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "NotReadyError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type.tp_dict,
        "NotReadyError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type,
        (long) QtMobility::QVersitReader::ParseError, "ParseError");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "ParseError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_Error_Type.tp_dict,
        "ParseError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QVersitReader::Error");

    // init enum class: State
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITREADER_STATE_IDX] = &SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type);
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type,
        (long) QtMobility::QVersitReader::InactiveState, "InactiveState");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "InactiveState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type.tp_dict,
        "InactiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type,
        (long) QtMobility::QVersitReader::ActiveState, "ActiveState");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "ActiveState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type.tp_dict,
        "ActiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type,
        (long) QtMobility::QVersitReader::CanceledState, "CanceledState");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "CanceledState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type.tp_dict,
        "CanceledState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type,
        (long) QtMobility::QVersitReader::FinishedState, "FinishedState");
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict,
        "FinishedState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitReader_State_Type.tp_dict,
        "FinishedState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QVersitReader::State");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("resultsAvailable", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict, "resultsAvailable", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("stateChanged", "QtMobility::QVersitReader::State", NULL);
    PyDict_SetItemString(SbkQtMobility_QVersitReader_Type.super.ht_type.tp_dict, "stateChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitReader >("QtMobility::QVersitReader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitReader >(typeid(QtMobility::QVersitReader).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitReader >(typeid(QVersitReaderWrapper).name());
    PySide::initQtMetaType<QtMobility::QVersitReader* >();
}

