/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitdocument_wrapper.h"

// Extra includes
#include <QList>
#include <qversitdocument.h>
#include <qversitproperty.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitDocument_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitDocument >()))
        return -1;

    QtMobility::QVersitDocument* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersitDocument", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QVersitDocument()
    // 1: QVersitDocument(QtMobility::QVersitDocument::VersitType)
    // 2: QVersitDocument(QtMobility::QVersitDocument)
    if (numArgs == 0) {
        overloadId = 0; // QVersitDocument()
    } else if (numArgs == 1 && Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::isConvertible(arg)) {
        overloadId = 1; // QVersitDocument(QtMobility::QVersitDocument::VersitType)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QVersitDocument & >::isConvertible(arg)) {
        overloadId = 2; // QVersitDocument(QtMobility::QVersitDocument)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDocument_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QVersitDocument()
            {

                if(!PyErr_Occurred()) {
                // QVersitDocument()
                cptr = new QtMobility::QVersitDocument();
                }
                break;
            }
            case 1: // QVersitDocument(QtMobility::QVersitDocument::VersitType)
            {
                QtMobility::QVersitDocument::VersitType cpp_arg0 = Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QVersitDocument(QtMobility::QVersitDocument::VersitType)
                cptr = new QtMobility::QVersitDocument(cpp_arg0);
                }
                break;
            }
            case 2: // QVersitDocument(QtMobility::QVersitDocument)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QVersitDocument > cpp_arg0_auto_ptr;
                QtMobility::QVersitDocument* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QVersitDocument(QtMobility::QVersitDocument)
                cptr = new QtMobility::QVersitDocument(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitDocument >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QVersitDocument_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QVersitDocument_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Versit.QtMobility::QVersitDocument.VersitType", "QtMobility.Versit.QtMobility::QVersitDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitDocument", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_addProperty(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: addProperty(QtMobility::QVersitProperty)
    if (Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(arg)) {
        overloadId = 0; // addProperty(QtMobility::QVersitProperty)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDocumentFunc_addProperty_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QVersitProperty* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // addProperty(QtMobility::QVersitProperty)
            cppSelf->QtMobility::QVersitDocument::addProperty(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitDocumentFunc_addProperty_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitProperty", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitDocument.addProperty", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_clear(PyObject* self)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clear()
            cppSelf->QtMobility::QVersitDocument::clear();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_isEmpty(PyObject* self)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QVersitDocument::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_properties(PyObject* self)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // properties()const
            QList<QtMobility::QVersitProperty > cppResult = cppSelf->QtMobility::QVersitDocument::properties();
            pyResult = Shiboken::Converter<QList<QtMobility::QVersitProperty > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_removeProperties(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeProperties(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // removeProperties(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDocumentFunc_removeProperties_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeProperties(QString)
            cppSelf->QtMobility::QVersitDocument::removeProperties(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitDocumentFunc_removeProperties_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitDocument.removeProperties", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_removeProperty(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeProperty(QtMobility::QVersitProperty)
    if (Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(arg)) {
        overloadId = 0; // removeProperty(QtMobility::QVersitProperty)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDocumentFunc_removeProperty_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QVersitProperty* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeProperty(QtMobility::QVersitProperty)
            cppSelf->QtMobility::QVersitDocument::removeProperty(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitDocumentFunc_removeProperty_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitProperty", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitDocument.removeProperty", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_setType(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setType(QtMobility::QVersitDocument::VersitType)
    if (Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::isConvertible(arg)) {
        overloadId = 0; // setType(QtMobility::QVersitDocument::VersitType)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDocumentFunc_setType_TypeError;

    // Call function/method
    {
        {
            QtMobility::QVersitDocument::VersitType cpp_arg0 = Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setType(QtMobility::QVersitDocument::VersitType)
            cppSelf->QtMobility::QVersitDocument::setType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitDocumentFunc_setType_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitDocument.VersitType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitDocument.setType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitDocumentFunc_type(PyObject* self)
{
    QtMobility::QVersitDocument* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QVersitDocument::VersitType cppResult = cppSelf->QtMobility::QVersitDocument::type();
            pyResult = Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QVersitDocument_methods[] = {
    {"addProperty", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_addProperty, METH_O},
    {"clear", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_clear, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_isEmpty, METH_NOARGS},
    {"properties", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_properties, METH_NOARGS},
    {"removeProperties", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_removeProperties, METH_O},
    {"removeProperty", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_removeProperty, METH_O},
    {"setType", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_setType, METH_O},
    {"type", (PyCFunction)SbkQtMobility_QVersitDocumentFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QVersitDocument_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QVersitDocument& cpp_self = *Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QVersitDocument & >::isConvertible(other)) {
                // operator!=(const QtMobility::QVersitDocument & other) const
                QtMobility::QVersitDocument* cpp_other = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QVersitDocument  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QVersitDocument >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QVersitDocument > cpp_other_auto_ptr;
                QtMobility::QVersitDocument* cpp_other = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QVersitDocument_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QVersitDocument & >::isConvertible(other)) {
                // operator==(const QtMobility::QVersitDocument & other) const
                QtMobility::QVersitDocument* cpp_other = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QVersitDocument  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QVersitDocument >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QVersitDocument > cpp_other_auto_ptr;
                QtMobility::QVersitDocument* cpp_other = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QVersitDocument_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QVersitDocument_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QVersitDocument_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QVersitDocument >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitDocument_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitDocument",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QVersitDocument_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QVersitDocument_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitDocument_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitDocument_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitDocument >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitDocument",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "VersitType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QVersitDocument(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITDOCUMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitDocument_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitDocument_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitDocument_Type));
    PyModule_AddObject(module, "QVersitDocument",
        ((PyObject*)&SbkQtMobility_QVersitDocument_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: VersitType
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITDOCUMENT_VERSITTYPE_IDX] = &SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type);
    PyDict_SetItemString(SbkQtMobility_QVersitDocument_Type.super.ht_type.tp_dict,
            "VersitType",((PyObject*)&SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type,
        (long) QtMobility::QVersitDocument::InvalidType, "InvalidType");
    PyDict_SetItemString(SbkQtMobility_QVersitDocument_Type.super.ht_type.tp_dict,
        "InvalidType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type.tp_dict,
        "InvalidType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type,
        (long) QtMobility::QVersitDocument::VCard21Type, "VCard21Type");
    PyDict_SetItemString(SbkQtMobility_QVersitDocument_Type.super.ht_type.tp_dict,
        "VCard21Type", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type.tp_dict,
        "VCard21Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type,
        (long) QtMobility::QVersitDocument::VCard30Type, "VCard30Type");
    PyDict_SetItemString(SbkQtMobility_QVersitDocument_Type.super.ht_type.tp_dict,
        "VCard30Type", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitDocument_VersitType_Type.tp_dict,
        "VCard30Type", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QVersitDocument::VersitType");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitDocument >("QtMobility::QVersitDocument");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitDocument >("QtMobility::QVersitDocument*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitDocument >(typeid(QtMobility::QVersitDocument).name());
    PySide::initQtMetaType<QtMobility::QVersitDocument >();
}

