/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitcontactexporterdetailhandler_wrapper.h"

// Extra includes
#include <qcontact.h>
#include <qcontactdetail.h>
#include <qversitdocument.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QVersitContactExporterDetailHandlerWrapper::QVersitContactExporterDetailHandlerWrapper() : QtMobility::QVersitContactExporterDetailHandler() {
    // ... middle
}

bool QVersitContactExporterDetailHandlerWrapper::postProcessDetail(const QtMobility::QContact & contact, const QtMobility::QContactDetail & detail, bool alreadyProcessed, QtMobility::QVersitDocument * document)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "postProcessDetail"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactExporterDetailHandler.postProcessDetail()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNNN)",
        Shiboken::Converter<const QtMobility::QContact & >::toPython(contact),
        Shiboken::Converter<const QtMobility::QContactDetail & >::toPython(detail),
        Shiboken::Converter<bool >::toPython(alreadyProcessed),
        Shiboken::Converter<QtMobility::QVersitDocument * >::toPython(document)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitContactExporterDetailHandler.postProcessDetail", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QVersitContactExporterDetailHandlerWrapper::preProcessDetail(const QtMobility::QContact & contact, const QtMobility::QContactDetail & detail, QtMobility::QVersitDocument * document)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "preProcessDetail"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactExporterDetailHandler.preProcessDetail()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<const QtMobility::QContact & >::toPython(contact),
        Shiboken::Converter<const QtMobility::QContactDetail & >::toPython(detail),
        Shiboken::Converter<QtMobility::QVersitDocument * >::toPython(document)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitContactExporterDetailHandler.preProcessDetail", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QVersitContactExporterDetailHandlerWrapper::~QVersitContactExporterDetailHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitContactExporterDetailHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitContactExporterDetailHandler >()))
        return -1;

    QVersitContactExporterDetailHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTERDETAILHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QVersitContactExporterDetailHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QVersitContactExporterDetailHandler()
            cptr = new QVersitContactExporterDetailHandlerWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitContactExporterDetailHandler >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QVersitContactExporterDetailHandlerFunc_postProcessDetail(PyObject* self, PyObject* args)
{
    QtMobility::QVersitContactExporterDetailHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporterDetailHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "postProcessDetail", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: postProcessDetail(QtMobility::QContact,QtMobility::QContactDetail,bool,QtMobility::QVersitDocument*)
    if (numArgs == 4 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(pyargs[1]) && SbkNumber_Check(pyargs[2]) && Shiboken::Converter<QtMobility::QVersitDocument * >::isConvertible(pyargs[3])) {
        overloadId = 0; // postProcessDetail(QtMobility::QContact,QtMobility::QContactDetail,bool,QtMobility::QVersitDocument*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactExporterDetailHandlerFunc_postProcessDetail_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContactDetail* cpp_arg1 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[1]);
            bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            std::auto_ptr<QtMobility::QVersitDocument > cpp_arg3_auto_ptr;
            QtMobility::QVersitDocument* cpp_arg3 = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(pyargs[3]);
            if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(pyargs[3]))
                cpp_arg3_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_arg3);

            if(!PyErr_Occurred()) {
            // postProcessDetail(QtMobility::QContact,QtMobility::QContactDetail,bool,QtMobility::QVersitDocument*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactExporterDetailHandler.postProcessDetail()' not implemented.");
                return 0;
            }
            bool cppResult = cppSelf->postProcessDetail(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitContactExporterDetailHandlerFunc_postProcessDetail_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContactDetail, bool, QtMobility.Versit.QtMobility::QVersitDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactExporterDetailHandler.postProcessDetail", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitContactExporterDetailHandlerFunc_preProcessDetail(PyObject* self, PyObject* args)
{
    QtMobility::QVersitContactExporterDetailHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporterDetailHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "preProcessDetail", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: preProcessDetail(QtMobility::QContact,QtMobility::QContactDetail,QtMobility::QVersitDocument*)
    if (numArgs == 3 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QVersitDocument * >::isConvertible(pyargs[2])) {
        overloadId = 0; // preProcessDetail(QtMobility::QContact,QtMobility::QContactDetail,QtMobility::QVersitDocument*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactExporterDetailHandlerFunc_preProcessDetail_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContactDetail* cpp_arg1 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QtMobility::QVersitDocument > cpp_arg2_auto_ptr;
            QtMobility::QVersitDocument* cpp_arg2 = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(pyargs[2]);
            if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_arg2);

            if(!PyErr_Occurred()) {
            // preProcessDetail(QtMobility::QContact,QtMobility::QContactDetail,QtMobility::QVersitDocument*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactExporterDetailHandler.preProcessDetail()' not implemented.");
                return 0;
            }
            bool cppResult = cppSelf->preProcessDetail(*cpp_arg0, *cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitContactExporterDetailHandlerFunc_preProcessDetail_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContactDetail, QtMobility.Versit.QtMobility::QVersitDocument", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactExporterDetailHandler.preProcessDetail", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitContactExporterDetailHandler_methods[] = {
    {"postProcessDetail", (PyCFunction)SbkQtMobility_QVersitContactExporterDetailHandlerFunc_postProcessDetail, METH_VARARGS},
    {"preProcessDetail", (PyCFunction)SbkQtMobility_QVersitContactExporterDetailHandlerFunc_preProcessDetail, METH_VARARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitContactExporterDetailHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitContactExporterDetailHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitContactExporterDetailHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitContactExporterDetailHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitContactExporterDetailHandler >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitContactExporterDetailHandler*",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QVersitContactExporterDetailHandler(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTERDETAILHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitContactExporterDetailHandler_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitContactExporterDetailHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitContactExporterDetailHandler_Type));
    PyModule_AddObject(module, "QVersitContactExporterDetailHandler",
        ((PyObject*)&SbkQtMobility_QVersitContactExporterDetailHandler_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactExporterDetailHandler >("QtMobility::QVersitContactExporterDetailHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactExporterDetailHandler >(typeid(QtMobility::QVersitContactExporterDetailHandler).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactExporterDetailHandler >(typeid(QVersitContactExporterDetailHandlerWrapper).name());
    PySide::initQtMetaType<QtMobility::QVersitContactExporterDetailHandler* >();
}

