/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitcontactexporter_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <qcontact.h>
#include <qversitcontactexporter.h>
#include <qversitdocument.h>
#include <qversitresourcehandler.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitContactExporter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitContactExporter >()))
        return -1;

    QtMobility::QVersitContactExporter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersitContactExporter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QVersitContactExporter(QtMobility::QVersitContactExporter)
    // 1: QVersitContactExporter()
    if (numArgs == 0) {
        overloadId = 1; // QVersitContactExporter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QVersitContactExporter & >::isConvertible(arg)) {
        overloadId = 0; // QVersitContactExporter(QtMobility::QVersitContactExporter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactExporter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QVersitContactExporter(QtMobility::QVersitContactExporter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QVersitContactExporter* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QVersitContactExporter(QtMobility::QVersitContactExporter)
                cptr = new QtMobility::QVersitContactExporter(*cpp_arg0);
                }
                break;
            }
            case 1: // QVersitContactExporter()
            {

                if(!PyErr_Occurred()) {
                // QVersitContactExporter()
                cptr = new QtMobility::QVersitContactExporter();
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitContactExporter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QVersitContactExporter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QVersitContactExporter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitContactExporter", "", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactExporter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_detailHandler(PyObject* self)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailHandler()const
            QtMobility::QVersitContactExporterDetailHandler * cppResult = cppSelf->QtMobility::QVersitContactExporter::detailHandler();
            pyResult = Shiboken::Converter<QtMobility::QVersitContactExporterDetailHandler * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_documents(PyObject* self)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // documents()const
            QList<QtMobility::QVersitDocument > cppResult = cppSelf->QtMobility::QVersitContactExporter::documents();
            pyResult = Shiboken::Converter<QList<QtMobility::QVersitDocument > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_errors(PyObject* self)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // errors()const
            QMap<int, QtMobility::QVersitContactExporter::Error > cppResult = cppSelf->QtMobility::QVersitContactExporter::errors();
            pyResult = Shiboken::Converter<QMap<int, QtMobility::QVersitContactExporter::Error > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_exportContacts(PyObject* self, PyObject* args)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "exportContacts", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: exportContacts(QList<QtMobility::QContact>,QtMobility::QVersitDocument::VersitType)
    if (numArgs == 2 && Shiboken::Converter< QList<QtMobility::QContact >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::isConvertible(pyargs[1])) {
        overloadId = 0; // exportContacts(QList<QtMobility::QContact>,QtMobility::QVersitDocument::VersitType)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactExporterFunc_exportContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContact > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContact > >::toCpp(pyargs[0]);
            QtMobility::QVersitDocument::VersitType cpp_arg1 = Shiboken::Converter<QtMobility::QVersitDocument::VersitType >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // exportContacts(QList<QtMobility::QContact>,QtMobility::QVersitDocument::VersitType)
            bool cppResult = cppSelf->QtMobility::QVersitContactExporter::exportContacts(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitContactExporterFunc_exportContacts_TypeError:
        const char* overloads[] = {"list, QtMobility.Versit.QtMobility::QVersitDocument.VersitType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactExporter.exportContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_resourceHandler(PyObject* self)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // resourceHandler()const
            QtMobility::QVersitResourceHandler * cppResult = cppSelf->QtMobility::QVersitContactExporter::resourceHandler();
            pyResult = Shiboken::Converter<QtMobility::QVersitResourceHandler * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_setDetailHandler(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDetailHandler(QtMobility::QVersitContactExporterDetailHandler*)
    if (Shiboken::Converter<QtMobility::QVersitContactExporterDetailHandler * >::isConvertible(arg)) {
        overloadId = 0; // setDetailHandler(QtMobility::QVersitContactExporterDetailHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactExporterFunc_setDetailHandler_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QVersitContactExporterDetailHandler* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitContactExporterDetailHandler* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDetailHandler(QtMobility::QVersitContactExporterDetailHandler*)
            cppSelf->QtMobility::QVersitContactExporter::setDetailHandler(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitContactExporterFunc_setDetailHandler_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitContactExporterDetailHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitContactExporter.setDetailHandler", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitContactExporterFunc_setResourceHandler(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitContactExporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactExporter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setResourceHandler(QtMobility::QVersitResourceHandler*)
    if (Shiboken::Converter<QtMobility::QVersitResourceHandler * >::isConvertible(arg)) {
        overloadId = 0; // setResourceHandler(QtMobility::QVersitResourceHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactExporterFunc_setResourceHandler_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QVersitResourceHandler* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitResourceHandler* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setResourceHandler(QtMobility::QVersitResourceHandler*)
            cppSelf->QtMobility::QVersitContactExporter::setResourceHandler(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitContactExporterFunc_setResourceHandler_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitResourceHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitContactExporter.setResourceHandler", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitContactExporter_methods[] = {
    {"detailHandler", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_detailHandler, METH_NOARGS},
    {"documents", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_documents, METH_NOARGS},
    {"errors", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_errors, METH_NOARGS},
    {"exportContacts", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_exportContacts, METH_VARARGS},
    {"resourceHandler", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_resourceHandler, METH_NOARGS},
    {"setDetailHandler", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_setDetailHandler, METH_O},
    {"setResourceHandler", (PyCFunction)SbkQtMobility_QVersitContactExporterFunc_setResourceHandler, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitContactExporter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitContactExporter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitContactExporter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitContactExporter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitContactExporter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitContactExporter",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QVersitContactExporter(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitContactExporter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitContactExporter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitContactExporter_Type));
    PyModule_AddObject(module, "QVersitContactExporter",
        ((PyObject*)&SbkQtMobility_QVersitContactExporter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTEXPORTER_ERROR_IDX] = &SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type);
    PyDict_SetItemString(SbkQtMobility_QVersitContactExporter_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type,
        (long) QtMobility::QVersitContactExporter::NoError, "NoError");
    PyDict_SetItemString(SbkQtMobility_QVersitContactExporter_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type,
        (long) QtMobility::QVersitContactExporter::EmptyContactError, "EmptyContactError");
    PyDict_SetItemString(SbkQtMobility_QVersitContactExporter_Type.super.ht_type.tp_dict,
        "EmptyContactError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type.tp_dict,
        "EmptyContactError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type,
        (long) QtMobility::QVersitContactExporter::NoNameError, "NoNameError");
    PyDict_SetItemString(SbkQtMobility_QVersitContactExporter_Type.super.ht_type.tp_dict,
        "NoNameError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitContactExporter_Error_Type.tp_dict,
        "NoNameError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QVersitContactExporter::Error");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitContactExporter >("QtMobility::QVersitContactExporter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactExporter >("QtMobility::QVersitContactExporter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitContactExporter >(typeid(QtMobility::QVersitContactExporter).name());
    PySide::initQtMetaType<QtMobility::QVersitContactExporter >();
}

