/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <Python.h>
#include <shiboken.h>
#include <algorithm>
#include "qtmobility_systeminfo_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef SystemInfo_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtMobility_QSystemScreenSaver(PyObject* module);
void init_QtMobility_QSystemDeviceInfo(PyObject* module);
void init_QtMobility_QSystemStorageInfo(PyObject* module);
void init_QtMobility_QSystemDisplayInfo(PyObject* module);
void init_QtMobility_QSystemNetworkInfo(PyObject* module);
void init_QtMobility_QSystemInfo(PyObject* module);

PyTypeObject** SbkQtMobility_SystemInfoTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

PyTypeObject** SbkPySide_QtNetworkTypes;

// Module initialization ------------------------------------------------------------

#if defined _WIN32 || defined __CYGWIN__
    #define SBK_EXPORT_MODULE __declspec(dllexport)
#elif __GNUC__ >= 4
    #define SBK_EXPORT_MODULE __attribute__ ((visibility("default")))
#else
    #define SBK_EXPORT_MODULE
#endif

extern "C" SBK_EXPORT_MODULE void initSystemInfo()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    if (!Shiboken::importModule("PySide.QtNetwork", &SbkPySide_QtNetworkTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtNetwork");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("SystemInfo", SystemInfo_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_SystemInfo_IDX_COUNT];
    SbkQtMobility_SystemInfoTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QtMobility_QSystemScreenSaver(module);
    init_QtMobility_QSystemDeviceInfo(module);
    init_QtMobility_QSystemStorageInfo(module);
    init_QtMobility_QSystemDisplayInfo(module);
    init_QtMobility_QSystemNetworkInfo(module);
    init_QtMobility_QSystemInfo(module);

    // Register primitive types on TypeResolver

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module SystemInfo");
    }
}

