/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_systeminfo_python.h"

#include "qtmobility_qsystemnetworkinfo_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qnetworkinterface.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QSystemNetworkInfoWrapper::QSystemNetworkInfoWrapper(QObject * parent) : QtMobility::QSystemNetworkInfo(parent), m_metaObject(0) {
    // ... middle
}

void QSystemNetworkInfoWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemNetworkInfoWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QSystemNetworkInfo::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSystemNetworkInfoWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemNetworkInfoWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QSystemNetworkInfo::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QSystemNetworkInfoWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemNetworkInfo.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QSystemNetworkInfoWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemNetworkInfo.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QSystemNetworkInfoWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSystemNetworkInfoWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QSystemNetworkInfo::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QSystemNetworkInfoWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QSystemNetworkInfo::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSystemNetworkInfoWrapper::~QSystemNetworkInfoWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSystemNetworkInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSystemNetworkInfo >()))
        return -1;

    QSystemNetworkInfoWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QSystemNetworkInfo", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QSystemNetworkInfo(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSystemNetworkInfo(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QSystemNetworkInfo(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfo_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.SystemInfo.QSystemNetworkInfo(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QSystemNetworkInfo(QObject*)
            cptr = new QSystemNetworkInfoWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSystemNetworkInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QSystemNetworkInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QSystemNetworkInfo_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.SystemInfo.QSystemNetworkInfo", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_cellId(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // cellId()
            int cppResult = cppSelf->QtMobility::QSystemNetworkInfo::cellId();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_connectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: connectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // connectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_connectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // connectNotify(const char*)
            cppSelf->QtMobility::QSystemNetworkInfo::connectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSystemNetworkInfoFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.connectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_currentMobileCountryCode(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentMobileCountryCode()
            QString cppResult = cppSelf->QtMobility::QSystemNetworkInfo::currentMobileCountryCode();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_currentMobileNetworkCode(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentMobileNetworkCode()
            QString cppResult = cppSelf->QtMobility::QSystemNetworkInfo::currentMobileNetworkCode();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_currentMode(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentMode()
            QtMobility::QSystemNetworkInfo::NetworkMode cppResult = cppSelf->QtMobility::QSystemNetworkInfo::currentMode();
            pyResult = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_disconnectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: disconnectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // disconnectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_disconnectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // disconnectNotify(const char*)
            cppSelf->QtMobility::QSystemNetworkInfo::disconnectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSystemNetworkInfoFunc_disconnectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.disconnectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_homeMobileCountryCode(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // homeMobileCountryCode()
            QString cppResult = cppSelf->QtMobility::QSystemNetworkInfo::homeMobileCountryCode();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_homeMobileNetworkCode(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // homeMobileNetworkCode()
            QString cppResult = cppSelf->QtMobility::QSystemNetworkInfo::homeMobileNetworkCode();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_interfaceForMode(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: interfaceForMode(QtMobility::QSystemNetworkInfo::NetworkMode)
    if (Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::isConvertible(arg)) {
        overloadId = 0; // interfaceForMode(QtMobility::QSystemNetworkInfo::NetworkMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_interfaceForMode_TypeError;

    // Call function/method
    {
        {
            QtMobility::QSystemNetworkInfo::NetworkMode cpp_arg0 = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // interfaceForMode(QtMobility::QSystemNetworkInfo::NetworkMode)
            QNetworkInterface cppResult = cppSelf->QtMobility::QSystemNetworkInfo::interfaceForMode(cpp_arg0);
            pyResult = Shiboken::Converter<QNetworkInterface >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemNetworkInfoFunc_interfaceForMode_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemNetworkInfo.NetworkMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.interfaceForMode", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_locationAreaCode(PyObject* self)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // locationAreaCode()
            int cppResult = cppSelf->QtMobility::QSystemNetworkInfo::locationAreaCode();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_macAddress(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: macAddress(QtMobility::QSystemNetworkInfo::NetworkMode)
    if (Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::isConvertible(arg)) {
        overloadId = 0; // macAddress(QtMobility::QSystemNetworkInfo::NetworkMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_macAddress_TypeError;

    // Call function/method
    {
        {
            QtMobility::QSystemNetworkInfo::NetworkMode cpp_arg0 = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // macAddress(QtMobility::QSystemNetworkInfo::NetworkMode)
            QString cppResult = cppSelf->QtMobility::QSystemNetworkInfo::macAddress(cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemNetworkInfoFunc_macAddress_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemNetworkInfo.NetworkMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.macAddress", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_networkName(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: networkName(QtMobility::QSystemNetworkInfo::NetworkMode)
    if (Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::isConvertible(arg)) {
        overloadId = 0; // networkName(QtMobility::QSystemNetworkInfo::NetworkMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_networkName_TypeError;

    // Call function/method
    {
        {
            QtMobility::QSystemNetworkInfo::NetworkMode cpp_arg0 = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // networkName(QtMobility::QSystemNetworkInfo::NetworkMode)
            QString cppResult = QtMobility::QSystemNetworkInfo::networkName(cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemNetworkInfoFunc_networkName_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemNetworkInfo.NetworkMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.networkName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_networkSignalStrength(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: networkSignalStrength(QtMobility::QSystemNetworkInfo::NetworkMode)
    if (Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::isConvertible(arg)) {
        overloadId = 0; // networkSignalStrength(QtMobility::QSystemNetworkInfo::NetworkMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_networkSignalStrength_TypeError;

    // Call function/method
    {
        {
            QtMobility::QSystemNetworkInfo::NetworkMode cpp_arg0 = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // networkSignalStrength(QtMobility::QSystemNetworkInfo::NetworkMode)
            int cppResult = QtMobility::QSystemNetworkInfo::networkSignalStrength(cpp_arg0);
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemNetworkInfoFunc_networkSignalStrength_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemNetworkInfo.NetworkMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.networkSignalStrength", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemNetworkInfoFunc_networkStatus(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemNetworkInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemNetworkInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: networkStatus(QtMobility::QSystemNetworkInfo::NetworkMode)
    if (Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::isConvertible(arg)) {
        overloadId = 0; // networkStatus(QtMobility::QSystemNetworkInfo::NetworkMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemNetworkInfoFunc_networkStatus_TypeError;

    // Call function/method
    {
        {
            QtMobility::QSystemNetworkInfo::NetworkMode cpp_arg0 = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkMode >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // networkStatus(QtMobility::QSystemNetworkInfo::NetworkMode)
            QtMobility::QSystemNetworkInfo::NetworkStatus cppResult = cppSelf->QtMobility::QSystemNetworkInfo::networkStatus(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QSystemNetworkInfo::NetworkStatus >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemNetworkInfoFunc_networkStatus_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemNetworkInfo.NetworkMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemNetworkInfo.networkStatus", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QSystemNetworkInfo_methods[] = {
    {"cellId", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_cellId, METH_NOARGS},
    {"connectNotify", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_connectNotify, METH_O},
    {"currentMobileCountryCode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_currentMobileCountryCode, METH_NOARGS},
    {"currentMobileNetworkCode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_currentMobileNetworkCode, METH_NOARGS},
    {"currentMode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_currentMode, METH_NOARGS},
    {"disconnectNotify", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_disconnectNotify, METH_O},
    {"homeMobileCountryCode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_homeMobileCountryCode, METH_NOARGS},
    {"homeMobileNetworkCode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_homeMobileNetworkCode, METH_NOARGS},
    {"interfaceForMode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_interfaceForMode, METH_O},
    {"locationAreaCode", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_locationAreaCode, METH_NOARGS},
    {"macAddress", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_macAddress, METH_O},
    {"networkName", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_networkName, METH_O|METH_STATIC},
    {"networkSignalStrength", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_networkSignalStrength, METH_O|METH_STATIC},
    {"networkStatus", (PyCFunction)SbkQtMobility_QSystemNetworkInfoFunc_networkStatus, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSystemNetworkInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.SystemInfo.QSystemNetworkInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSystemNetworkInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSystemNetworkInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSystemNetworkInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSystemNetworkInfo*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QSystemNetworkInfo_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QSystemNetworkInfo*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QSystemNetworkInfo_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NetworkMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NetworkStatus",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QSystemNetworkInfo(PyObject* module)
{
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMNETWORKINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSystemNetworkInfo_Type);

    SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QSystemNetworkInfo_Type.type_discovery = &SbkQtMobility_QSystemNetworkInfo_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QSystemNetworkInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSystemNetworkInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSystemNetworkInfo_Type));
    PyModule_AddObject(module, "QSystemNetworkInfo",
        ((PyObject*)&SbkQtMobility_QSystemNetworkInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: NetworkMode
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMNETWORKINFO_NETWORKMODE_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
            "NetworkMode",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::UnknownMode, "UnknownMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "UnknownMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "UnknownMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::GsmMode, "GsmMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "GsmMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "GsmMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::CdmaMode, "CdmaMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "CdmaMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "CdmaMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::WcdmaMode, "WcdmaMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "WcdmaMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "WcdmaMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::WlanMode, "WlanMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "WlanMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "WlanMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::EthernetMode, "EthernetMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "EthernetMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "EthernetMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::BluetoothMode, "BluetoothMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "BluetoothMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "BluetoothMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type,
        (long) QtMobility::QSystemNetworkInfo::WimaxMode, "WimaxMode");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "WimaxMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkMode_Type.tp_dict,
        "WimaxMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemNetworkInfo::NetworkMode");

    // init enum class: NetworkStatus
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMNETWORKINFO_NETWORKSTATUS_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
            "NetworkStatus",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::UndefinedStatus, "UndefinedStatus");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "UndefinedStatus", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "UndefinedStatus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::NoNetworkAvailable, "NoNetworkAvailable");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "NoNetworkAvailable", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "NoNetworkAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::EmergencyOnly, "EmergencyOnly");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "EmergencyOnly", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "EmergencyOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::Searching, "Searching");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "Searching", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "Searching", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::Busy, "Busy");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "Busy", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "Busy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::Connected, "Connected");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "Connected", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "Connected", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::HomeNetwork, "HomeNetwork");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "HomeNetwork", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "HomeNetwork", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::Denied, "Denied");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "Denied", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "Denied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type,
        (long) QtMobility::QSystemNetworkInfo::Roaming, "Roaming");
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict,
        "Roaming", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemNetworkInfo_NetworkStatus_Type.tp_dict,
        "Roaming", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemNetworkInfo::NetworkStatus");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("currentMobileNetworkCodeChanged", "const QString&", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict, "currentMobileNetworkCodeChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("currentMobileCountryCodeChanged", "const QString&", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict, "currentMobileCountryCodeChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("networkNameChanged", "QtMobility::QSystemNetworkInfo::NetworkMode,const QString&", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict, "networkNameChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("networkModeChanged", "QtMobility::QSystemNetworkInfo::NetworkMode", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict, "networkModeChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("networkSignalStrengthChanged", "QtMobility::QSystemNetworkInfo::NetworkMode,int", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict, "networkSignalStrengthChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("networkStatusChanged", "QtMobility::QSystemNetworkInfo::NetworkMode,QtMobility::QSystemNetworkInfo::NetworkStatus", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemNetworkInfo_Type.super.ht_type.tp_dict, "networkStatusChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemNetworkInfo >("QtMobility::QSystemNetworkInfo*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemNetworkInfo >(typeid(QtMobility::QSystemNetworkInfo).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemNetworkInfo >(typeid(QSystemNetworkInfoWrapper).name());
    PySide::initQtMetaType<QtMobility::QSystemNetworkInfo* >();
}

