/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_systeminfo_python.h"

#include "qtmobility_qsystemdeviceinfo_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QSystemDeviceInfoWrapper::QSystemDeviceInfoWrapper(QObject * parent) : QtMobility::QSystemDeviceInfo(parent), m_metaObject(0) {
    // ... middle
}

void QSystemDeviceInfoWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemDeviceInfoWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QSystemDeviceInfo::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSystemDeviceInfoWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemDeviceInfoWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QSystemDeviceInfo::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QSystemDeviceInfoWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemDeviceInfo.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QSystemDeviceInfoWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemDeviceInfo.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QSystemDeviceInfoWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSystemDeviceInfoWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QSystemDeviceInfo::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QSystemDeviceInfoWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QSystemDeviceInfo::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSystemDeviceInfoWrapper::~QSystemDeviceInfoWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSystemDeviceInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSystemDeviceInfo >()))
        return -1;

    QSystemDeviceInfoWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QSystemDeviceInfo", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QSystemDeviceInfo(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSystemDeviceInfo(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QSystemDeviceInfo(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemDeviceInfo_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.SystemInfo.QSystemDeviceInfo(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QSystemDeviceInfo(QObject*)
            cptr = new QSystemDeviceInfoWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSystemDeviceInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QSystemDeviceInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QSystemDeviceInfo_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.SystemInfo.QSystemDeviceInfo", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_batteryLevel(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // batteryLevel()const
            int cppResult = cppSelf->QtMobility::QSystemDeviceInfo::batteryLevel();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_batteryStatus(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // batteryStatus()
            QtMobility::QSystemDeviceInfo::BatteryStatus cppResult = cppSelf->QtMobility::QSystemDeviceInfo::batteryStatus();
            pyResult = Shiboken::Converter<QtMobility::QSystemDeviceInfo::BatteryStatus >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_connectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: connectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // connectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemDeviceInfoFunc_connectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // connectNotify(const char*)
            cppSelf->QtMobility::QSystemDeviceInfo::connectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSystemDeviceInfoFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemDeviceInfo.connectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_currentPowerState(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentPowerState()
            QtMobility::QSystemDeviceInfo::PowerState cppResult = cppSelf->QtMobility::QSystemDeviceInfo::currentPowerState();
            pyResult = Shiboken::Converter<QtMobility::QSystemDeviceInfo::PowerState >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_currentProfile(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentProfile()
            QtMobility::QSystemDeviceInfo::Profile cppResult = cppSelf->QtMobility::QSystemDeviceInfo::currentProfile();
            pyResult = Shiboken::Converter<QtMobility::QSystemDeviceInfo::Profile >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_disconnectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: disconnectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // disconnectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemDeviceInfoFunc_disconnectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // disconnectNotify(const char*)
            cppSelf->QtMobility::QSystemDeviceInfo::disconnectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSystemDeviceInfoFunc_disconnectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemDeviceInfo.disconnectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_imei(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // imei()
            QString cppResult = cppSelf->QtMobility::QSystemDeviceInfo::imei();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_imsi(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // imsi()
            QString cppResult = cppSelf->QtMobility::QSystemDeviceInfo::imsi();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_inputMethodType(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // inputMethodType()
            QFlags<QtMobility::QSystemDeviceInfo::InputMethod> cppResult = cppSelf->QtMobility::QSystemDeviceInfo::inputMethodType();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QSystemDeviceInfo::InputMethod> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_isDeviceLocked(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isDeviceLocked()
            bool cppResult = cppSelf->QtMobility::QSystemDeviceInfo::isDeviceLocked();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_manufacturer(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // manufacturer()
            QString cppResult = cppSelf->QtMobility::QSystemDeviceInfo::manufacturer();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_model(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // model()
            QString cppResult = cppSelf->QtMobility::QSystemDeviceInfo::model();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_productName(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // productName()
            QString cppResult = cppSelf->QtMobility::QSystemDeviceInfo::productName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemDeviceInfoFunc_simStatus(PyObject* self)
{
    QtMobility::QSystemDeviceInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemDeviceInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // simStatus()
            QtMobility::QSystemDeviceInfo::SimStatus cppResult = cppSelf->QtMobility::QSystemDeviceInfo::simStatus();
            pyResult = Shiboken::Converter<QtMobility::QSystemDeviceInfo::SimStatus >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QSystemDeviceInfo_methods[] = {
    {"batteryLevel", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_batteryLevel, METH_NOARGS},
    {"batteryStatus", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_batteryStatus, METH_NOARGS},
    {"connectNotify", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_connectNotify, METH_O},
    {"currentPowerState", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_currentPowerState, METH_NOARGS},
    {"currentProfile", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_currentProfile, METH_NOARGS},
    {"disconnectNotify", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_disconnectNotify, METH_O},
    {"imei", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_imei, METH_NOARGS},
    {"imsi", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_imsi, METH_NOARGS},
    {"inputMethodType", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_inputMethodType, METH_NOARGS},
    {"isDeviceLocked", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_isDeviceLocked, METH_NOARGS},
    {"manufacturer", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_manufacturer, METH_NOARGS},
    {"model", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_model, METH_NOARGS},
    {"productName", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_productName, METH_NOARGS},
    {"simStatus", (PyCFunction)SbkQtMobility_QSystemDeviceInfoFunc_simStatus, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSystemDeviceInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.SystemInfo.QSystemDeviceInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSystemDeviceInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSystemDeviceInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSystemDeviceInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSystemDeviceInfo*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QSystemDeviceInfo_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QSystemDeviceInfo*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QSystemDeviceInfo_Type;
    return 0;
}

PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::checkType(self) && Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toPython(
        Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags>::toCpp(self)
        & Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::checkType(self) && Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toPython(
        Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags>::toCpp(self)
        | Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::checkType(self) && Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toPython(
        Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QSystemDeviceInfo::InputMethodFlags >::toPython(
        ~Shiboken::Converter<QtMobility::QSystemDeviceInfo::InputMethodFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputMethod",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethodFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InputMethodFlags",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};


static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Profile",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SimStatus",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PowerState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BatteryStatus",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QSystemDeviceInfo(PyObject* module)
{
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSystemDeviceInfo_Type);

    SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QSystemDeviceInfo_Type.type_discovery = &SbkQtMobility_QSystemDeviceInfo_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QSystemDeviceInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSystemDeviceInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSystemDeviceInfo_Type));
    PyModule_AddObject(module, "QSystemDeviceInfo",
        ((PyObject*)&SbkQtMobility_QSystemDeviceInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: InputMethod
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_INPUTMETHOD_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
            "InputMethod",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type));

    // init flags class: QFlags<QtMobility::QSystemDeviceInfo::InputMethod>
    SbkQtMobility_SystemInfoTypes[SBK_QFLAGS_QTMOBILITY_QSYSTEMDEVICEINFO_INPUTMETHOD__IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethodFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethodFlags_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethodFlags_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
            "InputMethodFlags",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethodFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type,
        (long) QtMobility::QSystemDeviceInfo::Keys, "Keys");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "Keys", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_dict,
        "Keys", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type,
        (long) QtMobility::QSystemDeviceInfo::Keypad, "Keypad");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "Keypad", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_dict,
        "Keypad", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type,
        (long) QtMobility::QSystemDeviceInfo::Keyboard, "Keyboard");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "Keyboard", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_dict,
        "Keyboard", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type,
        (long) QtMobility::QSystemDeviceInfo::SingleTouch, "SingleTouch");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "SingleTouch", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_dict,
        "SingleTouch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type,
        (long) QtMobility::QSystemDeviceInfo::MultiTouch, "MultiTouch");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "MultiTouch", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_dict,
        "MultiTouch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type,
        (long) QtMobility::QSystemDeviceInfo::Mouse, "Mouse");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "Mouse", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_InputMethod_Type.tp_dict,
        "Mouse", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemDeviceInfo::InputMethod");

    // init enum class: Profile
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_PROFILE_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
            "Profile",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::UnknownProfile, "UnknownProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "UnknownProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "UnknownProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::SilentProfile, "SilentProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "SilentProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "SilentProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::NormalProfile, "NormalProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "NormalProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "NormalProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::LoudProfile, "LoudProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "LoudProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "LoudProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::VibProfile, "VibProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "VibProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "VibProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::OfflineProfile, "OfflineProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "OfflineProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "OfflineProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::PowersaveProfile, "PowersaveProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "PowersaveProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "PowersaveProfile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type,
        (long) QtMobility::QSystemDeviceInfo::CustomProfile, "CustomProfile");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "CustomProfile", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_Profile_Type.tp_dict,
        "CustomProfile", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemDeviceInfo::Profile");

    // init enum class: SimStatus
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_SIMSTATUS_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
            "SimStatus",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::SimNotAvailable, "SimNotAvailable");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "SimNotAvailable", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type.tp_dict,
        "SimNotAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::SingleSimAvailable, "SingleSimAvailable");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "SingleSimAvailable", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type.tp_dict,
        "SingleSimAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::DualSimAvailable, "DualSimAvailable");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "DualSimAvailable", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type.tp_dict,
        "DualSimAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::SimLocked, "SimLocked");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "SimLocked", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_SimStatus_Type.tp_dict,
        "SimLocked", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemDeviceInfo::SimStatus");

    // init enum class: PowerState
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_POWERSTATE_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
            "PowerState",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type,
        (long) QtMobility::QSystemDeviceInfo::UnknownPower, "UnknownPower");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "UnknownPower", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type.tp_dict,
        "UnknownPower", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type,
        (long) QtMobility::QSystemDeviceInfo::BatteryPower, "BatteryPower");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "BatteryPower", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type.tp_dict,
        "BatteryPower", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type,
        (long) QtMobility::QSystemDeviceInfo::WallPower, "WallPower");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "WallPower", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type.tp_dict,
        "WallPower", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type,
        (long) QtMobility::QSystemDeviceInfo::WallPowerChargingBattery, "WallPowerChargingBattery");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "WallPowerChargingBattery", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_PowerState_Type.tp_dict,
        "WallPowerChargingBattery", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemDeviceInfo::PowerState");

    // init enum class: BatteryStatus
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_BATTERYSTATUS_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
            "BatteryStatus",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::NoBatteryLevel, "NoBatteryLevel");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "NoBatteryLevel", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type.tp_dict,
        "NoBatteryLevel", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::BatteryCritical, "BatteryCritical");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "BatteryCritical", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type.tp_dict,
        "BatteryCritical", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::BatteryVeryLow, "BatteryVeryLow");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "BatteryVeryLow", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type.tp_dict,
        "BatteryVeryLow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::BatteryLow, "BatteryLow");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "BatteryLow", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type.tp_dict,
        "BatteryLow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type,
        (long) QtMobility::QSystemDeviceInfo::BatteryNormal, "BatteryNormal");
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict,
        "BatteryNormal", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemDeviceInfo_BatteryStatus_Type.tp_dict,
        "BatteryNormal", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemDeviceInfo::BatteryStatus");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("batteryStatusChanged", "QtMobility::QSystemDeviceInfo::BatteryStatus", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict, "batteryStatusChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("currentProfileChanged", "QtMobility::QSystemDeviceInfo::Profile", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict, "currentProfileChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("batteryLevelChanged", "int", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict, "batteryLevelChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("bluetoothStateChanged", "bool", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict, "bluetoothStateChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("powerStateChanged", "QtMobility::QSystemDeviceInfo::PowerState", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemDeviceInfo_Type.super.ht_type.tp_dict, "powerStateChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemDeviceInfo >("QtMobility::QSystemDeviceInfo*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemDeviceInfo >(typeid(QtMobility::QSystemDeviceInfo).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemDeviceInfo >(typeid(QSystemDeviceInfoWrapper).name());
    PySide::initQtMetaType<QtMobility::QSystemDeviceInfo* >();
}

