/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_serviceframework_python.h"

#include "qtmobility_qservicemanager_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qabstractsecuritysession.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qservicecontext.h>
#include <qservicefilter.h>
#include <qserviceinterfacedescriptor.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QServiceManagerWrapper::QServiceManagerWrapper(QObject * parent) : QtMobility::QServiceManager(parent), m_metaObject(0) {
    // ... middle
}

QServiceManagerWrapper::QServiceManagerWrapper(QtMobility::QService::Scope scope, QObject * parent) : QtMobility::QServiceManager(scope, parent), m_metaObject(0) {
    // ... middle
}

void QServiceManagerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QServiceManagerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QServiceManager::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QServiceManagerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QServiceManagerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QServiceManager::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QServiceManagerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QServiceManager.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QServiceManagerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QServiceManager.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QServiceManagerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QServiceManagerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QServiceManager::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QServiceManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QServiceManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QServiceManagerWrapper::~QServiceManagerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QServiceManager_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QServiceManager >()))
        return -1;

    QServiceManagerWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QServiceManager", &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QServiceManager(QObject*)
    // 1: QServiceManager(QtMobility::QService::Scope,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QServiceManager(QObject*)
    } else if (Shiboken::Converter<QtMobility::QService::Scope >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // QServiceManager(QtMobility::QService::Scope,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            overloadId = 1; // QServiceManager(QtMobility::QService::Scope,QObject*)
        }
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        overloadId = 0; // QServiceManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManager_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QServiceManager(QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "parent";
                        else
                            pyargs[0] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QObject* cpp_arg0 = pyargs[0] ? Shiboken::Converter<QObject* >::toCpp(pyargs[0]) : 0;

                if(!PyErr_Occurred()) {
                // QServiceManager(QObject*)
                cptr = new QServiceManagerWrapper(cpp_arg0);
                Shiboken::setParent(pyargs[0], self);
                }
                break;
            }
            case 1: // QServiceManager(QtMobility::QService::Scope,QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "parent";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QtMobility::QService::Scope cpp_arg0 = Shiboken::Converter<QtMobility::QService::Scope >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return -1;
                QObject* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QObject* >::toCpp(pyargs[1]) : 0;

                if(!PyErr_Occurred()) {
                // QServiceManager(QtMobility::QService::Scope,QObject*)
                cptr = new QServiceManagerWrapper(cpp_arg0, cpp_arg1);
                Shiboken::setParent(pyargs[1], self);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QServiceManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QServiceManager_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QServiceManager_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "QtMobility.ServiceFramework.QtMobility::QService.Scope, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceManager", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_addService(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: addService(QIODevice*)
    // 1: addService(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 1; // addService(QString)
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        overloadId = 0; // addService(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_addService_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // addService(QIODevice*)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return 0;
                QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // addService(QIODevice*)
                bool cppResult = cppSelf->QtMobility::QServiceManager::addService(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // addService(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // addService(QString)
                bool cppResult = cppSelf->QtMobility::QServiceManager::addService(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_addService_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", "QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.addService", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_connectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: connectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // connectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_connectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // connectNotify(const char*)
            cppSelf->QtMobility::QServiceManager::connectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceManagerFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.connectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_disconnectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: disconnectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // disconnectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_disconnectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // disconnectNotify(const char*)
            cppSelf->QtMobility::QServiceManager::disconnectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceManagerFunc_disconnectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.disconnectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_error(PyObject* self)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QServiceManager::Error cppResult = cppSelf->QtMobility::QServiceManager::error();
            pyResult = Shiboken::Converter<QtMobility::QServiceManager::Error >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_findInterfaces(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.findInterfaces(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.findInterfaces(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:findInterfaces", &arg))
        return 0;


    // Overloaded function decisor
    // 0: findInterfaces(QString)const
    // 1: findInterfaces(QtMobility::QServiceFilter)const
    if (numArgs == 0) {
        overloadId = 1; // findInterfaces(QtMobility::QServiceFilter)const
    } else if (Shiboken::Converter<const QtMobility::QServiceFilter & >::isConvertible(arg)) {
        overloadId = 1; // findInterfaces(QtMobility::QServiceFilter)const
    } else if (numArgs == 1 && Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // findInterfaces(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_findInterfaces_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // findInterfaces(QString)const
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // findInterfaces(QString)const
                QList<QtMobility::QServiceInterfaceDescriptor > cppResult = cppSelf->QtMobility::QServiceManager::findInterfaces(cpp_arg0);
                pyResult = Shiboken::Converter<QList<QtMobility::QServiceInterfaceDescriptor > >::toPython(cppResult);
                }
                break;
            }
            case 1: // findInterfaces(QtMobility::QServiceFilter)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "filter");
                    if (value) {
                        if (arg)
                            errorArgName = "filter";
                        else
                            arg = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.findInterfaces(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(arg))
                    return 0;
                QtMobility::QServiceFilter cpp_arg0_tmp = QtMobility::QServiceFilter();
                QtMobility::QServiceFilter* cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(arg) : &cpp_arg0_tmp;

                if(!PyErr_Occurred()) {
                // findInterfaces(QtMobility::QServiceFilter)const
                QList<QtMobility::QServiceInterfaceDescriptor > cppResult = cppSelf->QtMobility::QServiceManager::findInterfaces(*cpp_arg0);
                pyResult = Shiboken::Converter<QList<QtMobility::QServiceInterfaceDescriptor > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_findInterfaces_TypeError:
        const char* overloads[] = {"QString", "QtMobility.ServiceFramework.QtMobility::QServiceFilter = QtMobility.QServiceFilter()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.findInterfaces", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_findServices(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "interfaceName" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.findServices(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.findServices(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:findServices", &arg))
        return 0;


    // Overloaded function decisor
    // 0: findServices(QString)const
    if (numArgs == 0) {
        overloadId = 0; // findServices(QString)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // findServices(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_findServices_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "interfaceName");
                if (value) {
                    if (arg)
                        errorArgName = "interfaceName";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.findServices(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = arg ? Shiboken::Converter<QString >::toCpp(arg) : QString();

            if(!PyErr_Occurred()) {
            // findServices(QString)const
            QStringList cppResult = cppSelf->QtMobility::QServiceManager::findServices(cpp_arg0);
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_findServices_TypeError:
        const char* overloads[] = {"QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.findServices", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_interfaceDefault(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: interfaceDefault(QString)const
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // interfaceDefault(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_interfaceDefault_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // interfaceDefault(QString)const
            QtMobility::QServiceInterfaceDescriptor cppResult = cppSelf->QtMobility::QServiceManager::interfaceDefault(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_interfaceDefault_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.interfaceDefault", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_loadInterface(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "context", "session" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 2, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.loadInterface(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.loadInterface(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.loadInterface(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOO:loadInterface", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: loadInterface(QString,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
    // 1: loadInterface(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
    if (Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // loadInterface(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
        } else if (Shiboken::Converter<QtMobility::QServiceContext * >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // loadInterface(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            } else if (Shiboken::Converter<QtMobility::QAbstractSecuritySession * >::isConvertible(pyargs[2])) {
                overloadId = 1; // loadInterface(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            }
        }
    } else if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // loadInterface(QString,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
        } else if (Shiboken::Converter<QtMobility::QServiceContext * >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // loadInterface(QString,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            } else if (Shiboken::Converter<QtMobility::QAbstractSecuritySession * >::isConvertible(pyargs[2])) {
                overloadId = 0; // loadInterface(QString,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_loadInterface_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // loadInterface(QString,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "context");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "context";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "session");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "session";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.loadInterface(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QServiceContext* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QServiceContext* >::toCpp(pyargs[1]) : 0;
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QtMobility::QAbstractSecuritySession* cpp_arg2 = pyargs[2] ? Shiboken::Converter<QtMobility::QAbstractSecuritySession* >::toCpp(pyargs[2]) : 0;

                if(!PyErr_Occurred()) {
                // loadInterface(QString,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
                QObject * cppResult = cppSelf->QtMobility::QServiceManager::loadInterface(cpp_arg0, cpp_arg1, cpp_arg2);
                pyResult = Shiboken::Converter<QObject * >::toPython(cppResult);
                Shiboken::setParent(self, pyResult);
                }
                break;
            }
            case 1: // loadInterface(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "context");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "context";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "session");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "session";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceManager.loadInterface(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QServiceInterfaceDescriptor* cpp_arg0 = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QServiceContext* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QServiceContext* >::toCpp(pyargs[1]) : 0;
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QtMobility::QAbstractSecuritySession* cpp_arg2 = pyargs[2] ? Shiboken::Converter<QtMobility::QAbstractSecuritySession* >::toCpp(pyargs[2]) : 0;

                if(!PyErr_Occurred()) {
                // loadInterface(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
                QObject * cppResult = cppSelf->QtMobility::QServiceManager::loadInterface(*cpp_arg0, cpp_arg1, cpp_arg2);
                pyResult = Shiboken::Converter<QObject * >::toPython(cppResult);
                Shiboken::setParent(self, pyResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_loadInterface_TypeError:
        const char* overloads[] = {"QString, QtMobility.ServiceFramework.QtMobility::QServiceContext = None, QtMobility.ServiceFramework.QtMobility::QAbstractSecuritySession = None", "QtMobility.ServiceFramework.QtMobility::QServiceInterfaceDescriptor, QtMobility.ServiceFramework.QtMobility::QServiceContext = None, QtMobility.ServiceFramework.QtMobility::QAbstractSecuritySession = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceManager.loadInterface", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_removeService(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeService(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // removeService(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_removeService_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeService(QString)
            bool cppResult = cppSelf->QtMobility::QServiceManager::removeService(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_removeService_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceManager.removeService", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_scope(PyObject* self)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // scope()const
            QtMobility::QService::Scope cppResult = cppSelf->QtMobility::QServiceManager::scope();
            pyResult = Shiboken::Converter<QtMobility::QService::Scope >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceManagerFunc_setInterfaceDefault(PyObject* self, PyObject* args)
{
    QtMobility::QServiceManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setInterfaceDefault", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setInterfaceDefault(QString,QString)
    // 1: setInterfaceDefault(QtMobility::QServiceInterfaceDescriptor)
    if (numArgs == 1 && Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::isConvertible(pyargs[0])) {
        overloadId = 1; // setInterfaceDefault(QtMobility::QServiceInterfaceDescriptor)
    } else if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // setInterfaceDefault(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceManagerFunc_setInterfaceDefault_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setInterfaceDefault(QString,QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // setInterfaceDefault(QString,QString)
                bool cppResult = cppSelf->QtMobility::QServiceManager::setInterfaceDefault(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // setInterfaceDefault(QtMobility::QServiceInterfaceDescriptor)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QServiceInterfaceDescriptor* cpp_arg0 = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // setInterfaceDefault(QtMobility::QServiceInterfaceDescriptor)
                bool cppResult = cppSelf->QtMobility::QServiceManager::setInterfaceDefault(*cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceManagerFunc_setInterfaceDefault_TypeError:
        const char* overloads[] = {"QString, QString", "QtMobility.ServiceFramework.QtMobility::QServiceInterfaceDescriptor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceManager.setInterfaceDefault", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QServiceManager_methods[] = {
    {"addService", (PyCFunction)SbkQtMobility_QServiceManagerFunc_addService, METH_O},
    {"connectNotify", (PyCFunction)SbkQtMobility_QServiceManagerFunc_connectNotify, METH_O},
    {"disconnectNotify", (PyCFunction)SbkQtMobility_QServiceManagerFunc_disconnectNotify, METH_O},
    {"error", (PyCFunction)SbkQtMobility_QServiceManagerFunc_error, METH_NOARGS},
    {"findInterfaces", (PyCFunction)SbkQtMobility_QServiceManagerFunc_findInterfaces, METH_VARARGS|METH_KEYWORDS},
    {"findServices", (PyCFunction)SbkQtMobility_QServiceManagerFunc_findServices, METH_VARARGS|METH_KEYWORDS},
    {"interfaceDefault", (PyCFunction)SbkQtMobility_QServiceManagerFunc_interfaceDefault, METH_O},
    {"loadInterface", (PyCFunction)SbkQtMobility_QServiceManagerFunc_loadInterface, METH_VARARGS|METH_KEYWORDS},
    {"removeService", (PyCFunction)SbkQtMobility_QServiceManagerFunc_removeService, METH_O},
    {"scope", (PyCFunction)SbkQtMobility_QServiceManagerFunc_scope, METH_NOARGS},
    {"setInterfaceDefault", (PyCFunction)SbkQtMobility_QServiceManagerFunc_setInterfaceDefault, METH_VARARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QServiceManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.ServiceFramework.QServiceManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QServiceManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QServiceManager_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QServiceManager >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QServiceManager*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QServiceManager_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QServiceManager*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QServiceManager_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QServiceManager(PyObject* module)
{
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QServiceManager_Type);

    SbkQtMobility_QServiceManager_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QServiceManager_Type.type_discovery = &SbkQtMobility_QServiceManager_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QServiceManager_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QServiceManager_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QServiceManager_Type));
    PyModule_AddObject(module, "QServiceManager",
        ((PyObject*)&SbkQtMobility_QServiceManager_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEMANAGER_ERROR_IDX] = &SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type);
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::NoError, "NoError");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::StorageAccessError, "StorageAccessError");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "StorageAccessError", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "StorageAccessError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::InvalidServiceLocation, "InvalidServiceLocation");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "InvalidServiceLocation", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "InvalidServiceLocation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::InvalidServiceXml, "InvalidServiceXml");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "InvalidServiceXml", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "InvalidServiceXml", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::InvalidServiceInterfaceDescriptor, "InvalidServiceInterfaceDescriptor");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "InvalidServiceInterfaceDescriptor", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "InvalidServiceInterfaceDescriptor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::ServiceAlreadyExists, "ServiceAlreadyExists");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "ServiceAlreadyExists", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "ServiceAlreadyExists", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::ImplementationAlreadyExists, "ImplementationAlreadyExists");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "ImplementationAlreadyExists", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "ImplementationAlreadyExists", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::PluginLoadingFailed, "PluginLoadingFailed");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "PluginLoadingFailed", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "PluginLoadingFailed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::ComponentNotFound, "ComponentNotFound");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "ComponentNotFound", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "ComponentNotFound", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::ServiceCapabilityDenied, "ServiceCapabilityDenied");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "ServiceCapabilityDenied", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "ServiceCapabilityDenied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type,
        (long) QtMobility::QServiceManager::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceManager_Error_Type.tp_dict,
        "UnknownError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QServiceManager::Error");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("serviceAdded", "const QString&,QtMobility::QService::Scope", NULL);
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict, "serviceAdded", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("serviceRemoved", "const QString&,QtMobility::QService::Scope", NULL);
    PyDict_SetItemString(SbkQtMobility_QServiceManager_Type.super.ht_type.tp_dict, "serviceRemoved", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServiceManager >("QtMobility::QServiceManager*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServiceManager >(typeid(QtMobility::QServiceManager).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServiceManager >(typeid(QServiceManagerWrapper).name());
    PySide::initQtMetaType<QtMobility::QServiceManager* >();
}

