/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_serviceframework_python.h"

#include "qtmobility_qserviceinterfacedescriptor_wrapper.h"

// Extra includes
#include <QStringList>
#include <qserviceinterfacedescriptor.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QServiceInterfaceDescriptor_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QServiceInterfaceDescriptor >()))
        return -1;

    QtMobility::QServiceInterfaceDescriptor* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QServiceInterfaceDescriptor", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QServiceInterfaceDescriptor()
    // 1: QServiceInterfaceDescriptor(QtMobility::QServiceInterfaceDescriptor)
    if (numArgs == 0) {
        overloadId = 0; // QServiceInterfaceDescriptor()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::isConvertible(arg)) {
        overloadId = 1; // QServiceInterfaceDescriptor(QtMobility::QServiceInterfaceDescriptor)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceInterfaceDescriptor_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QServiceInterfaceDescriptor()
            {

                if(!PyErr_Occurred()) {
                // QServiceInterfaceDescriptor()
                cptr = new QtMobility::QServiceInterfaceDescriptor();
                }
                break;
            }
            case 1: // QServiceInterfaceDescriptor(QtMobility::QServiceInterfaceDescriptor)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QServiceInterfaceDescriptor* cpp_arg0 = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QServiceInterfaceDescriptor(QtMobility::QServiceInterfaceDescriptor)
                cptr = new QtMobility::QServiceInterfaceDescriptor(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QServiceInterfaceDescriptor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QServiceInterfaceDescriptor_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QServiceInterfaceDescriptor_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.ServiceFramework.QtMobility::QServiceInterfaceDescriptor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceInterfaceDescriptor", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_attribute(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: attribute(QtMobility::QServiceInterfaceDescriptor::Attribute)const
    if (Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor::Attribute >::isConvertible(arg)) {
        overloadId = 0; // attribute(QtMobility::QServiceInterfaceDescriptor::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceInterfaceDescriptorFunc_attribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QServiceInterfaceDescriptor::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // attribute(QtMobility::QServiceInterfaceDescriptor::Attribute)const
            QVariant cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::attribute(cpp_arg0);
            pyResult = Shiboken::Converter<QVariant >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceInterfaceDescriptorFunc_attribute_TypeError:
        const char* overloads[] = {"QtMobility.ServiceFramework.QtMobility::QServiceInterfaceDescriptor.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceInterfaceDescriptor.attribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_customAttribute(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: customAttribute(QString)const
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // customAttribute(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceInterfaceDescriptorFunc_customAttribute_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // customAttribute(QString)const
            QString cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::customAttribute(cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceInterfaceDescriptorFunc_customAttribute_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceInterfaceDescriptor.customAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_customAttributes(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // customAttributes()const
            QStringList cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::customAttributes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_interfaceName(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // interfaceName()const
            QString cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::interfaceName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_isValid(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_majorVersion(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::majorVersion();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_minorVersion(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::minorVersion();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_scope(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // scope()const
            QtMobility::QService::Scope cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::scope();
            pyResult = Shiboken::Converter<QtMobility::QService::Scope >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceInterfaceDescriptorFunc_serviceName(PyObject* self)
{
    QtMobility::QServiceInterfaceDescriptor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // serviceName()const
            QString cppResult = cppSelf->QtMobility::QServiceInterfaceDescriptor::serviceName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QServiceInterfaceDescriptor_methods[] = {
    {"attribute", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_attribute, METH_O},
    {"customAttribute", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_customAttribute, METH_O},
    {"customAttributes", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_customAttributes, METH_NOARGS},
    {"interfaceName", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_interfaceName, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_isValid, METH_NOARGS},
    {"majorVersion", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_majorVersion, METH_NOARGS},
    {"minorVersion", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_minorVersion, METH_NOARGS},
    {"scope", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_scope, METH_NOARGS},
    {"serviceName", (PyCFunction)SbkQtMobility_QServiceInterfaceDescriptorFunc_serviceName, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QServiceInterfaceDescriptor_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QServiceInterfaceDescriptor& cpp_self = *Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::isConvertible(other)) {
                // operator!=(const QtMobility::QServiceInterfaceDescriptor & other) const
                QtMobility::QServiceInterfaceDescriptor* cpp_other = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QServiceInterfaceDescriptor  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QServiceInterfaceDescriptor_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::isConvertible(other)) {
                // operator==(const QtMobility::QServiceInterfaceDescriptor & other) const
                QtMobility::QServiceInterfaceDescriptor* cpp_other = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QServiceInterfaceDescriptor  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QServiceInterfaceDescriptor_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QServiceInterfaceDescriptor_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QServiceInterfaceDescriptor_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.ServiceFramework.QServiceInterfaceDescriptor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QServiceInterfaceDescriptor_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QServiceInterfaceDescriptor_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QServiceInterfaceDescriptor_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QServiceInterfaceDescriptor >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QServiceInterfaceDescriptor",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Attribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QServiceInterfaceDescriptor(PyObject* module)
{
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEINTERFACEDESCRIPTOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QServiceInterfaceDescriptor_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QServiceInterfaceDescriptor_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QServiceInterfaceDescriptor_Type));
    PyModule_AddObject(module, "QServiceInterfaceDescriptor",
        ((PyObject*)&SbkQtMobility_QServiceInterfaceDescriptor_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Attribute
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEINTERFACEDESCRIPTOR_ATTRIBUTE_IDX] = &SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type);
    PyDict_SetItemString(SbkQtMobility_QServiceInterfaceDescriptor_Type.super.ht_type.tp_dict,
            "Attribute",((PyObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type,
        (long) QtMobility::QServiceInterfaceDescriptor::Capabilities, "Capabilities");
    PyDict_SetItemString(SbkQtMobility_QServiceInterfaceDescriptor_Type.super.ht_type.tp_dict,
        "Capabilities", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type.tp_dict,
        "Capabilities", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type,
        (long) QtMobility::QServiceInterfaceDescriptor::Location, "Location");
    PyDict_SetItemString(SbkQtMobility_QServiceInterfaceDescriptor_Type.super.ht_type.tp_dict,
        "Location", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type.tp_dict,
        "Location", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type,
        (long) QtMobility::QServiceInterfaceDescriptor::ServiceDescription, "ServiceDescription");
    PyDict_SetItemString(SbkQtMobility_QServiceInterfaceDescriptor_Type.super.ht_type.tp_dict,
        "ServiceDescription", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type.tp_dict,
        "ServiceDescription", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type,
        (long) QtMobility::QServiceInterfaceDescriptor::InterfaceDescription, "InterfaceDescription");
    PyDict_SetItemString(SbkQtMobility_QServiceInterfaceDescriptor_Type.super.ht_type.tp_dict,
        "InterfaceDescription", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceInterfaceDescriptor_Attribute_Type.tp_dict,
        "InterfaceDescription", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QServiceInterfaceDescriptor::Attribute");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QServiceInterfaceDescriptor >("QtMobility::QServiceInterfaceDescriptor");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServiceInterfaceDescriptor >("QtMobility::QServiceInterfaceDescriptor*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QServiceInterfaceDescriptor >(typeid(QtMobility::QServiceInterfaceDescriptor).name());
    PySide::initQtMetaType<QtMobility::QServiceInterfaceDescriptor >();
}

