/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_serviceframework_python.h"

#include "qtmobility_qservice_wrapper.h"

// Extra includes

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static PyMethodDef SbkQtMobility_QService_methods[] = {
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QService_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.ServiceFramework.QService",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QService_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QService",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Scope",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QService(PyObject* module)
{
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QService_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QService_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QService_Type));
    PyModule_AddObject(module, "QService",
        ((PyObject*)&SbkQtMobility_QService_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Scope
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICE_SCOPE_IDX] = &SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type);
    PyDict_SetItemString(SbkQtMobility_QService_Type.super.ht_type.tp_dict,
            "Scope",((PyObject*)&SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type,
        (long) QtMobility::QService::UserScope, "UserScope");
    PyDict_SetItemString(SbkQtMobility_QService_Type.super.ht_type.tp_dict,
        "UserScope", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type.tp_dict,
        "UserScope", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type,
        (long) QtMobility::QService::SystemScope, "SystemScope");
    PyDict_SetItemString(SbkQtMobility_QService_Type.super.ht_type.tp_dict,
        "SystemScope", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QService_Scope_Type.tp_dict,
        "SystemScope", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QService::Scope");


}

