/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <Python.h>
#include <shiboken.h>
#include <algorithm>
#include "qtmobility_sensors_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef Sensors_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtMobility_QSensorPluginInterface(PyObject* module);
void init_QtMobility_QSensorBackendFactory(PyObject* module);
void init_QtMobility_QSensorManager(PyObject* module);
void init_QtMobility_qoutputrange(PyObject* module);
void init_QtMobility_QSensorFilter(PyObject* module);
void init_QtMobility_QProximityFilter(PyObject* module);
void init_QtMobility_QAccelerometerFilter(PyObject* module);
void init_QtMobility_QOrientationFilter(PyObject* module);
void init_QtMobility_QMagnetometerFilter(PyObject* module);
void init_QtMobility_QTapFilter(PyObject* module);
void init_QtMobility_QCompassFilter(PyObject* module);
void init_QtMobility_QRotationFilter(PyObject* module);
void init_QtMobility_QAmbientLightFilter(PyObject* module);
void init_QtMobility_QSensorReading(PyObject* module);
void init_QtMobility_QProximityReading(PyObject* module);
void init_QtMobility_QAccelerometerReading(PyObject* module);
void init_QtMobility_QOrientationReading(PyObject* module);
void init_QtMobility_QMagnetometerReading(PyObject* module);
void init_QtMobility_QTapReading(PyObject* module);
void init_QtMobility_QCompassReading(PyObject* module);
void init_QtMobility_QRotationReading(PyObject* module);
void init_QtMobility_QAmbientLightReading(PyObject* module);
void init_QtMobility_QSensor(PyObject* module);
void init_QtMobility_QAccelerometer(PyObject* module);
void init_QtMobility_QOrientationSensor(PyObject* module);
void init_QtMobility_QMagnetometer(PyObject* module);
void init_QtMobility_QTapSensor(PyObject* module);
void init_QtMobility_QCompass(PyObject* module);
void init_QtMobility_QRotationSensor(PyObject* module);
void init_QtMobility_QAmbientLightSensor(PyObject* module);
void init_QtMobility_QProximitySensor(PyObject* module);
void init_QtMobility_QSensorBackend(PyObject* module);

PyTypeObject** SbkQtMobility_SensorsTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

#if defined _WIN32 || defined __CYGWIN__
    #define SBK_EXPORT_MODULE __declspec(dllexport)
#elif __GNUC__ >= 4
    #define SBK_EXPORT_MODULE __attribute__ ((visibility("default")))
#else
    #define SBK_EXPORT_MODULE
#endif

extern "C" SBK_EXPORT_MODULE void initSensors()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("Sensors", Sensors_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_Sensors_IDX_COUNT];
    SbkQtMobility_SensorsTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QtMobility_QSensorPluginInterface(module);
    init_QtMobility_QSensorBackendFactory(module);
    init_QtMobility_QSensorManager(module);
    init_QtMobility_qoutputrange(module);
    init_QtMobility_QSensorFilter(module);
    init_QtMobility_QProximityFilter(module);
    init_QtMobility_QAccelerometerFilter(module);
    init_QtMobility_QOrientationFilter(module);
    init_QtMobility_QMagnetometerFilter(module);
    init_QtMobility_QTapFilter(module);
    init_QtMobility_QCompassFilter(module);
    init_QtMobility_QRotationFilter(module);
    init_QtMobility_QAmbientLightFilter(module);
    init_QtMobility_QSensorReading(module);
    init_QtMobility_QProximityReading(module);
    init_QtMobility_QAccelerometerReading(module);
    init_QtMobility_QOrientationReading(module);
    init_QtMobility_QMagnetometerReading(module);
    init_QtMobility_QTapReading(module);
    init_QtMobility_QCompassReading(module);
    init_QtMobility_QRotationReading(module);
    init_QtMobility_QAmbientLightReading(module);
    init_QtMobility_QSensor(module);
    init_QtMobility_QAccelerometer(module);
    init_QtMobility_QOrientationSensor(module);
    init_QtMobility_QMagnetometer(module);
    init_QtMobility_QTapSensor(module);
    init_QtMobility_QCompass(module);
    init_QtMobility_QRotationSensor(module);
    init_QtMobility_QAmbientLightSensor(module);
    init_QtMobility_QProximitySensor(module);
    init_QtMobility_QSensorBackend(module);

    // Register primitive types on TypeResolver
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::qtimestamp >("QtMobility::qtimestamp");

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Sensors");
    }
}

