/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qsensorbackend_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsensor.h>
#include <qsensorbackend.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QSensorBackendWrapper::QSensorBackendWrapper(QtMobility::QSensor * sensor) : QtMobility::QSensorBackend(sensor), m_metaObject(0) {
    // ... middle
}

void QSensorBackendWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSensorBackendWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSensorBackendWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSensorBackendWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QSensorBackendWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSensorBackend.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QSensorBackendWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSensorBackend.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QSensorBackendWrapper::start()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "start"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSensorBackend.start()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSensorBackendWrapper::stop()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stop"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSensorBackend.stop()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSensorBackendWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSensorBackendWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QSensorBackend::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QSensorBackendWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QSensorBackend::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSensorBackendWrapper::~QSensorBackendWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSensorBackend_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSensorBackend >()))
        return -1;

    QSensorBackendWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORBACKEND_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QSensorBackend' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
                propertyKeys.push_back(argName);
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSensorBackend", 1, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QSensorBackend(QtMobility::QSensor*)
    if (numArgs == 1 && Shiboken::Converter<QtMobility::QSensor * >::isConvertible(arg)) {
        overloadId = 0; // QSensorBackend(QtMobility::QSensor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackend_Init_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QtMobility::QSensor* cpp_arg0 = Shiboken::Converter<QtMobility::QSensor* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // QSensorBackend(QtMobility::QSensor*)
            cptr = new QSensorBackendWrapper(cpp_arg0);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSensorBackend >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QSensorBackend_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QSensorBackend_Init_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QSensorBackend", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_addDataRate(PyObject* self, PyObject* args)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addDataRate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: addDataRate(qreal,qreal)
    if (numArgs == 2 && SbkNumber_Check(pyargs[0]) && SbkNumber_Check(pyargs[1])) {
        overloadId = 0; // addDataRate(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackendFunc_addDataRate_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // addDataRate(qreal,qreal)
            cppSelf->QtMobility::QSensorBackend::addDataRate(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorBackendFunc_addDataRate_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QSensorBackend.addDataRate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_addOutputRange(PyObject* self, PyObject* args)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addOutputRange", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: addOutputRange(qreal,qreal,qreal)
    if (numArgs == 3 && SbkNumber_Check(pyargs[0]) && SbkNumber_Check(pyargs[1]) && SbkNumber_Check(pyargs[2])) {
        overloadId = 0; // addOutputRange(qreal,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackendFunc_addOutputRange_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // addOutputRange(qreal,qreal,qreal)
            cppSelf->QtMobility::QSensorBackend::addOutputRange(cpp_arg0, cpp_arg1, cpp_arg2);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorBackendFunc_addOutputRange_TypeError:
        const char* overloads[] = {"float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QSensorBackend.addOutputRange", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_newReadingAvailable(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // newReadingAvailable()
            cppSelf->QtMobility::QSensorBackend::newReadingAvailable();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_reading(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // reading()const
            QtMobility::QSensorReading * cppResult = cppSelf->QtMobility::QSensorBackend::reading();
            pyResult = Shiboken::Converter<QtMobility::QSensorReading * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_sensor(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // sensor()const
            QtMobility::QSensor * cppResult = cppSelf->QtMobility::QSensorBackend::sensor();
            pyResult = Shiboken::Converter<QtMobility::QSensor * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_sensorBusy(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // sensorBusy()
            cppSelf->QtMobility::QSensorBackend::sensorBusy();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_sensorError(PyObject* self, PyObject* arg)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: sensorError(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // sensorError(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackendFunc_sensorError_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // sensorError(int)
            cppSelf->QtMobility::QSensorBackend::sensorError(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorBackendFunc_sensorError_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensorBackend.sensorError", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_sensorStopped(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // sensorStopped()
            cppSelf->QtMobility::QSensorBackend::sensorStopped();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_setDataRates(PyObject* self, PyObject* arg)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDataRates(const QtMobility::QSensor*)
    if (Shiboken::Converter<const QtMobility::QSensor * >::isConvertible(arg)) {
        overloadId = 0; // setDataRates(const QtMobility::QSensor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackendFunc_setDataRates_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QSensor* cpp_arg0 = Shiboken::Converter<QtMobility::QSensor* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDataRates(const QtMobility::QSensor*)
            cppSelf->QtMobility::QSensorBackend::setDataRates(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorBackendFunc_setDataRates_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensorBackend.setDataRates", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_setDescription(PyObject* self, PyObject* arg)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDescription(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackendFunc_setDescription_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDescription(QString)
            cppSelf->QtMobility::QSensorBackend::setDescription(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorBackendFunc_setDescription_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensorBackend.setDescription", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_start(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // start()
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSensorBackend.start()' not implemented.");
                return 0;
            }
            cppSelf->start();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QSensorBackendFunc_stop(PyObject* self)
{
    QtMobility::QSensorBackend* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackend* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // stop()
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSensorBackend.stop()' not implemented.");
                return 0;
            }
            cppSelf->stop();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQtMobility_QSensorBackend_methods[] = {
    {"addDataRate", (PyCFunction)SbkQtMobility_QSensorBackendFunc_addDataRate, METH_VARARGS},
    {"addOutputRange", (PyCFunction)SbkQtMobility_QSensorBackendFunc_addOutputRange, METH_VARARGS},
    {"newReadingAvailable", (PyCFunction)SbkQtMobility_QSensorBackendFunc_newReadingAvailable, METH_NOARGS},
    {"reading", (PyCFunction)SbkQtMobility_QSensorBackendFunc_reading, METH_NOARGS},
    {"sensor", (PyCFunction)SbkQtMobility_QSensorBackendFunc_sensor, METH_NOARGS},
    {"sensorBusy", (PyCFunction)SbkQtMobility_QSensorBackendFunc_sensorBusy, METH_NOARGS},
    {"sensorError", (PyCFunction)SbkQtMobility_QSensorBackendFunc_sensorError, METH_O},
    {"sensorStopped", (PyCFunction)SbkQtMobility_QSensorBackendFunc_sensorStopped, METH_NOARGS},
    {"setDataRates", (PyCFunction)SbkQtMobility_QSensorBackendFunc_setDataRates, METH_O},
    {"setDescription", (PyCFunction)SbkQtMobility_QSensorBackendFunc_setDescription, METH_O},
    {"start", (PyCFunction)SbkQtMobility_QSensorBackendFunc_start, METH_NOARGS},
    {"stop", (PyCFunction)SbkQtMobility_QSensorBackendFunc_stop, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSensorBackend_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.QSensorBackend",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSensorBackend_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSensorBackend_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSensorBackend >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSensorBackend*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QSensorBackend_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QSensorBackend*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QSensorBackend_Type;
    return 0;
}


void init_QtMobility_QSensorBackend(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORBACKEND_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSensorBackend_Type);

    SbkQtMobility_QSensorBackend_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QSensorBackend_Type.type_discovery = &SbkQtMobility_QSensorBackend_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QSensorBackend_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSensorBackend_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSensorBackend_Type));
    PyModule_AddObject(module, "QSensorBackend",
        ((PyObject*)&SbkQtMobility_QSensorBackend_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorBackend >("QtMobility::QSensorBackend*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorBackend >(typeid(QtMobility::QSensorBackend).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorBackend >(typeid(QSensorBackendWrapper).name());
    PySide::initQtMetaType<QtMobility::QSensorBackend* >();
}

