/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qoutputrange_wrapper.h"

// Extra includes

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_qoutputrange_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::qoutputrange >()))
        return -1;

    QtMobility::qoutputrange* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qoutputrange", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: qoutputrange()
    // 1: qoutputrange(QtMobility::qoutputrange)
    if (numArgs == 0) {
        overloadId = 0; // qoutputrange()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::qoutputrange & >::isConvertible(arg)) {
        overloadId = 1; // qoutputrange(QtMobility::qoutputrange)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_qoutputrange_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // qoutputrange()
            {

                if(!PyErr_Occurred()) {
                // qoutputrange()
                cptr = new QtMobility::qoutputrange();
                }
                break;
            }
            case 1: // qoutputrange(QtMobility::qoutputrange)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::qoutputrange* cpp_arg0 = Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // qoutputrange(QtMobility::qoutputrange)
                cptr = new QtMobility::qoutputrange(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::qoutputrange >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_qoutputrange_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_qoutputrange_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Sensors.QtMobility::qoutputrange", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.qoutputrange", overloads);
        return -1;
}

static PyMethodDef SbkQtMobility_qoutputrange_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQtMobility_qoutputrange_get_accuracy(PyObject* self, void*)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(self)->accuracy);
}
static int SbkQtMobility_qoutputrange_set_accuracy(PyObject* self, PyObject* value, void*)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'accuracy' may not be deleted");
        return -1;
    }
    if (!SbkNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'accuracy', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(self)->accuracy = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQtMobility_qoutputrange_get_minimum(PyObject* self, void*)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(self)->minimum);
}
static int SbkQtMobility_qoutputrange_set_minimum(PyObject* self, PyObject* value, void*)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'minimum' may not be deleted");
        return -1;
    }
    if (!SbkNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'minimum', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(self)->minimum = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQtMobility_qoutputrange_get_maximum(PyObject* self, void*)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(self)->maximum);
}
static int SbkQtMobility_qoutputrange_set_maximum(PyObject* self, PyObject* value, void*)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'maximum' may not be deleted");
        return -1;
    }
    if (!SbkNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'maximum', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QtMobility::qoutputrange* >::toCpp(self)->maximum = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

// Getters and Setters for qoutputrange
static PyGetSetDef SbkQtMobility_qoutputrange_getsetlist[] = {
    {const_cast<char*>("accuracy"), SbkQtMobility_qoutputrange_get_accuracy, SbkQtMobility_qoutputrange_set_accuracy},
    {const_cast<char*>("minimum"), SbkQtMobility_qoutputrange_get_minimum, SbkQtMobility_qoutputrange_set_minimum},
    {const_cast<char*>("maximum"), SbkQtMobility_qoutputrange_get_maximum, SbkQtMobility_qoutputrange_set_maximum},
    {0}  // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_qoutputrange_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.qoutputrange",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_qoutputrange_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_qoutputrange_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_qoutputrange_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::qoutputrange >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::qoutputrange",
    /*user_data*/           0
};
} //extern


void init_QtMobility_qoutputrange(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QOUTPUTRANGE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_qoutputrange_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_qoutputrange_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_qoutputrange_Type));
    PyModule_AddObject(module, "qoutputrange",
        ((PyObject*)&SbkQtMobility_qoutputrange_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::qoutputrange >("QtMobility::qoutputrange");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::qoutputrange >("QtMobility::qoutputrange*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::qoutputrange >(typeid(QtMobility::qoutputrange).name());
    PySide::initQtMetaType<QtMobility::qoutputrange >();
}

