/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qorientationfilter_wrapper.h"

// Extra includes
#include <qorientationsensor.h>
#include <qsensor.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QOrientationFilterWrapper::QOrientationFilterWrapper() : QtMobility::QOrientationFilter() {
    // ... middle
}

bool QOrientationFilterWrapper::filter(QtMobility::QOrientationReading * reading)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "filter"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QOrientationFilter.filter()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QOrientationReading * >::toPython(reading)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QOrientationFilter.filter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

void QOrientationFilterWrapper::setSensor(QtMobility::QSensor * sensor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSensor"));
    if (py_override.isNull()) {
        return this->QtMobility::QSensorFilter::setSensor(sensor);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QSensor * >::toPython(sensor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

QOrientationFilterWrapper::~QOrientationFilterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QOrientationFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QOrientationFilter >()))
        return -1;

    QOrientationFilterWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QORIENTATIONFILTER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QOrientationFilter' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QOrientationFilter()
            cptr = new QOrientationFilterWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QOrientationFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QOrientationFilterFunc_filter(PyObject* self, PyObject* arg)
{
    QtMobility::QOrientationFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QOrientationFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: filter(QtMobility::QOrientationReading*)
    // 1: filter(QtMobility::QSensorReading*)
    if (Shiboken::Converter<QtMobility::QSensorReading * >::isConvertible(arg)) {
        overloadId = 1; // filter(QtMobility::QSensorReading*)
    } else if (Shiboken::Converter<QtMobility::QOrientationReading * >::isConvertible(arg)) {
        overloadId = 0; // filter(QtMobility::QOrientationReading*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QOrientationFilterFunc_filter_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // filter(QtMobility::QOrientationReading*)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return 0;
                QtMobility::QOrientationReading* cpp_arg0 = Shiboken::Converter<QtMobility::QOrientationReading* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // filter(QtMobility::QOrientationReading*)
                if (SbkBaseWrapper_containsCppWrapper(self)) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QOrientationFilter.filter()' not implemented.");
                    return 0;
                }
                bool cppResult = cppSelf->filter(cpp_arg0);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // filter(QtMobility::QSensorReading*)
            {
                PyErr_Format(PyExc_TypeError, "%s is a private method.", "filter(QtMobility.QSensorReading * reading)");
                return 0;
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QOrientationFilterFunc_filter_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QOrientationReading", "QtMobility.Sensors.QtMobility::QSensorReading", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QOrientationFilter.filter", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QOrientationFilter_methods[] = {
    {"filter", (PyCFunction)SbkQtMobility_QOrientationFilterFunc_filter, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QOrientationFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.QOrientationFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QOrientationFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QOrientationFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QOrientationFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QOrientationFilter*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QOrientationFilter_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QtMobility::QSensorFilter >()) && dynamic_cast<QtMobility::QOrientationFilter*>(reinterpret_cast<QtMobility::QSensorFilter*>(cptr)))
        return &SbkQtMobility_QOrientationFilter_Type;
    return 0;
}


void init_QtMobility_QOrientationFilter(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QORIENTATIONFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QOrientationFilter_Type);

    SbkQtMobility_QOrientationFilter_Type.super.ht_type.tp_base = SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORFILTER_IDX];
    // Fill type discovery information
    SbkQtMobility_QOrientationFilter_Type.type_discovery = &SbkQtMobility_QOrientationFilter_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORFILTER_IDX]), &SbkQtMobility_QOrientationFilter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QOrientationFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QOrientationFilter_Type));
    PyModule_AddObject(module, "QOrientationFilter",
        ((PyObject*)&SbkQtMobility_QOrientationFilter_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QOrientationFilter >("QtMobility::QOrientationFilter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QOrientationFilter >(typeid(QtMobility::QOrientationFilter).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QOrientationFilter >(typeid(QOrientationFilterWrapper).name());
    PySide::initQtMetaType<QtMobility::QOrientationFilter* >();
}

