/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagesortorder_wrapper.h"

// Extra includes
#include <qmessagesortorder.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageSortOrderWrapper::QMessageSortOrderWrapper() : QtMobility::QMessageSortOrder() {
    // ... middle
}

QMessageSortOrderWrapper::~QMessageSortOrderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageSortOrder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageSortOrder >()))
        return -1;

    QMessageSortOrderWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageSortOrder", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageSortOrder()
    // 1: QMessageSortOrder(QtMobility::QMessageSortOrder)
    if (numArgs == 0) {
        overloadId = 0; // QMessageSortOrder()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(arg)) {
        overloadId = 1; // QMessageSortOrder(QtMobility::QMessageSortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrder_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageSortOrder()
            {

                if(!PyErr_Occurred()) {
                // QMessageSortOrder()
                cptr = new QMessageSortOrderWrapper();
                }
                break;
            }
            case 1: // QMessageSortOrder(QtMobility::QMessageSortOrder)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageSortOrder(QtMobility::QMessageSortOrder)
                cptr = new QMessageSortOrderWrapper(*reinterpret_cast<QMessageSortOrderWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageSortOrder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageSortOrder_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageSortOrder_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageSortOrder", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_byPriority(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byPriority(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byPriority(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byPriority", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byPriority(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byPriority(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byPriority(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_byPriority_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byPriority(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byPriority(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::byPriority(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_byPriority_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.byPriority", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_byReceptionTimeStamp(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byReceptionTimeStamp(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byReceptionTimeStamp(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byReceptionTimeStamp", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byReceptionTimeStamp(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byReceptionTimeStamp(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byReceptionTimeStamp(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_byReceptionTimeStamp_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byReceptionTimeStamp(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byReceptionTimeStamp(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::byReceptionTimeStamp(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_byReceptionTimeStamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.byReceptionTimeStamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_byRecipients(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byRecipients(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byRecipients(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byRecipients", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byRecipients(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byRecipients(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byRecipients(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_byRecipients_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byRecipients(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byRecipients(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::byRecipients(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_byRecipients_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.byRecipients", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_bySender(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySender(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySender(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:bySender", &arg))
        return 0;


    // Overloaded function decisor
    // 0: bySender(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // bySender(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // bySender(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_bySender_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySender(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // bySender(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::bySender(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_bySender_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.bySender", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_bySize(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySize(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySize(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:bySize", &arg))
        return 0;


    // Overloaded function decisor
    // 0: bySize(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // bySize(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // bySize(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_bySize_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySize(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // bySize(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::bySize(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_bySize_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.bySize", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_byStatus(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byStatus(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byStatus(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byStatus(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byStatus", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byStatus(QtMobility::QMessage::Status,Qt::SortOrder)
    if (Shiboken::Converter<QtMobility::QMessage::Status >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byStatus(QtMobility::QMessage::Status,Qt::SortOrder)
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            overloadId = 0; // byStatus(QtMobility::QMessage::Status,Qt::SortOrder)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_byStatus_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "order";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byStatus(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QMessage::Status cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Status >::toCpp(pyargs[0]);
            Qt::SortOrder cpp_arg1 = pyargs[1] ? Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byStatus(QtMobility::QMessage::Status,Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::byStatus(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_byStatus_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.Status, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageSortOrder.byStatus", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_bySubject(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySubject(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySubject(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:bySubject", &arg))
        return 0;


    // Overloaded function decisor
    // 0: bySubject(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // bySubject(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // bySubject(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_bySubject_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.bySubject(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // bySubject(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::bySubject(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_bySubject_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.bySubject", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_byTimeStamp(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byTimeStamp(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byTimeStamp(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byTimeStamp", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byTimeStamp(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byTimeStamp(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byTimeStamp(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_byTimeStamp_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byTimeStamp(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byTimeStamp(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::byTimeStamp(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_byTimeStamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.byTimeStamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_byType(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byType(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byType(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byType", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byType(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byType(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byType(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc_byType_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageSortOrder.byType(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byType(Qt::SortOrder)
            QtMobility::QMessageSortOrder cppResult = QtMobility::QMessageSortOrder::byType(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc_byType_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.byType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_isEmpty(PyObject* self)
{
    QtMobility::QMessageSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QMessageSortOrder::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc_isSupported(PyObject* self)
{
    QtMobility::QMessageSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = cppSelf->QtMobility::QMessageSortOrder::isSupported();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageSortOrder_methods[] = {
    {"byPriority", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_byPriority, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byReceptionTimeStamp", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_byReceptionTimeStamp, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byRecipients", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_byRecipients, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"bySender", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_bySender, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"bySize", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_bySize, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byStatus", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_byStatus, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"bySubject", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_bySubject, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byTimeStamp", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_byTimeStamp, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byType", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_byType, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_isEmpty, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQtMobility_QMessageSortOrderFunc_isSupported, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQtMobility_QMessageSortOrderFunc___add__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageSortOrder* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageSortOrder >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageSortOrder >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator+(QtMobility::QMessageSortOrder)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(arg)) {
        overloadId = 0; // operator+(QtMobility::QMessageSortOrder)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc___add___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator+(QtMobility::QMessageSortOrder)const
            QtMobility::QMessageSortOrder cppResult = (*cppSelf) + (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageSortOrder >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageSortOrderFunc___add___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.__add__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageSortOrderFunc___iadd__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageSortOrder* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageSortOrder >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageSortOrder >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator+=(QtMobility::QMessageSortOrder)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(arg)) {
        overloadId = 0; // operator+=(QtMobility::QMessageSortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageSortOrderFunc___iadd___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator+=(QtMobility::QMessageSortOrder)
            (*cppSelf) += (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageSortOrderFunc___iadd___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageSortOrder.__iadd__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQtMobility_QMessageSortOrder_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQtMobility_QMessageSortOrderFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQtMobility_QMessageSortOrderFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageSortOrder_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageSortOrder& cpp_self = *Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageSortOrder & other) const
                QtMobility::QMessageSortOrder* cpp_other = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageSortOrder  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageSortOrder_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageSortOrder & other) const
                QtMobility::QMessageSortOrder* cpp_other = Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageSortOrder  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageSortOrder_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageSortOrder_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageSortOrder_ObjCopierFunc(const void* ptr){
    return new QMessageSortOrderWrapper(*reinterpret_cast<const QtMobility::QMessageSortOrder*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageSortOrder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageSortOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQtMobility_QMessageSortOrder_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageSortOrder_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageSortOrder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageSortOrder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageSortOrder_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageSortOrder >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageSortOrder",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageSortOrder(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGESORTORDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageSortOrder_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageSortOrder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageSortOrder_Type));
    PyModule_AddObject(module, "QMessageSortOrder",
        ((PyObject*)&SbkQtMobility_QMessageSortOrder_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageSortOrder >("QtMobility::QMessageSortOrder");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageSortOrder >("QtMobility::QMessageSortOrder*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageSortOrder >(typeid(QtMobility::QMessageSortOrder).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageSortOrder >(typeid(QMessageSortOrderWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageSortOrder >();
}

