/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagefolderfilter_wrapper.h"

// Extra includes
#include <QList>
#include <qmessageaccountfilter.h>
#include <qmessageaccountid.h>
#include <qmessagefolderfilter.h>
#include <qmessagefolderid.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageFolderFilterWrapper::QMessageFolderFilterWrapper() : QtMobility::QMessageFolderFilter() {
    // ... middle
}

QMessageFolderFilterWrapper::~QMessageFolderFilterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageFolderFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageFolderFilter >()))
        return -1;

    QMessageFolderFilterWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageFolderFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageFolderFilter()
    // 1: QMessageFolderFilter(QtMobility::QMessageFolderFilter)
    if (numArgs == 0) {
        overloadId = 0; // QMessageFolderFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(arg)) {
        overloadId = 1; // QMessageFolderFilter(QtMobility::QMessageFolderFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageFolderFilter()
            {

                if(!PyErr_Occurred()) {
                // QMessageFolderFilter()
                cptr = new QMessageFolderFilterWrapper();
                }
                break;
            }
            case 1: // QMessageFolderFilter(QtMobility::QMessageFolderFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageFolderFilter(QtMobility::QMessageFolderFilter)
                cptr = new QMessageFolderFilterWrapper(*reinterpret_cast<QMessageFolderFilterWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageFolderFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageFolderFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageFolderFilter_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageFolderFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_byAncestorFolderIds(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byAncestorFolderIds(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byAncestorFolderIds(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byAncestorFolderIds(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byAncestorFolderIds", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_byAncestorFolderIds_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byAncestorFolderIds(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byAncestorFolderIds(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byAncestorFolderIds(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byAncestorFolderIds(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc_byAncestorFolderIds_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFolderId, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter.byAncestorFolderIds", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_byId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byId(QList<QtMobility::QMessageFolderId>,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 2: byId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 2; // byId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 2; // byId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    } else if (Shiboken::Converter< QList<QtMobility::QMessageFolderId >  >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byId(QList<QtMobility::QMessageFolderId>,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byId(QList<QtMobility::QMessageFolderId>,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_byId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byId(QList<QtMobility::QMessageFolderId>,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QList<QtMobility::QMessageFolderId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QMessageFolderId > >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byId(QList<QtMobility::QMessageFolderId>,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byId(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 2: // byId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc_byId_TypeError:
        const char* overloads[] = {"list, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFolderFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFolderId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter.byId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_byName(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byName(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byName(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byName(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byName", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_byName_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byName(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byName(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byName(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc_byName_TypeError:
        const char* overloads[] = {"QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator", "QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter.byName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_byParentAccountId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentAccountId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentAccountId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentAccountId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byParentAccountId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_byParentAccountId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentAccountId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byParentAccountId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentAccountId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
                QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byParentAccountId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc_byParentAccountId_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageAccountId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter.byParentAccountId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_byParentFolderId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentFolderId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentFolderId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentFolderId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byParentFolderId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_byParentFolderId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentFolderId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byParentFolderId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byParentFolderId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byParentFolderId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc_byParentFolderId_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFolderId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter.byParentFolderId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_byPath(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byPath(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byPath(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byPath(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byPath", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byPath(QString,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: byPath(QString,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byPath(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byPath(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byPath(QString,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_byPath_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byPath(QString,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byPath(QString,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byPath(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byPath(QString,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderFilter.byPath(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byPath(QString,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFolderFilter cppResult = QtMobility::QMessageFolderFilter::byPath(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc_byPath_TypeError:
        const char* overloads[] = {"QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator", "QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderFilter.byPath", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_isEmpty(PyObject* self)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QMessageFolderFilter::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_isSupported(PyObject* self)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = cppSelf->QtMobility::QMessageFolderFilter::isSupported();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_matchFlags(PyObject* self)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // matchFlags()const
            QFlags<QtMobility::QMessageDataComparator::MatchFlag> cppResult = cppSelf->QtMobility::QMessageFolderFilter::matchFlags();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc_setMatchFlags(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
    if (Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::isConvertible(arg)) {
        overloadId = 0; // setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc_setMatchFlags_TypeError;

    // Call function/method
    {
        {
            QFlags<QtMobility::QMessageDataComparator::MatchFlag> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
            cppSelf->QtMobility::QMessageFolderFilter::setMatchFlags(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFolderFilterFunc_setMatchFlags_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageDataComparator.MatchFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderFilter.setMatchFlags", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QMessageFolderFilter_methods[] = {
    {"byAncestorFolderIds", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_byAncestorFolderIds, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byId", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_byId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byName", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_byName, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byParentAccountId", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_byParentAccountId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byParentFolderId", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_byParentFolderId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byPath", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_byPath, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_isEmpty, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_isSupported, METH_NOARGS},
    {"matchFlags", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_matchFlags, METH_NOARGS},
    {"setMatchFlags", (PyCFunction)SbkQtMobility_QMessageFolderFilterFunc_setMatchFlags, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQtMobility_QMessageFolderFilterFunc___and__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rand__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rand__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator&(QtMobility::QMessageFolderFilter)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator&(QtMobility::QMessageFolderFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc___and___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator&(QtMobility::QMessageFolderFilter)const
            QtMobility::QMessageFolderFilter cppResult = (*cppSelf) & (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc___and___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderFilter.__and__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc___iand__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator&=(QtMobility::QMessageFolderFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator&=(QtMobility::QMessageFolderFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc___iand___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator&=(QtMobility::QMessageFolderFilter)
            (*cppSelf) &= (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageFolderFilterFunc___iand___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderFilter.__iand__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc___or__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__ror__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__ror__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator|(QtMobility::QMessageFolderFilter)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator|(QtMobility::QMessageFolderFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc___or___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator|(QtMobility::QMessageFolderFilter)const
            QtMobility::QMessageFolderFilter cppResult = (*cppSelf) | (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderFilterFunc___or___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderFilter.__or__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc___ior__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFolderFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator|=(QtMobility::QMessageFolderFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator|=(QtMobility::QMessageFolderFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderFilterFunc___ior___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator|=(QtMobility::QMessageFolderFilter)
            (*cppSelf) |= (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageFolderFilterFunc___ior___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderFilter.__ior__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderFilterFunc___invert__(PyObject* self)
{
    QtMobility::QMessageFolderFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // operator~()const
            QtMobility::QMessageFolderFilter cppResult = ~ (*cppSelf);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

// type has number operators
static PyNumberMethods SbkQtMobility_QMessageFolderFilter_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_QMessageFolderFilterFunc___invert__,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_QMessageFolderFilterFunc___and__,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_QMessageFolderFilterFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQtMobility_QMessageFolderFilterFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)SbkQtMobility_QMessageFolderFilterFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageFolderFilter_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageFolderFilter& cpp_self = *Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageFolderFilter & other) const
                QtMobility::QMessageFolderFilter* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderFilter  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderFilter_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageFolderFilter & other) const
                QtMobility::QMessageFolderFilter* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderFilter  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderFilter_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageFolderFilter_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageFolderFilter_ObjCopierFunc(const void* ptr){
    return new QMessageFolderFilterWrapper(*reinterpret_cast<const QtMobility::QMessageFolderFilter*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageFolderFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageFolderFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQtMobility_QMessageFolderFilter_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageFolderFilter_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageFolderFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageFolderFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageFolderFilter_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageFolderFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageFolderFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageFolderFilter(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDERFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageFolderFilter_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageFolderFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageFolderFilter_Type));
    PyModule_AddObject(module, "QMessageFolderFilter",
        ((PyObject*)&SbkQtMobility_QMessageFolderFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderFilter >("QtMobility::QMessageFolderFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageFolderFilter >("QtMobility::QMessageFolderFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderFilter >(typeid(QtMobility::QMessageFolderFilter).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderFilter >(typeid(QMessageFolderFilterWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageFolderFilter >();
}

