/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagefolder_wrapper.h"

// Extra includes
#include <qmessageaccountid.h>
#include <qmessagefolder.h>
#include <qmessagefolderid.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageFolderWrapper::QMessageFolderWrapper() : QtMobility::QMessageFolder() {
    // ... middle
}

QMessageFolderWrapper::QMessageFolderWrapper(const QtMobility::QMessageFolderId & id) : QtMobility::QMessageFolder(id) {
    // ... middle
}

QMessageFolderWrapper::~QMessageFolderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageFolder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageFolder >()))
        return -1;

    QMessageFolderWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageFolder", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageFolder()
    // 1: QMessageFolder(QtMobility::QMessageFolder)
    // 2: QMessageFolder(QtMobility::QMessageFolderId)
    if (numArgs == 0) {
        overloadId = 0; // QMessageFolder()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(arg)) {
        overloadId = 2; // QMessageFolder(QtMobility::QMessageFolderId)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageFolder & >::isConvertible(arg)) {
        overloadId = 1; // QMessageFolder(QtMobility::QMessageFolder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolder_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageFolder()
            {

                if(!PyErr_Occurred()) {
                // QMessageFolder()
                cptr = new QMessageFolderWrapper();
                }
                break;
            }
            case 1: // QMessageFolder(QtMobility::QMessageFolder)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageFolder > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageFolder >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolder >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageFolder(QtMobility::QMessageFolder)
                cptr = new QMessageFolderWrapper(*reinterpret_cast<QMessageFolderWrapper*>(cpp_arg0));
                }
                break;
            }
            case 2: // QMessageFolder(QtMobility::QMessageFolderId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageFolder(QtMobility::QMessageFolderId)
                cptr = new QMessageFolderWrapper(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageFolder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageFolder_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageFolder_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageFolder", "QtMobility.Messaging.QtMobility::QMessageFolderId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolder", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageFolderFunc_id(PyObject* self)
{
    QtMobility::QMessageFolder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // id()const
            QtMobility::QMessageFolderId cppResult = cppSelf->QtMobility::QMessageFolder::id();
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFunc_name(PyObject* self)
{
    QtMobility::QMessageFolder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // name()const
            QString cppResult = cppSelf->QtMobility::QMessageFolder::name();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFunc_parentAccountId(PyObject* self)
{
    QtMobility::QMessageFolder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // parentAccountId()const
            QtMobility::QMessageAccountId cppResult = cppSelf->QtMobility::QMessageFolder::parentAccountId();
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFunc_parentFolderId(PyObject* self)
{
    QtMobility::QMessageFolder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // parentFolderId()const
            QtMobility::QMessageFolderId cppResult = cppSelf->QtMobility::QMessageFolder::parentFolderId();
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderFunc_path(PyObject* self)
{
    QtMobility::QMessageFolder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // path()const
            QString cppResult = cppSelf->QtMobility::QMessageFolder::path();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageFolder_methods[] = {
    {"id", (PyCFunction)SbkQtMobility_QMessageFolderFunc_id, METH_NOARGS},
    {"name", (PyCFunction)SbkQtMobility_QMessageFolderFunc_name, METH_NOARGS},
    {"parentAccountId", (PyCFunction)SbkQtMobility_QMessageFolderFunc_parentAccountId, METH_NOARGS},
    {"parentFolderId", (PyCFunction)SbkQtMobility_QMessageFolderFunc_parentFolderId, METH_NOARGS},
    {"path", (PyCFunction)SbkQtMobility_QMessageFolderFunc_path, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

static void* SbkQtMobility_QMessageFolder_ObjCopierFunc(const void* ptr){
    return new QMessageFolderWrapper(*reinterpret_cast<const QtMobility::QMessageFolder*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageFolder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageFolder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageFolder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageFolder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageFolder_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageFolder >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageFolder",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageFolder(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageFolder_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageFolder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageFolder_Type));
    PyModule_AddObject(module, "QMessageFolder",
        ((PyObject*)&SbkQtMobility_QMessageFolder_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolder >("QtMobility::QMessageFolder");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageFolder >("QtMobility::QMessageFolder*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolder >(typeid(QtMobility::QMessageFolder).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolder >(typeid(QMessageFolderWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageFolder >();
}

