/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagefilter_wrapper.h"

// Extra includes
#include <QList>
#include <qdatetime.h>
#include <qmessageaccountfilter.h>
#include <qmessageaccountid.h>
#include <qmessagefilter.h>
#include <qmessagefolderfilter.h>
#include <qmessagefolderid.h>
#include <qmessageid.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageFilterWrapper::QMessageFilterWrapper() : QtMobility::QMessageFilter() {
    // ... middle
}

QMessageFilterWrapper::~QMessageFilterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageFilter >()))
        return -1;

    QMessageFilterWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageFilter()
    // 1: QMessageFilter(QtMobility::QMessageFilter)
    if (numArgs == 0) {
        overloadId = 0; // QMessageFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 1; // QMessageFilter(QtMobility::QMessageFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageFilter()
            {

                if(!PyErr_Occurred()) {
                // QMessageFilter()
                cptr = new QMessageFilterWrapper();
                }
                break;
            }
            case 1: // QMessageFilter(QtMobility::QMessageFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageFilter(QtMobility::QMessageFilter)
                cptr = new QMessageFilterWrapper(*reinterpret_cast<QMessageFilterWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageFilter_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byAncestorFolderIds(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byAncestorFolderIds(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byAncestorFolderIds(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byAncestorFolderIds(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byAncestorFolderIds", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byAncestorFolderIds_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byAncestorFolderIds(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byAncestorFolderIds(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byAncestorFolderIds(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byAncestorFolderIds(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byAncestorFolderIds(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byAncestorFolderIds(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byAncestorFolderIds_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFolderId, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byAncestorFolderIds", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byId(QList<QtMobility::QMessageId>,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byId(QtMobility::QMessageFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 2: byId(QtMobility::QMessageId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 2; // byId(QtMobility::QMessageId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 2; // byId(QtMobility::QMessageId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byId(QtMobility::QMessageFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byId(QtMobility::QMessageFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    } else if (Shiboken::Converter< QList<QtMobility::QMessageId >  >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byId(QList<QtMobility::QMessageId>,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byId(QList<QtMobility::QMessageId>,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byId(QList<QtMobility::QMessageId>,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QList<QtMobility::QMessageId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QMessageId > >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byId(QList<QtMobility::QMessageId>,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byId(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byId(QtMobility::QMessageFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byId(QtMobility::QMessageFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 2: // byId(QtMobility::QMessageId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
                QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byId(QtMobility::QMessageId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byId_TypeError:
        const char* overloads[] = {"list, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byParentAccountId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentAccountId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentAccountId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentAccountId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byParentAccountId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byParentAccountId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentAccountId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byParentAccountId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byParentAccountId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentAccountId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
                QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byParentAccountId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byParentAccountId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byParentAccountId_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageAccountId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byParentAccountId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byParentFolderId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentFolderId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentFolderId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentFolderId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byParentFolderId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byParentFolderId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentFolderId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byParentFolderId(QtMobility::QMessageFolderFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byParentFolderId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byParentFolderId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byParentFolderId(QtMobility::QMessageFolderId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byParentFolderId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byParentFolderId_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageFolderId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byParentFolderId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byPriority(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byPriority(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byPriority(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byPriority(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byPriority", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byPriority(QtMobility::QMessage::Priority,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<QtMobility::QMessage::Priority >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byPriority(QtMobility::QMessage::Priority,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byPriority(QtMobility::QMessage::Priority,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byPriority_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "cmp");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "cmp";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byPriority(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QMessage::Priority cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Priority >::toCpp(pyargs[0]);
            QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

            if(!PyErr_Occurred()) {
            // byPriority(QtMobility::QMessage::Priority,QtMobility::QMessageDataComparator::EqualityComparator)
            QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byPriority(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byPriority_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.Priority, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byPriority", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byReceptionTimeStamp(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byReceptionTimeStamp(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byReceptionTimeStamp(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byReceptionTimeStamp(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byReceptionTimeStamp", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::RelationComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byReceptionTimeStamp_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byReceptionTimeStamp(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byReceptionTimeStamp(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::RelationComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::RelationComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byReceptionTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byReceptionTimeStamp(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byReceptionTimeStamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", "PySide.QtCore.QDateTime, QtMobility.Messaging.QtMobility::QMessageDataComparator.RelationComparator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byReceptionTimeStamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byRecipients(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byRecipients(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byRecipients(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byRecipients(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byRecipients", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byRecipients(QString,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byRecipients(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byRecipients(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byRecipients_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "cmp");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "cmp";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byRecipients(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

            if(!PyErr_Occurred()) {
            // byRecipients(QString,QtMobility::QMessageDataComparator::InclusionComparator)
            QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byRecipients(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byRecipients_TypeError:
        const char* overloads[] = {"QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byRecipients", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_bySender(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySender(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySender(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySender(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:bySender", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: bySender(QString,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: bySender(QString,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // bySender(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // bySender(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // bySender(QString,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_bySender_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // bySender(QString,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // bySender(QString,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::bySender(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // bySender(QString,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySender(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // bySender(QString,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::bySender(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_bySender_TypeError:
        const char* overloads[] = {"QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator", "QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.bySender", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_bySize(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySize(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySize(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySize(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:bySize", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: bySize(int,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: bySize(int,QtMobility::QMessageDataComparator::RelationComparator)
    if (SbkNumber_Check(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // bySize(int,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::RelationComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // bySize(int,QtMobility::QMessageDataComparator::RelationComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // bySize(int,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_bySize_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // bySize(int,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySize(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // bySize(int,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::bySize(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // bySize(int,QtMobility::QMessageDataComparator::RelationComparator)
            {
                int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::RelationComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::RelationComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // bySize(int,QtMobility::QMessageDataComparator::RelationComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::bySize(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_bySize_TypeError:
        const char* overloads[] = {"int, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", "int, QtMobility.Messaging.QtMobility::QMessageDataComparator.RelationComparator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.bySize", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byStandardFolder(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStandardFolder(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStandardFolder(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStandardFolder(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byStandardFolder", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byStandardFolder(QtMobility::QMessage::StandardFolder,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<QtMobility::QMessage::StandardFolder >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byStandardFolder(QtMobility::QMessage::StandardFolder,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byStandardFolder(QtMobility::QMessage::StandardFolder,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byStandardFolder_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "cmp");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "cmp";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStandardFolder(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QMessage::StandardFolder cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::StandardFolder >::toCpp(pyargs[0]);
            QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

            if(!PyErr_Occurred()) {
            // byStandardFolder(QtMobility::QMessage::StandardFolder,QtMobility::QMessageDataComparator::EqualityComparator)
            QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byStandardFolder(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byStandardFolder_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.StandardFolder, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byStandardFolder", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byStatus(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStatus(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStatus(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStatus(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byStatus", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byStatus(QFlags<QtMobility::QMessage::Status>,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byStatus(QtMobility::QMessage::Status,QtMobility::QMessageDataComparator::EqualityComparator)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessage::Status >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
        overloadId = 1; // byStatus(QtMobility::QMessage::Status,QtMobility::QMessageDataComparator::EqualityComparator)
    } else if (Shiboken::Converter<QFlags<QtMobility::QMessage::Status> >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byStatus(QFlags<QtMobility::QMessage::Status>,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byStatus(QFlags<QtMobility::QMessage::Status>,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byStatus_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byStatus(QFlags<QtMobility::QMessage::Status>,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byStatus(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QFlags<QtMobility::QMessage::Status> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QMessage::Status> >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byStatus(QFlags<QtMobility::QMessage::Status>,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byStatus(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byStatus(QtMobility::QMessage::Status,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                QtMobility::QMessage::Status cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Status >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byStatus(QtMobility::QMessage::Status,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byStatus(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byStatus_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.StatusFlags, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessage.Status, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byStatus", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_bySubject(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySubject(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySubject(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySubject(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:bySubject", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: bySubject(QString,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: bySubject(QString,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // bySubject(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // bySubject(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // bySubject(QString,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_bySubject_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // bySubject(QString,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // bySubject(QString,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::bySubject(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // bySubject(QString,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.bySubject(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // bySubject(QString,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::bySubject(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_bySubject_TypeError:
        const char* overloads[] = {"QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator", "QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.bySubject", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byTimeStamp(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byTimeStamp(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byTimeStamp(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byTimeStamp(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byTimeStamp", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::RelationComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byTimeStamp_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byTimeStamp(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byTimeStamp(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::RelationComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::RelationComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byTimeStamp(QDateTime,QtMobility::QMessageDataComparator::RelationComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byTimeStamp(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byTimeStamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", "PySide.QtCore.QDateTime, QtMobility.Messaging.QtMobility::QMessageDataComparator.RelationComparator", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byTimeStamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_byType(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byType(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byType(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byType(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byType", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byType(QFlags<QtMobility::QMessage::Type>,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byType(QtMobility::QMessage::Type,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<QtMobility::QMessage::Type >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byType(QtMobility::QMessage::Type,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byType(QtMobility::QMessage::Type,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (numArgs == 2 && Shiboken::Converter<QFlags<QtMobility::QMessage::Type> >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
        overloadId = 0; // byType(QFlags<QtMobility::QMessage::Type>,QtMobility::QMessageDataComparator::InclusionComparator)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_byType_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byType(QFlags<QtMobility::QMessage::Type>,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                QFlags<QtMobility::QMessage::Type> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QMessage::Type> >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byType(QFlags<QtMobility::QMessage::Type>,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byType(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byType(QtMobility::QMessage::Type,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFilter.byType(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QtMobility::QMessage::Type cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Type >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byType(QtMobility::QMessage::Type,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageFilter cppResult = QtMobility::QMessageFilter::byType(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc_byType_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.TypeFlags, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator", "QtMobility.Messaging.QtMobility::QMessage.Type, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFilter.byType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_isEmpty(PyObject* self)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QMessageFilter::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_isSupported(PyObject* self)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = cppSelf->QtMobility::QMessageFilter::isSupported();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_matchFlags(PyObject* self)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // matchFlags()const
            QFlags<QtMobility::QMessageDataComparator::MatchFlag> cppResult = cppSelf->QtMobility::QMessageFilter::matchFlags();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFilterFunc_setMatchFlags(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
    if (Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::isConvertible(arg)) {
        overloadId = 0; // setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc_setMatchFlags_TypeError;

    // Call function/method
    {
        {
            QFlags<QtMobility::QMessageDataComparator::MatchFlag> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
            cppSelf->QtMobility::QMessageFilter::setMatchFlags(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFilterFunc_setMatchFlags_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageDataComparator.MatchFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFilter.setMatchFlags", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QMessageFilter_methods[] = {
    {"byAncestorFolderIds", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byAncestorFolderIds, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byId", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byParentAccountId", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byParentAccountId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byParentFolderId", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byParentFolderId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byPriority", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byPriority, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byReceptionTimeStamp", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byReceptionTimeStamp, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byRecipients", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byRecipients, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"bySender", (PyCFunction)SbkQtMobility_QMessageFilterFunc_bySender, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"bySize", (PyCFunction)SbkQtMobility_QMessageFilterFunc_bySize, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byStandardFolder", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byStandardFolder, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byStatus", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byStatus, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"bySubject", (PyCFunction)SbkQtMobility_QMessageFilterFunc_bySubject, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byTimeStamp", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byTimeStamp, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byType", (PyCFunction)SbkQtMobility_QMessageFilterFunc_byType, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQtMobility_QMessageFilterFunc_isEmpty, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQtMobility_QMessageFilterFunc_isSupported, METH_NOARGS},
    {"matchFlags", (PyCFunction)SbkQtMobility_QMessageFilterFunc_matchFlags, METH_NOARGS},
    {"setMatchFlags", (PyCFunction)SbkQtMobility_QMessageFilterFunc_setMatchFlags, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQtMobility_QMessageFilterFunc___and__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rand__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rand__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator&(QtMobility::QMessageFilter)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator&(QtMobility::QMessageFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc___and___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator&(QtMobility::QMessageFilter)const
            QtMobility::QMessageFilter cppResult = (*cppSelf) & (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc___and___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFilter.__and__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc___iand__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator&=(QtMobility::QMessageFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator&=(QtMobility::QMessageFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc___iand___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator&=(QtMobility::QMessageFilter)
            (*cppSelf) &= (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageFilterFunc___iand___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFilter.__iand__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc___or__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__ror__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__ror__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator|(QtMobility::QMessageFilter)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator|(QtMobility::QMessageFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc___or___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator|(QtMobility::QMessageFilter)const
            QtMobility::QMessageFilter cppResult = (*cppSelf) | (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFilterFunc___or___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFilter.__or__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc___ior__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator|=(QtMobility::QMessageFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator|=(QtMobility::QMessageFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFilterFunc___ior___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator|=(QtMobility::QMessageFilter)
            (*cppSelf) |= (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageFilterFunc___ior___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFilter.__ior__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFilterFunc___invert__(PyObject* self)
{
    QtMobility::QMessageFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // operator~()const
            QtMobility::QMessageFilter cppResult = ~ (*cppSelf);
            pyResult = Shiboken::Converter<QtMobility::QMessageFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

// type has number operators
static PyNumberMethods SbkQtMobility_QMessageFilter_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_QMessageFilterFunc___invert__,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_QMessageFilterFunc___and__,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_QMessageFilterFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQtMobility_QMessageFilterFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)SbkQtMobility_QMessageFilterFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageFilter_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageFilter& cpp_self = *Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageFilter & other) const
                QtMobility::QMessageFilter* cpp_other = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFilter  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageFilter_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageFilter & other) const
                QtMobility::QMessageFilter* cpp_other = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFilter  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageFilter_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageFilter_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageFilter_ObjCopierFunc(const void* ptr){
    return new QMessageFilterWrapper(*reinterpret_cast<const QtMobility::QMessageFilter*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQtMobility_QMessageFilter_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageFilter_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageFilter_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageFilter(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageFilter_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageFilter_Type));
    PyModule_AddObject(module, "QMessageFilter",
        ((PyObject*)&SbkQtMobility_QMessageFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFilter >("QtMobility::QMessageFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageFilter >("QtMobility::QMessageFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFilter >(typeid(QtMobility::QMessageFilter).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFilter >(typeid(QMessageFilterWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageFilter >();
}

