/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagedatacomparator_wrapper.h"

// Extra includes

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static PyMethodDef SbkQtMobility_QMessageDataComparator_methods[] = {
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageDataComparator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageDataComparator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageDataComparator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageDataComparator",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InclusionComparator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EqualityComparator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RelationComparator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags>::toCpp(self)
        & Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags>::toCpp(self)
        | Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QMessageDataComparator::MatchFlags >::toPython(
        ~Shiboken::Converter<QtMobility::QMessageDataComparator::MatchFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MatchFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MatchFlags",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QMessageDataComparator(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageDataComparator_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageDataComparator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageDataComparator_Type));
    PyModule_AddObject(module, "QMessageDataComparator",
        ((PyObject*)&SbkQtMobility_QMessageDataComparator_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: InclusionComparator
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_INCLUSIONCOMPARATOR_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
            "InclusionComparator",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type,
        (long) QtMobility::QMessageDataComparator::Includes, "Includes");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "Includes", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type.tp_dict,
        "Includes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type,
        (long) QtMobility::QMessageDataComparator::Excludes, "Excludes");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "Excludes", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_InclusionComparator_Type.tp_dict,
        "Excludes", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageDataComparator::InclusionComparator");

    // init enum class: EqualityComparator
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_EQUALITYCOMPARATOR_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
            "EqualityComparator",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type,
        (long) QtMobility::QMessageDataComparator::Equal, "Equal");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "Equal", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type.tp_dict,
        "Equal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type,
        (long) QtMobility::QMessageDataComparator::NotEqual, "NotEqual");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "NotEqual", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_EqualityComparator_Type.tp_dict,
        "NotEqual", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageDataComparator::EqualityComparator");

    // init enum class: RelationComparator
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_RELATIONCOMPARATOR_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
            "RelationComparator",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type,
        (long) QtMobility::QMessageDataComparator::LessThan, "LessThan");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "LessThan", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type.tp_dict,
        "LessThan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type,
        (long) QtMobility::QMessageDataComparator::LessThanEqual, "LessThanEqual");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "LessThanEqual", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type.tp_dict,
        "LessThanEqual", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type,
        (long) QtMobility::QMessageDataComparator::GreaterThan, "GreaterThan");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "GreaterThan", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type.tp_dict,
        "GreaterThan", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type,
        (long) QtMobility::QMessageDataComparator::GreaterThanEqual, "GreaterThanEqual");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "GreaterThanEqual", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_RelationComparator_Type.tp_dict,
        "GreaterThanEqual", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageDataComparator::RelationComparator");

    // init enum class: MatchFlag
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_MATCHFLAG_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
            "MatchFlag",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type));

    // init flags class: QFlags<QtMobility::QMessageDataComparator::MatchFlag>
    SbkQtMobility_MessagingTypes[SBK_QFLAGS_QTMOBILITY_QMESSAGEDATACOMPARATOR_MATCHFLAG__IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlags_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlags_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
            "MatchFlags",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type,
        (long) QtMobility::QMessageDataComparator::MatchCaseSensitive, "MatchCaseSensitive");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "MatchCaseSensitive", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type.tp_dict,
        "MatchCaseSensitive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type,
        (long) QtMobility::QMessageDataComparator::MatchFullWord, "MatchFullWord");
    PyDict_SetItemString(SbkQtMobility_QMessageDataComparator_Type.super.ht_type.tp_dict,
        "MatchFullWord", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageDataComparator_MatchFlag_Type.tp_dict,
        "MatchFullWord", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageDataComparator::MatchFlag");


}

