/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagecontentcontainerid_wrapper.h"

// Extra includes
#include <qmessagecontentcontainerid.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageContentContainerId_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageContentContainerId >()))
        return -1;

    QtMobility::QMessageContentContainerId* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageContentContainerId", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageContentContainerId()
    // 1: QMessageContentContainerId(QString)
    // 2: QMessageContentContainerId(QtMobility::QMessageContentContainerId)
    if (numArgs == 0) {
        overloadId = 0; // QMessageContentContainerId()
    } else if (numArgs == 1 && Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 1; // QMessageContentContainerId(QString)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageContentContainerId & >::isConvertible(arg)) {
        overloadId = 2; // QMessageContentContainerId(QtMobility::QMessageContentContainerId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerId_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageContentContainerId()
            {

                if(!PyErr_Occurred()) {
                // QMessageContentContainerId()
                cptr = new QtMobility::QMessageContentContainerId();
                }
                break;
            }
            case 1: // QMessageContentContainerId(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageContentContainerId(QString)
                cptr = new QtMobility::QMessageContentContainerId(cpp_arg0);
                }
                break;
            }
            case 2: // QMessageContentContainerId(QtMobility::QMessageContentContainerId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageContentContainerId > cpp_arg0_auto_ptr;
                QtMobility::QMessageContentContainerId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageContentContainerId >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageContentContainerId >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageContentContainerId(QtMobility::QMessageContentContainerId)
                cptr = new QtMobility::QMessageContentContainerId(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageContentContainerId >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageContentContainerId_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageContentContainerId_Init_TypeError:
        const char* overloads[] = {"", "QString", "QtMobility.Messaging.QtMobility::QMessageContentContainerId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageContentContainerId", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageContentContainerIdFunc_isValid(PyObject* self)
{
    QtMobility::QMessageContentContainerId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QMessageContentContainerId::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerIdFunc_toString(PyObject* self)
{
    QtMobility::QMessageContentContainerId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // toString()const
            QString cppResult = cppSelf->QtMobility::QMessageContentContainerId::toString();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageContentContainerId_methods[] = {
    {"isValid", (PyCFunction)SbkQtMobility_QMessageContentContainerIdFunc_isValid, METH_NOARGS},
    {"toString", (PyCFunction)SbkQtMobility_QMessageContentContainerIdFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageContentContainerId_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageContentContainerId& cpp_self = *Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageContentContainerId & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageContentContainerId & other) const
                QtMobility::QMessageContentContainerId* cpp_other = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageContentContainerId  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageContentContainerId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageContentContainerId > cpp_other_auto_ptr;
                QtMobility::QMessageContentContainerId* cpp_other = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageContentContainerId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageContentContainerId >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageContentContainerId_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageContentContainerId & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageContentContainerId & other) const
                QtMobility::QMessageContentContainerId* cpp_other = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageContentContainerId  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageContentContainerId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageContentContainerId > cpp_other_auto_ptr;
                QtMobility::QMessageContentContainerId* cpp_other = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageContentContainerId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageContentContainerId >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageContentContainerId_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageContentContainerId_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageContentContainerId_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageContentContainerId",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageContentContainerId_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageContentContainerId_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageContentContainerId_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageContentContainerId >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageContentContainerId",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageContentContainerId(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGECONTENTCONTAINERID_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageContentContainerId_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageContentContainerId_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageContentContainerId_Type));
    PyModule_AddObject(module, "QMessageContentContainerId",
        ((PyObject*)&SbkQtMobility_QMessageContentContainerId_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageContentContainerId >("QtMobility::QMessageContentContainerId");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageContentContainerId >("QtMobility::QMessageContentContainerId*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageContentContainerId >(typeid(QtMobility::QMessageContentContainerId).name());
    PySide::initQtMetaType<QtMobility::QMessageContentContainerId >();
}

