/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessageaddress_wrapper.h"

// Extra includes
#include <qmessageaddress.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageAddressWrapper::QMessageAddressWrapper() : QtMobility::QMessageAddress() {
    // ... middle
}

QMessageAddressWrapper::QMessageAddressWrapper(QtMobility::QMessageAddress::Type type, const QString & addressee) : QtMobility::QMessageAddress(type, addressee) {
    // ... middle
}

QMessageAddressWrapper::~QMessageAddressWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageAddress_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageAddress >()))
        return -1;

    QMessageAddressWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageAddress", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QMessageAddress()
    // 1: QMessageAddress(QtMobility::QMessageAddress::Type,QString)
    // 2: QMessageAddress(QtMobility::QMessageAddress)
    if (numArgs == 0) {
        overloadId = 0; // QMessageAddress()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageAddress & >::isConvertible(pyargs[0])) {
        overloadId = 2; // QMessageAddress(QtMobility::QMessageAddress)
    } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageAddress::Type >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 1; // QMessageAddress(QtMobility::QMessageAddress::Type,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAddress_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageAddress()
            {

                if(!PyErr_Occurred()) {
                // QMessageAddress()
                cptr = new QMessageAddressWrapper();
                }
                break;
            }
            case 1: // QMessageAddress(QtMobility::QMessageAddress::Type,QString)
            {
                QtMobility::QMessageAddress::Type cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAddress::Type >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // QMessageAddress(QtMobility::QMessageAddress::Type,QString)
                cptr = new QMessageAddressWrapper(cpp_arg0, cpp_arg1);
                }
                break;
            }
            case 2: // QMessageAddress(QtMobility::QMessageAddress)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QMessageAddress* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QMessageAddress(QtMobility::QMessageAddress)
                cptr = new QMessageAddressWrapper(*reinterpret_cast<QMessageAddressWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageAddress >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageAddress_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageAddress_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageAddress.Type, QString", "QtMobility.Messaging.QtMobility::QMessageAddress", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAddress", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageAddressFunc_addressee(PyObject* self)
{
    QtMobility::QMessageAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // addressee()const
            QString cppResult = cppSelf->QtMobility::QMessageAddress::addressee();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAddressFunc_parseEmailAddress(PyObject* self, PyObject* args, PyObject* kwds)
{
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "endDelimeterFound", "startDelimeterFound", "suffix" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 3, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAddress.parseEmailAddress(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 6) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAddress.parseEmailAddress(): too many arguments");
        return 0;
    } else if (numArgs < 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAddress.parseEmailAddress(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:parseEmailAddress", &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;


    // Overloaded function decisor
    // 0: parseEmailAddress(QString,QString*,QString*,QString*,bool*,bool*)
    if (numArgs >= 3 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString * >::isConvertible(pyargs[1]) && Shiboken::Converter<QString * >::isConvertible(pyargs[2])) {
        if (numArgs == 3) {
            overloadId = 0; // parseEmailAddress(QString,QString*,QString*,QString*,bool*,bool*)
        } else if (Shiboken::Converter<QString * >::isConvertible(pyargs[3])) {
            if (numArgs == 4) {
                overloadId = 0; // parseEmailAddress(QString,QString*,QString*,QString*,bool*,bool*)
            } else if (PyBool_Check(pyargs[4])) {
                if (numArgs == 5) {
                    overloadId = 0; // parseEmailAddress(QString,QString*,QString*,QString*,bool*,bool*)
                } else if (PyBool_Check(pyargs[5])) {
                    overloadId = 0; // parseEmailAddress(QString,QString*,QString*,QString*,bool*,bool*)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAddressFunc_parseEmailAddress_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "suffix");
                if (value) {
                    if (pyargs[3])
                        errorArgName = "suffix";
                    else
                        pyargs[3] = value;
                }
                value = PyDict_GetItemString(kwds, "startDelimeterFound");
                if (value) {
                    if (pyargs[4])
                        errorArgName = "startDelimeterFound";
                    else
                        pyargs[4] = value;
                }
                value = PyDict_GetItemString(kwds, "endDelimeterFound");
                if (value) {
                    if (pyargs[5])
                        errorArgName = "endDelimeterFound";
                    else
                        pyargs[5] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAddress.parseEmailAddress(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString * cpp_arg1 = Shiboken::Converter<QString * >::toCpp(pyargs[1]);
            QString * cpp_arg2 = Shiboken::Converter<QString * >::toCpp(pyargs[2]);
            QString * cpp_arg3 = pyargs[3] ? Shiboken::Converter<QString * >::toCpp(pyargs[3]) : 0;
            bool * cpp_arg4 = pyargs[4] ? Shiboken::Converter<bool * >::toCpp(pyargs[4]) : 0;
            bool * cpp_arg5 = pyargs[5] ? Shiboken::Converter<bool * >::toCpp(pyargs[5]) : 0;

            if(!PyErr_Occurred()) {
            // parseEmailAddress(QString,QString*,QString*,QString*,bool*,bool*)
            QtMobility::QMessageAddress::parseEmailAddress(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageAddressFunc_parseEmailAddress_TypeError:
        const char* overloads[] = {"QString, QString, QString, QString = 0, bool = 0, bool = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAddress.parseEmailAddress", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAddressFunc_setAddressee(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAddressee(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setAddressee(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAddressFunc_setAddressee_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAddressee(QString)
            cppSelf->QtMobility::QMessageAddress::setAddressee(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageAddressFunc_setAddressee_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAddress.setAddressee", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAddressFunc_setType(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setType(QtMobility::QMessageAddress::Type)
    if (Shiboken::Converter<QtMobility::QMessageAddress::Type >::isConvertible(arg)) {
        overloadId = 0; // setType(QtMobility::QMessageAddress::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAddressFunc_setType_TypeError;

    // Call function/method
    {
        {
            QtMobility::QMessageAddress::Type cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAddress::Type >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setType(QtMobility::QMessageAddress::Type)
            cppSelf->QtMobility::QMessageAddress::setType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageAddressFunc_setType_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAddress.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAddress.setType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAddressFunc_type(PyObject* self)
{
    QtMobility::QMessageAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QMessageAddress::Type cppResult = cppSelf->QtMobility::QMessageAddress::type();
            pyResult = Shiboken::Converter<QtMobility::QMessageAddress::Type >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageAddress_methods[] = {
    {"addressee", (PyCFunction)SbkQtMobility_QMessageAddressFunc_addressee, METH_NOARGS},
    {"parseEmailAddress", (PyCFunction)SbkQtMobility_QMessageAddressFunc_parseEmailAddress, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setAddressee", (PyCFunction)SbkQtMobility_QMessageAddressFunc_setAddressee, METH_O},
    {"setType", (PyCFunction)SbkQtMobility_QMessageAddressFunc_setType, METH_O},
    {"type", (PyCFunction)SbkQtMobility_QMessageAddressFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageAddress_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageAddress& cpp_self = *Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageAddress & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageAddress & other) const
                QtMobility::QMessageAddress* cpp_other = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAddress  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageAddress_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageAddress & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageAddress & other) const
                QtMobility::QMessageAddress* cpp_other = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAddress  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageAddress_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageAddress_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageAddress_ObjCopierFunc(const void* ptr){
    return new QMessageAddressWrapper(*reinterpret_cast<const QtMobility::QMessageAddress*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageAddress_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageAddress",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageAddress_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageAddress_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageAddress_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageAddress_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageAddress >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageAddress",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QMessageAddress(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEADDRESS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageAddress_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageAddress_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageAddress_Type));
    PyModule_AddObject(module, "QMessageAddress",
        ((PyObject*)&SbkQtMobility_QMessageAddress_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Type
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEADDRESS_TYPE_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageAddress_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type,
        (long) QtMobility::QMessageAddress::System, "System");
    PyDict_SetItemString(SbkQtMobility_QMessageAddress_Type.super.ht_type.tp_dict,
        "System", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type.tp_dict,
        "System", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type,
        (long) QtMobility::QMessageAddress::Phone, "Phone");
    PyDict_SetItemString(SbkQtMobility_QMessageAddress_Type.super.ht_type.tp_dict,
        "Phone", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type.tp_dict,
        "Phone", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type,
        (long) QtMobility::QMessageAddress::Email, "Email");
    PyDict_SetItemString(SbkQtMobility_QMessageAddress_Type.super.ht_type.tp_dict,
        "Email", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type.tp_dict,
        "Email", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type,
        (long) QtMobility::QMessageAddress::InstantMessage, "InstantMessage");
    PyDict_SetItemString(SbkQtMobility_QMessageAddress_Type.super.ht_type.tp_dict,
        "InstantMessage", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageAddress_Type_Type.tp_dict,
        "InstantMessage", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageAddress::Type");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAddress >("QtMobility::QMessageAddress");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageAddress >("QtMobility::QMessageAddress*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAddress >(typeid(QtMobility::QMessageAddress).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAddress >(typeid(QMessageAddressWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageAddress >();
}

