/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessageaccountsortorder_wrapper.h"

// Extra includes
#include <qmessageaccountsortorder.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageAccountSortOrderWrapper::QMessageAccountSortOrderWrapper() : QtMobility::QMessageAccountSortOrder() {
    // ... middle
}

QMessageAccountSortOrderWrapper::~QMessageAccountSortOrderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageAccountSortOrder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageAccountSortOrder >()))
        return -1;

    QMessageAccountSortOrderWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageAccountSortOrder", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageAccountSortOrder()
    // 1: QMessageAccountSortOrder(QtMobility::QMessageAccountSortOrder)
    if (numArgs == 0) {
        overloadId = 0; // QMessageAccountSortOrder()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageAccountSortOrder & >::isConvertible(arg)) {
        overloadId = 1; // QMessageAccountSortOrder(QtMobility::QMessageAccountSortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountSortOrder_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageAccountSortOrder()
            {

                if(!PyErr_Occurred()) {
                // QMessageAccountSortOrder()
                cptr = new QMessageAccountSortOrderWrapper();
                }
                break;
            }
            case 1: // QMessageAccountSortOrder(QtMobility::QMessageAccountSortOrder)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageAccountSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageAccountSortOrder(QtMobility::QMessageAccountSortOrder)
                cptr = new QMessageAccountSortOrderWrapper(*reinterpret_cast<QMessageAccountSortOrderWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageAccountSortOrder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageAccountSortOrder_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageAccountSortOrder_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageAccountSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAccountSortOrder", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageAccountSortOrderFunc_byName(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountSortOrder.byName(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountSortOrder.byName(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byName", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byName(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byName(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byName(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountSortOrderFunc_byName_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountSortOrder.byName(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byName(Qt::SortOrder)
            QtMobility::QMessageAccountSortOrder cppResult = QtMobility::QMessageAccountSortOrder::byName(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageAccountSortOrderFunc_byName_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccountSortOrder.byName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountSortOrderFunc_isEmpty(PyObject* self)
{
    QtMobility::QMessageAccountSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QMessageAccountSortOrder::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountSortOrderFunc_isSupported(PyObject* self)
{
    QtMobility::QMessageAccountSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = cppSelf->QtMobility::QMessageAccountSortOrder::isSupported();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageAccountSortOrder_methods[] = {
    {"byName", (PyCFunction)SbkQtMobility_QMessageAccountSortOrderFunc_byName, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQtMobility_QMessageAccountSortOrderFunc_isEmpty, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQtMobility_QMessageAccountSortOrderFunc_isSupported, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageAccountSortOrder_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageAccountSortOrder& cpp_self = *Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageAccountSortOrder & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageAccountSortOrder & other) const
                QtMobility::QMessageAccountSortOrder* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountSortOrder  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountSortOrder_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageAccountSortOrder & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageAccountSortOrder & other) const
                QtMobility::QMessageAccountSortOrder* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountSortOrder  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountSortOrder_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageAccountSortOrder_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageAccountSortOrder_ObjCopierFunc(const void* ptr){
    return new QMessageAccountSortOrderWrapper(*reinterpret_cast<const QtMobility::QMessageAccountSortOrder*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageAccountSortOrder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageAccountSortOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageAccountSortOrder_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageAccountSortOrder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageAccountSortOrder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageAccountSortOrder_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageAccountSortOrder >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageAccountSortOrder",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageAccountSortOrder(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNTSORTORDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageAccountSortOrder_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageAccountSortOrder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageAccountSortOrder_Type));
    PyModule_AddObject(module, "QMessageAccountSortOrder",
        ((PyObject*)&SbkQtMobility_QMessageAccountSortOrder_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountSortOrder >("QtMobility::QMessageAccountSortOrder");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageAccountSortOrder >("QtMobility::QMessageAccountSortOrder*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountSortOrder >(typeid(QtMobility::QMessageAccountSortOrder).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountSortOrder >(typeid(QMessageAccountSortOrderWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageAccountSortOrder >();
}

