/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessageaccountfilter_wrapper.h"

// Extra includes
#include <QList>
#include <qmessageaccountfilter.h>
#include <qmessageaccountid.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageAccountFilterWrapper::QMessageAccountFilterWrapper() : QtMobility::QMessageAccountFilter() {
    // ... middle
}

QMessageAccountFilterWrapper::~QMessageAccountFilterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageAccountFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageAccountFilter >()))
        return -1;

    QMessageAccountFilterWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageAccountFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageAccountFilter()
    // 1: QMessageAccountFilter(QtMobility::QMessageAccountFilter)
    if (numArgs == 0) {
        overloadId = 0; // QMessageAccountFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(arg)) {
        overloadId = 1; // QMessageAccountFilter(QtMobility::QMessageAccountFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageAccountFilter()
            {

                if(!PyErr_Occurred()) {
                // QMessageAccountFilter()
                cptr = new QMessageAccountFilterWrapper();
                }
                break;
            }
            case 1: // QMessageAccountFilter(QtMobility::QMessageAccountFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageAccountFilter(QtMobility::QMessageAccountFilter)
                cptr = new QMessageAccountFilterWrapper(*reinterpret_cast<QMessageAccountFilterWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageAccountFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageAccountFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageAccountFilter_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageAccountFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAccountFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc_byId(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byId(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byId(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byId(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byId", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byId(QList<QtMobility::QMessageAccountId>,QtMobility::QMessageDataComparator::InclusionComparator)
    // 1: byId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
    // 2: byId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
    if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 2; // byId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 2; // byId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    } else if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    } else if (Shiboken::Converter< QList<QtMobility::QMessageAccountId >  >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // byId(QList<QtMobility::QMessageAccountId>,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byId(QList<QtMobility::QMessageAccountId>,QtMobility::QMessageDataComparator::InclusionComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc_byId_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byId(QList<QtMobility::QMessageAccountId>,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QList<QtMobility::QMessageAccountId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QMessageAccountId > >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byId(QList<QtMobility::QMessageAccountId>,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageAccountFilter cppResult = QtMobility::QMessageAccountFilter::byId(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byId(QtMobility::QMessageAccountFilter,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageAccountFilter cppResult = QtMobility::QMessageAccountFilter::byId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
                }
                break;
            }
            case 2: // byId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byId(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
                QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Equal;

                if(!PyErr_Occurred()) {
                // byId(QtMobility::QMessageAccountId,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageAccountFilter cppResult = QtMobility::QMessageAccountFilter::byId(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageAccountFilterFunc_byId_TypeError:
        const char* overloads[] = {"list, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageAccountFilter, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", "QtMobility.Messaging.QtMobility::QMessageAccountId, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator = QMessageDataComparator.Equal", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAccountFilter.byId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc_byName(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "cmp" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byName(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byName(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byName(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:byName", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
    // 1: byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::isConvertible(pyargs[1])) {
            overloadId = 1; // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
        } else if (numArgs == 2 && Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::isConvertible(pyargs[1])) {
            overloadId = 0; // byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc_byName_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::EqualityComparator cpp_arg1 = Shiboken::Converter<QtMobility::QMessageDataComparator::EqualityComparator >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // byName(QString,QtMobility::QMessageDataComparator::EqualityComparator)
                QtMobility::QMessageAccountFilter cppResult = QtMobility::QMessageAccountFilter::byName(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "cmp");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "cmp";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageAccountFilter.byName(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QtMobility::QMessageDataComparator::InclusionComparator cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageDataComparator::InclusionComparator >::toCpp(pyargs[1]) : QtMobility::QMessageDataComparator::Includes;

                if(!PyErr_Occurred()) {
                // byName(QString,QtMobility::QMessageDataComparator::InclusionComparator)
                QtMobility::QMessageAccountFilter cppResult = QtMobility::QMessageAccountFilter::byName(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageAccountFilterFunc_byName_TypeError:
        const char* overloads[] = {"QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.EqualityComparator", "QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.InclusionComparator = QMessageDataComparator.Includes", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAccountFilter.byName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc_isEmpty(PyObject* self)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QMessageAccountFilter::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc_isSupported(PyObject* self)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = cppSelf->QtMobility::QMessageAccountFilter::isSupported();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc_matchFlags(PyObject* self)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // matchFlags()const
            QFlags<QtMobility::QMessageDataComparator::MatchFlag> cppResult = cppSelf->QtMobility::QMessageAccountFilter::matchFlags();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc_setMatchFlags(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
    if (Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::isConvertible(arg)) {
        overloadId = 0; // setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc_setMatchFlags_TypeError;

    // Call function/method
    {
        {
            QFlags<QtMobility::QMessageDataComparator::MatchFlag> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setMatchFlags(QFlags<QtMobility::QMessageDataComparator::MatchFlag>)
            cppSelf->QtMobility::QMessageAccountFilter::setMatchFlags(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageAccountFilterFunc_setMatchFlags_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageDataComparator.MatchFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccountFilter.setMatchFlags", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QMessageAccountFilter_methods[] = {
    {"byId", (PyCFunction)SbkQtMobility_QMessageAccountFilterFunc_byId, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byName", (PyCFunction)SbkQtMobility_QMessageAccountFilterFunc_byName, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQtMobility_QMessageAccountFilterFunc_isEmpty, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQtMobility_QMessageAccountFilterFunc_isSupported, METH_NOARGS},
    {"matchFlags", (PyCFunction)SbkQtMobility_QMessageAccountFilterFunc_matchFlags, METH_NOARGS},
    {"setMatchFlags", (PyCFunction)SbkQtMobility_QMessageAccountFilterFunc_setMatchFlags, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQtMobility_QMessageAccountFilterFunc___and__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rand__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rand__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator&(QtMobility::QMessageAccountFilter)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator&(QtMobility::QMessageAccountFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc___and___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator&(QtMobility::QMessageAccountFilter)const
            QtMobility::QMessageAccountFilter cppResult = (*cppSelf) & (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageAccountFilterFunc___and___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccountFilter.__and__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc___iand__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator&=(QtMobility::QMessageAccountFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator&=(QtMobility::QMessageAccountFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc___iand___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator&=(QtMobility::QMessageAccountFilter)
            (*cppSelf) &= (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageAccountFilterFunc___iand___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccountFilter.__iand__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc___or__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__ror__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__ror__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator|(QtMobility::QMessageAccountFilter)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator|(QtMobility::QMessageAccountFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc___or___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator|(QtMobility::QMessageAccountFilter)const
            QtMobility::QMessageAccountFilter cppResult = (*cppSelf) | (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageAccountFilterFunc___or___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccountFilter.__or__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc___ior__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageAccountFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator|=(QtMobility::QMessageAccountFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator|=(QtMobility::QMessageAccountFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFilterFunc___ior___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator|=(QtMobility::QMessageAccountFilter)
            (*cppSelf) |= (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageAccountFilterFunc___ior___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccountFilter.__ior__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFilterFunc___invert__(PyObject* self)
{
    QtMobility::QMessageAccountFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // operator~()const
            QtMobility::QMessageAccountFilter cppResult = ~ (*cppSelf);
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountFilter >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

// type has number operators
static PyNumberMethods SbkQtMobility_QMessageAccountFilter_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_QMessageAccountFilterFunc___invert__,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_QMessageAccountFilterFunc___and__,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_QMessageAccountFilterFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQtMobility_QMessageAccountFilterFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)SbkQtMobility_QMessageAccountFilterFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageAccountFilter_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageAccountFilter& cpp_self = *Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageAccountFilter & other) const
                QtMobility::QMessageAccountFilter* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountFilter  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountFilter_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageAccountFilter & other) const
                QtMobility::QMessageAccountFilter* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountFilter  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountFilter_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageAccountFilter_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageAccountFilter_ObjCopierFunc(const void* ptr){
    return new QMessageAccountFilterWrapper(*reinterpret_cast<const QtMobility::QMessageAccountFilter*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageAccountFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageAccountFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQtMobility_QMessageAccountFilter_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageAccountFilter_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageAccountFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageAccountFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageAccountFilter_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageAccountFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageAccountFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageAccountFilter(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNTFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageAccountFilter_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageAccountFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageAccountFilter_Type));
    PyModule_AddObject(module, "QMessageAccountFilter",
        ((PyObject*)&SbkQtMobility_QMessageAccountFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountFilter >("QtMobility::QMessageAccountFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageAccountFilter >("QtMobility::QMessageAccountFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountFilter >(typeid(QtMobility::QMessageAccountFilter).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountFilter >(typeid(QMessageAccountFilterWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageAccountFilter >();
}

