/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessageaccount_wrapper.h"

// Extra includes
#include <qmessageaccount.h>
#include <qmessageaccountid.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageAccountWrapper::QMessageAccountWrapper() : QtMobility::QMessageAccount() {
    // ... middle
}

QMessageAccountWrapper::QMessageAccountWrapper(const QtMobility::QMessageAccountId & id) : QtMobility::QMessageAccount(id) {
    // ... middle
}

QMessageAccountWrapper::~QMessageAccountWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageAccount_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageAccount >()))
        return -1;

    QMessageAccountWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageAccount", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageAccount()
    // 1: QMessageAccount(QtMobility::QMessageAccount)
    // 2: QMessageAccount(QtMobility::QMessageAccountId)
    if (numArgs == 0) {
        overloadId = 0; // QMessageAccount()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(arg)) {
        overloadId = 2; // QMessageAccount(QtMobility::QMessageAccountId)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageAccount & >::isConvertible(arg)) {
        overloadId = 1; // QMessageAccount(QtMobility::QMessageAccount)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccount_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageAccount()
            {

                if(!PyErr_Occurred()) {
                // QMessageAccount()
                cptr = new QMessageAccountWrapper();
                }
                break;
            }
            case 1: // QMessageAccount(QtMobility::QMessageAccount)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageAccount > cpp_arg0_auto_ptr;
                QtMobility::QMessageAccount* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccount* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageAccount >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccount >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageAccount(QtMobility::QMessageAccount)
                cptr = new QMessageAccountWrapper(*reinterpret_cast<QMessageAccountWrapper*>(cpp_arg0));
                }
                break;
            }
            case 2: // QMessageAccount(QtMobility::QMessageAccountId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
                QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageAccount(QtMobility::QMessageAccountId)
                cptr = new QMessageAccountWrapper(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageAccount >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageAccount_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageAccount_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageAccount", "QtMobility.Messaging.QtMobility::QMessageAccountId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAccount", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageAccountFunc_defaultAccount(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: defaultAccount(QtMobility::QMessage::Type)
    if (Shiboken::Converter<QtMobility::QMessage::Type >::isConvertible(arg)) {
        overloadId = 0; // defaultAccount(QtMobility::QMessage::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountFunc_defaultAccount_TypeError;

    // Call function/method
    {
        {
            QtMobility::QMessage::Type cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Type >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // defaultAccount(QtMobility::QMessage::Type)
            QtMobility::QMessageAccountId cppResult = QtMobility::QMessageAccount::defaultAccount(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageAccountFunc_defaultAccount_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageAccount.defaultAccount", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageAccountFunc_id(PyObject* self)
{
    QtMobility::QMessageAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // id()const
            QtMobility::QMessageAccountId cppResult = cppSelf->QtMobility::QMessageAccount::id();
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountFunc_messageTypes(PyObject* self)
{
    QtMobility::QMessageAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // messageTypes()const
            QFlags<QtMobility::QMessage::Type> cppResult = cppSelf->QtMobility::QMessageAccount::messageTypes();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QMessage::Type> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountFunc_name(PyObject* self)
{
    QtMobility::QMessageAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // name()const
            QString cppResult = cppSelf->QtMobility::QMessageAccount::name();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageAccount_methods[] = {
    {"defaultAccount", (PyCFunction)SbkQtMobility_QMessageAccountFunc_defaultAccount, METH_O|METH_STATIC},
    {"id", (PyCFunction)SbkQtMobility_QMessageAccountFunc_id, METH_NOARGS},
    {"messageTypes", (PyCFunction)SbkQtMobility_QMessageAccountFunc_messageTypes, METH_NOARGS},
    {"name", (PyCFunction)SbkQtMobility_QMessageAccountFunc_name, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

static void* SbkQtMobility_QMessageAccount_ObjCopierFunc(const void* ptr){
    return new QMessageAccountWrapper(*reinterpret_cast<const QtMobility::QMessageAccount*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageAccount_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageAccount",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageAccount_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageAccount_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageAccount_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageAccount >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageAccount",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageAccount(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageAccount_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageAccount_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageAccount_Type));
    PyModule_AddObject(module, "QMessageAccount",
        ((PyObject*)&SbkQtMobility_QMessageAccount_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccount >("QtMobility::QMessageAccount");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageAccount >("QtMobility::QMessageAccount*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccount >(typeid(QtMobility::QMessageAccount).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccount >(typeid(QMessageAccountWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageAccount >();
}

