/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessage_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qdatastream.h>
#include <qdatetime.h>
#include <qmessage.h>
#include <qmessageaccountid.h>
#include <qmessageaddress.h>
#include <qmessagecontentcontainer.h>
#include <qmessagecontentcontainerid.h>
#include <qmessagefolderid.h>
#include <qmessageid.h>
#include <qtextstream.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageWrapper::QMessageWrapper() : QtMobility::QMessage() {
    // ... middle
}

QMessageWrapper::QMessageWrapper(const QtMobility::QMessageId & id) : QtMobility::QMessage(id) {
    // ... middle
}

QMessageWrapper::~QMessageWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessage_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessage >()))
        return -1;

    QMessageWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessage", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessage()
    // 1: QMessage(QtMobility::QMessage)
    // 2: QMessage(QtMobility::QMessageId)
    if (numArgs == 0) {
        overloadId = 0; // QMessage()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(arg)) {
        overloadId = 2; // QMessage(QtMobility::QMessageId)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessage & >::isConvertible(arg)) {
        overloadId = 1; // QMessage(QtMobility::QMessage)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessage_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessage()
            {

                if(!PyErr_Occurred()) {
                // QMessage()
                cptr = new QMessageWrapper();
                }
                break;
            }
            case 1: // QMessage(QtMobility::QMessage)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessage > cpp_arg0_auto_ptr;
                QtMobility::QMessage* cpp_arg0 = Shiboken::Converter<QtMobility::QMessage* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessage >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessage >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessage(QtMobility::QMessage)
                cptr = new QMessageWrapper(*reinterpret_cast<QMessageWrapper*>(cpp_arg0));
                }
                break;
            }
            case 2: // QMessage(QtMobility::QMessageId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
                QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessage(QtMobility::QMessageId)
                cptr = new QMessageWrapper(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessage >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessage_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessage_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessage", "QtMobility.Messaging.QtMobility::QMessageId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessage", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageFunc_appendAttachments(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: appendAttachments(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // appendAttachments(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_appendAttachments_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // appendAttachments(QStringList)
            cppSelf->QtMobility::QMessage::appendAttachments(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_appendAttachments_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.appendAttachments", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_attachmentIds(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // attachmentIds()const
            QList<QtMobility::QMessageContentContainerId > cppResult = cppSelf->QtMobility::QMessage::attachmentIds();
            pyResult = Shiboken::Converter<QList<QtMobility::QMessageContentContainerId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_bcc(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // bcc()const
            QList<QtMobility::QMessageAddress > cppResult = cppSelf->QtMobility::QMessage::bcc();
            pyResult = Shiboken::Converter<QList<QtMobility::QMessageAddress > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_bodyId(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // bodyId()const
            QtMobility::QMessageContentContainerId cppResult = cppSelf->QtMobility::QMessage::bodyId();
            pyResult = Shiboken::Converter<QtMobility::QMessageContentContainerId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_cc(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // cc()const
            QList<QtMobility::QMessageAddress > cppResult = cppSelf->QtMobility::QMessage::cc();
            pyResult = Shiboken::Converter<QList<QtMobility::QMessageAddress > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_clearAttachments(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clearAttachments()
            cppSelf->QtMobility::QMessage::clearAttachments();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QMessageFunc_createResponseMessage(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: createResponseMessage(QtMobility::QMessage::ResponseType)const
    if (Shiboken::Converter<QtMobility::QMessage::ResponseType >::isConvertible(arg)) {
        overloadId = 0; // createResponseMessage(QtMobility::QMessage::ResponseType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_createResponseMessage_TypeError;

    // Call function/method
    {
        {
            QtMobility::QMessage::ResponseType cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::ResponseType >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // createResponseMessage(QtMobility::QMessage::ResponseType)const
            QtMobility::QMessage cppResult = cppSelf->QtMobility::QMessage::createResponseMessage(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessage >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFunc_createResponseMessage_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.ResponseType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.createResponseMessage", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_date(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // date()const
            QDateTime cppResult = cppSelf->QtMobility::QMessage::date();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_from_(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // from()const
            QtMobility::QMessageAddress cppResult = cppSelf->QtMobility::QMessage::from();
            pyResult = Shiboken::Converter<QtMobility::QMessageAddress >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_id(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // id()const
            QtMobility::QMessageId cppResult = cppSelf->QtMobility::QMessage::id();
            pyResult = Shiboken::Converter<QtMobility::QMessageId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_isModified(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isModified()const
            bool cppResult = cppSelf->QtMobility::QMessage::isModified();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_parentAccountId(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // parentAccountId()const
            QtMobility::QMessageAccountId cppResult = cppSelf->QtMobility::QMessage::parentAccountId();
            pyResult = Shiboken::Converter<QtMobility::QMessageAccountId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_parentFolderId(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // parentFolderId()const
            QtMobility::QMessageFolderId cppResult = cppSelf->QtMobility::QMessage::parentFolderId();
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_preferredCharsetFor(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: preferredCharsetFor(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // preferredCharsetFor(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_preferredCharsetFor_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // preferredCharsetFor(QString)
            QByteArray cppResult = QtMobility::QMessage::preferredCharsetFor(cpp_arg0);
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFunc_preferredCharsetFor_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.preferredCharsetFor", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_preferredCharsets(PyObject* self)
{
    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // preferredCharsets()
            QList<QByteArray > cppResult = QtMobility::QMessage::preferredCharsets();
            pyResult = Shiboken::Converter<QList<QByteArray > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_priority(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // priority()const
            QtMobility::QMessage::Priority cppResult = cppSelf->QtMobility::QMessage::priority();
            pyResult = Shiboken::Converter<QtMobility::QMessage::Priority >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_receivedDate(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // receivedDate()const
            QDateTime cppResult = cppSelf->QtMobility::QMessage::receivedDate();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_setBcc(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setBcc(QList<QtMobility::QMessageAddress>)
    if (Shiboken::Converter< QList<QtMobility::QMessageAddress >  >::isConvertible(arg)) {
        overloadId = 0; // setBcc(QList<QtMobility::QMessageAddress>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setBcc_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QMessageAddress > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QMessageAddress > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setBcc(QList<QtMobility::QMessageAddress>)
            cppSelf->QtMobility::QMessage::setBcc(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setBcc_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setBcc", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setBody(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "mimeType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessage.setBody(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessage.setBody(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessage.setBody(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:setBody", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setBody(QTextStream&,QByteArray)
    // 1: setBody(QString,QByteArray)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // setBody(QString,QByteArray)
        } else if (Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[1])) {
            overloadId = 1; // setBody(QString,QByteArray)
        }
    } else if (Shiboken::Converter<QTextStream & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // setBody(QTextStream&,QByteArray)
        } else if (Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[1])) {
            overloadId = 0; // setBody(QTextStream&,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setBody_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setBody(QTextStream&,QByteArray)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "mimeType");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "mimeType";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessage.setBody(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QTextStream* cpp_arg0 = Shiboken::Converter<QTextStream* >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
                QByteArray cpp_arg1_tmp = QByteArray();
                QByteArray* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                if (pyargs[1] && !Shiboken::Converter<QByteArray >::checkType(pyargs[1]))
                    cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);

                if(!PyErr_Occurred()) {
                // setBody(QTextStream&,QByteArray)
                cppSelf->QtMobility::QMessage::setBody(*cpp_arg0, *cpp_arg1);
                }
                break;
            }
            case 1: // setBody(QString,QByteArray)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "mimeType");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "mimeType";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessage.setBody(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
                QByteArray cpp_arg1_tmp = QByteArray();
                QByteArray* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                if (pyargs[1] && !Shiboken::Converter<QByteArray >::checkType(pyargs[1]))
                    cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);

                if(!PyErr_Occurred()) {
                // setBody(QString,QByteArray)
                cppSelf->QtMobility::QMessage::setBody(cpp_arg0, *cpp_arg1);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setBody_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream, PySide.QtCore.QByteArray = QByteArray()", "QString, PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessage.setBody", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setCc(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCc(QList<QtMobility::QMessageAddress>)
    if (Shiboken::Converter< QList<QtMobility::QMessageAddress >  >::isConvertible(arg)) {
        overloadId = 0; // setCc(QList<QtMobility::QMessageAddress>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setCc_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QMessageAddress > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QMessageAddress > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCc(QList<QtMobility::QMessageAddress>)
            cppSelf->QtMobility::QMessage::setCc(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setCc_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setCc", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setDate(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDate(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setDate(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setDate_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDate(QDateTime)
            cppSelf->QtMobility::QMessage::setDate(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setDate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setFrom(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setFrom(QtMobility::QMessageAddress)
    if (Shiboken::Converter<const QtMobility::QMessageAddress & >::isConvertible(arg)) {
        overloadId = 0; // setFrom(QtMobility::QMessageAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setFrom_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageAddress* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setFrom(QtMobility::QMessageAddress)
            cppSelf->QtMobility::QMessage::setFrom(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setFrom_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setFrom", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setParentAccountId(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setParentAccountId(QtMobility::QMessageAccountId)
    if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(arg)) {
        overloadId = 0; // setParentAccountId(QtMobility::QMessageAccountId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setParentAccountId_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
            QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setParentAccountId(QtMobility::QMessageAccountId)
            cppSelf->QtMobility::QMessage::setParentAccountId(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setParentAccountId_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setParentAccountId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setPreferredCharsets(PyObject* self, PyObject* arg)
{
    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPreferredCharsets(QList<QByteArray>)
    if (Shiboken::Converter< QList<QByteArray >  >::isConvertible(arg)) {
        overloadId = 0; // setPreferredCharsets(QList<QByteArray>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setPreferredCharsets_TypeError;

    // Call function/method
    {
        {
            QList<QByteArray > cpp_arg0 = Shiboken::Converter<QList<QByteArray > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPreferredCharsets(QList<QByteArray>)
            QtMobility::QMessage::setPreferredCharsets(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setPreferredCharsets_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setPreferredCharsets", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setPriority(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPriority(QtMobility::QMessage::Priority)
    if (Shiboken::Converter<QtMobility::QMessage::Priority >::isConvertible(arg)) {
        overloadId = 0; // setPriority(QtMobility::QMessage::Priority)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setPriority_TypeError;

    // Call function/method
    {
        {
            QtMobility::QMessage::Priority cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Priority >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPriority(QtMobility::QMessage::Priority)
            cppSelf->QtMobility::QMessage::setPriority(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setPriority_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.Priority", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setPriority", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setReceivedDate(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setReceivedDate(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setReceivedDate(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setReceivedDate_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setReceivedDate(QDateTime)
            cppSelf->QtMobility::QMessage::setReceivedDate(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setReceivedDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setReceivedDate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setStatus(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "set" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessage.setStatus(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessage.setStatus(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessage.setStatus(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:setStatus", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setStatus(QFlags<QtMobility::QMessage::Status>)
    // 1: setStatus(QtMobility::QMessage::Status,bool)
    if (Shiboken::Converter<QtMobility::QMessage::Status >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // setStatus(QtMobility::QMessage::Status,bool)
        } else if (SbkNumber_Check(pyargs[1])) {
            overloadId = 1; // setStatus(QtMobility::QMessage::Status,bool)
        }
    } else if (numArgs == 1 && Shiboken::Converter<QFlags<QtMobility::QMessage::Status> >::isConvertible(pyargs[0])) {
        overloadId = 0; // setStatus(QFlags<QtMobility::QMessage::Status>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setStatus_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setStatus(QFlags<QtMobility::QMessage::Status>)
            {
                QFlags<QtMobility::QMessage::Status> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QMessage::Status> >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // setStatus(QFlags<QtMobility::QMessage::Status>)
                cppSelf->QtMobility::QMessage::setStatus(cpp_arg0);
                }
                break;
            }
            case 1: // setStatus(QtMobility::QMessage::Status,bool)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "set");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "set";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessage.setStatus(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QtMobility::QMessage::Status cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Status >::toCpp(pyargs[0]);
                bool cpp_arg1 = pyargs[1] ? Shiboken::Converter<bool >::toCpp(pyargs[1]) : true;

                if(!PyErr_Occurred()) {
                // setStatus(QtMobility::QMessage::Status,bool)
                cppSelf->QtMobility::QMessage::setStatus(cpp_arg0, cpp_arg1);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setStatus_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.StatusFlags", "QtMobility.Messaging.QtMobility::QMessage.Status, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessage.setStatus", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setSubject(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSubject(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSubject(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setSubject_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSubject(QString)
            cppSelf->QtMobility::QMessage::setSubject(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setSubject_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setSubject", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setTo(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setTo(QList<QtMobility::QMessageAddress>)
    // 1: setTo(QtMobility::QMessageAddress)
    if (Shiboken::Converter<const QtMobility::QMessageAddress & >::isConvertible(arg)) {
        overloadId = 1; // setTo(QtMobility::QMessageAddress)
    } else if (Shiboken::Converter< QList<QtMobility::QMessageAddress >  >::isConvertible(arg)) {
        overloadId = 0; // setTo(QList<QtMobility::QMessageAddress>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setTo_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setTo(QList<QtMobility::QMessageAddress>)
            {
                QList<QtMobility::QMessageAddress > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QMessageAddress > >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setTo(QList<QtMobility::QMessageAddress>)
                cppSelf->QtMobility::QMessage::setTo(cpp_arg0);
                }
                break;
            }
            case 1: // setTo(QtMobility::QMessageAddress)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return 0;
                QtMobility::QMessageAddress* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAddress* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setTo(QtMobility::QMessageAddress)
                cppSelf->QtMobility::QMessage::setTo(*cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setTo_TypeError:
        const char* overloads[] = {"list", "QtMobility.Messaging.QtMobility::QMessageAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setTo", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_setType(PyObject* self, PyObject* arg)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setType(QtMobility::QMessage::Type)
    if (Shiboken::Converter<QtMobility::QMessage::Type >::isConvertible(arg)) {
        overloadId = 0; // setType(QtMobility::QMessage::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFunc_setType_TypeError;

    // Call function/method
    {
        {
            QtMobility::QMessage::Type cpp_arg0 = Shiboken::Converter<QtMobility::QMessage::Type >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setType(QtMobility::QMessage::Type)
            cppSelf->QtMobility::QMessage::setType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageFunc_setType_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage.Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessage.setType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFunc_size(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // size()const
            int cppResult = cppSelf->QtMobility::QMessage::size();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_standardFolder(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // standardFolder()const
            QtMobility::QMessage::StandardFolder cppResult = cppSelf->QtMobility::QMessage::standardFolder();
            pyResult = Shiboken::Converter<QtMobility::QMessage::StandardFolder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_status(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // status()const
            QFlags<QtMobility::QMessage::Status> cppResult = cppSelf->QtMobility::QMessage::status();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QMessage::Status> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_subject(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // subject()const
            QString cppResult = cppSelf->QtMobility::QMessage::subject();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_to(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // to()const
            QList<QtMobility::QMessageAddress > cppResult = cppSelf->QtMobility::QMessage::to();
            pyResult = Shiboken::Converter<QList<QtMobility::QMessageAddress > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFunc_type(PyObject* self)
{
    QtMobility::QMessage* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessage* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QMessage::Type cppResult = cppSelf->QtMobility::QMessage::type();
            pyResult = Shiboken::Converter<QtMobility::QMessage::Type >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessage_methods[] = {
    {"appendAttachments", (PyCFunction)SbkQtMobility_QMessageFunc_appendAttachments, METH_O},
    {"attachmentIds", (PyCFunction)SbkQtMobility_QMessageFunc_attachmentIds, METH_NOARGS},
    {"bcc", (PyCFunction)SbkQtMobility_QMessageFunc_bcc, METH_NOARGS},
    {"bodyId", (PyCFunction)SbkQtMobility_QMessageFunc_bodyId, METH_NOARGS},
    {"cc", (PyCFunction)SbkQtMobility_QMessageFunc_cc, METH_NOARGS},
    {"clearAttachments", (PyCFunction)SbkQtMobility_QMessageFunc_clearAttachments, METH_NOARGS},
    {"createResponseMessage", (PyCFunction)SbkQtMobility_QMessageFunc_createResponseMessage, METH_O},
    {"date", (PyCFunction)SbkQtMobility_QMessageFunc_date, METH_NOARGS},
    {"from_", (PyCFunction)SbkQtMobility_QMessageFunc_from_, METH_NOARGS},
    {"id", (PyCFunction)SbkQtMobility_QMessageFunc_id, METH_NOARGS},
    {"isModified", (PyCFunction)SbkQtMobility_QMessageFunc_isModified, METH_NOARGS},
    {"parentAccountId", (PyCFunction)SbkQtMobility_QMessageFunc_parentAccountId, METH_NOARGS},
    {"parentFolderId", (PyCFunction)SbkQtMobility_QMessageFunc_parentFolderId, METH_NOARGS},
    {"preferredCharsetFor", (PyCFunction)SbkQtMobility_QMessageFunc_preferredCharsetFor, METH_O|METH_STATIC},
    {"preferredCharsets", (PyCFunction)SbkQtMobility_QMessageFunc_preferredCharsets, METH_NOARGS|METH_STATIC},
    {"priority", (PyCFunction)SbkQtMobility_QMessageFunc_priority, METH_NOARGS},
    {"receivedDate", (PyCFunction)SbkQtMobility_QMessageFunc_receivedDate, METH_NOARGS},
    {"setBcc", (PyCFunction)SbkQtMobility_QMessageFunc_setBcc, METH_O},
    {"setBody", (PyCFunction)SbkQtMobility_QMessageFunc_setBody, METH_VARARGS|METH_KEYWORDS},
    {"setCc", (PyCFunction)SbkQtMobility_QMessageFunc_setCc, METH_O},
    {"setDate", (PyCFunction)SbkQtMobility_QMessageFunc_setDate, METH_O},
    {"setFrom", (PyCFunction)SbkQtMobility_QMessageFunc_setFrom, METH_O},
    {"setParentAccountId", (PyCFunction)SbkQtMobility_QMessageFunc_setParentAccountId, METH_O},
    {"setPreferredCharsets", (PyCFunction)SbkQtMobility_QMessageFunc_setPreferredCharsets, METH_O|METH_STATIC},
    {"setPriority", (PyCFunction)SbkQtMobility_QMessageFunc_setPriority, METH_O},
    {"setReceivedDate", (PyCFunction)SbkQtMobility_QMessageFunc_setReceivedDate, METH_O},
    {"setStatus", (PyCFunction)SbkQtMobility_QMessageFunc_setStatus, METH_VARARGS|METH_KEYWORDS},
    {"setSubject", (PyCFunction)SbkQtMobility_QMessageFunc_setSubject, METH_O},
    {"setTo", (PyCFunction)SbkQtMobility_QMessageFunc_setTo, METH_O},
    {"setType", (PyCFunction)SbkQtMobility_QMessageFunc_setType, METH_O},
    {"size", (PyCFunction)SbkQtMobility_QMessageFunc_size, METH_NOARGS},
    {"standardFolder", (PyCFunction)SbkQtMobility_QMessageFunc_standardFolder, METH_NOARGS},
    {"status", (PyCFunction)SbkQtMobility_QMessageFunc_status, METH_NOARGS},
    {"subject", (PyCFunction)SbkQtMobility_QMessageFunc_subject, METH_NOARGS},
    {"to", (PyCFunction)SbkQtMobility_QMessageFunc_to, METH_NOARGS},
    {"type", (PyCFunction)SbkQtMobility_QMessageFunc_type, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

static void* SbkQtMobility_QMessage_ObjCopierFunc(const void* ptr){
    return new QMessageWrapper(*reinterpret_cast<const QtMobility::QMessage*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessage_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessage",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessage_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessage_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessage_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessage >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessage",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QMessage_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QtMobility::QMessageContentContainer >()) && dynamic_cast<QtMobility::QMessage*>(reinterpret_cast<QtMobility::QMessageContentContainer*>(cptr)))
        return &SbkQtMobility_QMessage_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StandardFolder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ResponseType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessage_Priority_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Priority_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Priority",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessage_Priority_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessage_Priority_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Priority_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Type___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessage::TypeFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessage::TypeFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessage::TypeFlags>::toCpp(self)
        & Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Type___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessage::TypeFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessage::TypeFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessage::TypeFlags>::toCpp(self)
        | Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Type___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessage::TypeFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessage::TypeFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessage::TypeFlags>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Type___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QMessage::TypeFlags >::toPython(
        ~Shiboken::Converter<QtMobility::QMessage::TypeFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Messaging_QtMobility_QMessage_Type_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Type___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Type___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Type___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Type___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessage_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Messaging_QtMobility_QMessage_Type_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessage_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessage_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_TypeFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TypeFlags",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};


PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Status___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessage::StatusFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessage::StatusFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessage::StatusFlags>::toCpp(self)
        & Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Status___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessage::StatusFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessage::StatusFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessage::StatusFlags>::toCpp(self)
        | Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Status___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QMessage::StatusFlags >::checkType(self) && Shiboken::Converter<QtMobility::QMessage::StatusFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toPython(
        Shiboken::Converter<QtMobility::QMessage::StatusFlags>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Status___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QMessage::StatusFlags >::toPython(
        ~Shiboken::Converter<QtMobility::QMessage::StatusFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Messaging_QtMobility_QMessage_Status_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Status___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Status___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Status___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Messaging_QtMobility_QMessage_Status___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessage_Status_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Status_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Status",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Messaging_QtMobility_QMessage_Status_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessage_Status_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessage_Status_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessage_Status_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessage_StatusFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StatusFlags",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QMessage(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessage_Type);

    SbkQtMobility_QMessage_Type.super.ht_type.tp_base = SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGECONTENTCONTAINER_IDX];
    // Fill type discovery information
    SbkQtMobility_QMessage_Type.type_discovery = &SbkQtMobility_QMessage_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGECONTENTCONTAINER_IDX]), &SbkQtMobility_QMessage_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessage_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessage_Type));
    PyModule_AddObject(module, "QMessage",
        ((PyObject*)&SbkQtMobility_QMessage_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StandardFolder
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_STANDARDFOLDER_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "StandardFolder",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type,
        (long) QtMobility::QMessage::InboxFolder, "InboxFolder");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "InboxFolder", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type.tp_dict,
        "InboxFolder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type,
        (long) QtMobility::QMessage::OutboxFolder, "OutboxFolder");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "OutboxFolder", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type.tp_dict,
        "OutboxFolder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type,
        (long) QtMobility::QMessage::DraftsFolder, "DraftsFolder");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "DraftsFolder", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type.tp_dict,
        "DraftsFolder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type,
        (long) QtMobility::QMessage::SentFolder, "SentFolder");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "SentFolder", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type.tp_dict,
        "SentFolder", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type,
        (long) QtMobility::QMessage::TrashFolder, "TrashFolder");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "TrashFolder", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_StandardFolder_Type.tp_dict,
        "TrashFolder", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessage::StandardFolder");

    // init enum class: ResponseType
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_RESPONSETYPE_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "ResponseType",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type,
        (long) QtMobility::QMessage::ReplyToSender, "ReplyToSender");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "ReplyToSender", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type.tp_dict,
        "ReplyToSender", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type,
        (long) QtMobility::QMessage::ReplyToAll, "ReplyToAll");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "ReplyToAll", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type.tp_dict,
        "ReplyToAll", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type,
        (long) QtMobility::QMessage::Forward, "Forward");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Forward", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_ResponseType_Type.tp_dict,
        "Forward", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessage::ResponseType");

    // init enum class: Priority
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_PRIORITY_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "Priority",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type,
        (long) QtMobility::QMessage::HighPriority, "HighPriority");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "HighPriority", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type.tp_dict,
        "HighPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type,
        (long) QtMobility::QMessage::NormalPriority, "NormalPriority");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "NormalPriority", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type.tp_dict,
        "NormalPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type,
        (long) QtMobility::QMessage::LowPriority, "LowPriority");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "LowPriority", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Priority_Type.tp_dict,
        "LowPriority", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessage::Priority");

    // init enum class: Type
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_TYPE_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type));

    // init flags class: QFlags<QtMobility::QMessage::Type>
    SbkQtMobility_MessagingTypes[SBK_QFLAGS_QTMOBILITY_QMESSAGE_TYPE__IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_TypeFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_TypeFlags_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_TypeFlags_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "TypeFlags",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_TypeFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type,
        (long) QtMobility::QMessage::NoType, "NoType");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "NoType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_dict,
        "NoType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type,
        (long) QtMobility::QMessage::Mms, "Mms");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Mms", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_dict,
        "Mms", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type,
        (long) QtMobility::QMessage::Sms, "Sms");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Sms", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_dict,
        "Sms", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type,
        (long) QtMobility::QMessage::Email, "Email");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Email", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_dict,
        "Email", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type,
        (long) QtMobility::QMessage::InstantMessage, "InstantMessage");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "InstantMessage", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_dict,
        "InstantMessage", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type,
        (long) QtMobility::QMessage::AnyType, "AnyType");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "AnyType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Type_Type.tp_dict,
        "AnyType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessage::Type");

    // init enum class: Status
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_STATUS_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "Status",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type));

    // init flags class: QFlags<QtMobility::QMessage::Status>
    SbkQtMobility_MessagingTypes[SBK_QFLAGS_QTMOBILITY_QMESSAGE_STATUS__IDX] = &SbkQtMobility_Messaging_QtMobility_QMessage_StatusFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_StatusFlags_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessage_StatusFlags_Type);
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
            "StatusFlags",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessage_StatusFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type,
        (long) QtMobility::QMessage::Read, "Read");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Read", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type.tp_dict,
        "Read", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type,
        (long) QtMobility::QMessage::HasAttachments, "HasAttachments");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "HasAttachments", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type.tp_dict,
        "HasAttachments", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type,
        (long) QtMobility::QMessage::Incoming, "Incoming");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Incoming", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type.tp_dict,
        "Incoming", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type,
        (long) QtMobility::QMessage::Removed, "Removed");
    PyDict_SetItemString(SbkQtMobility_QMessage_Type.super.ht_type.tp_dict,
        "Removed", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessage_Status_Type.tp_dict,
        "Removed", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessage::Status");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessage >("QtMobility::QMessage");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessage >("QtMobility::QMessage*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessage >(typeid(QtMobility::QMessage).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessage >(typeid(QMessageWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessage >();
}

