/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_location_python.h"

#include "qtmobility_qgeosatelliteinfo_wrapper.h"

// Extra includes
#include <qgeosatelliteinfo.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QGeoSatelliteInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QGeoSatelliteInfo >()))
        return -1;

    QtMobility::QGeoSatelliteInfo* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoSatelliteInfo", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo()
    // 1: QGeoSatelliteInfo(QtMobility::QGeoSatelliteInfo)
    if (numArgs == 0) {
        overloadId = 0; // QGeoSatelliteInfo()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QGeoSatelliteInfo & >::isConvertible(arg)) {
        overloadId = 1; // QGeoSatelliteInfo(QtMobility::QGeoSatelliteInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfo_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QGeoSatelliteInfo()
            {

                if(!PyErr_Occurred()) {
                // QGeoSatelliteInfo()
                cptr = new QtMobility::QGeoSatelliteInfo();
                }
                break;
            }
            case 1: // QGeoSatelliteInfo(QtMobility::QGeoSatelliteInfo)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QGeoSatelliteInfo* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QGeoSatelliteInfo(QtMobility::QGeoSatelliteInfo)
                cptr = new QtMobility::QGeoSatelliteInfo(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QGeoSatelliteInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QGeoSatelliteInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QGeoSatelliteInfo_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Location.QGeoSatelliteInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoSatelliteInfo", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_attribute(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: attribute(QtMobility::QGeoSatelliteInfo::Attribute)const
    if (Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::isConvertible(arg)) {
        overloadId = 0; // attribute(QtMobility::QGeoSatelliteInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoFunc_attribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoSatelliteInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // attribute(QtMobility::QGeoSatelliteInfo::Attribute)const
            qreal cppResult = cppSelf->QtMobility::QGeoSatelliteInfo::attribute(cpp_arg0);
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoSatelliteInfoFunc_attribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoSatelliteInfo.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfo.attribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_hasAttribute(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: hasAttribute(QtMobility::QGeoSatelliteInfo::Attribute)const
    if (Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::isConvertible(arg)) {
        overloadId = 0; // hasAttribute(QtMobility::QGeoSatelliteInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoFunc_hasAttribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoSatelliteInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // hasAttribute(QtMobility::QGeoSatelliteInfo::Attribute)const
            bool cppResult = cppSelf->QtMobility::QGeoSatelliteInfo::hasAttribute(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoSatelliteInfoFunc_hasAttribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoSatelliteInfo.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfo.hasAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_prnNumber(PyObject* self)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // prnNumber()const
            int cppResult = cppSelf->QtMobility::QGeoSatelliteInfo::prnNumber();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_removeAttribute(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeAttribute(QtMobility::QGeoSatelliteInfo::Attribute)
    if (Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::isConvertible(arg)) {
        overloadId = 0; // removeAttribute(QtMobility::QGeoSatelliteInfo::Attribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoFunc_removeAttribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoSatelliteInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeAttribute(QtMobility::QGeoSatelliteInfo::Attribute)
            cppSelf->QtMobility::QGeoSatelliteInfo::removeAttribute(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoSatelliteInfoFunc_removeAttribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoSatelliteInfo.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfo.removeAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_setAttribute(PyObject* self, PyObject* args)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setAttribute(QtMobility::QGeoSatelliteInfo::Attribute,qreal)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::isConvertible(pyargs[0]) && SbkNumber_Check(pyargs[1])) {
        overloadId = 0; // setAttribute(QtMobility::QGeoSatelliteInfo::Attribute,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoFunc_setAttribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoSatelliteInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoSatelliteInfo::Attribute >::toCpp(pyargs[0]);
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setAttribute(QtMobility::QGeoSatelliteInfo::Attribute,qreal)
            cppSelf->QtMobility::QGeoSatelliteInfo::setAttribute(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoSatelliteInfoFunc_setAttribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoSatelliteInfo.Attribute, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoSatelliteInfo.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_setPrnNumber(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPrnNumber(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setPrnNumber(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoFunc_setPrnNumber_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPrnNumber(int)
            cppSelf->QtMobility::QGeoSatelliteInfo::setPrnNumber(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoSatelliteInfoFunc_setPrnNumber_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfo.setPrnNumber", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_setSignalStrength(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSignalStrength(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setSignalStrength(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoFunc_setSignalStrength_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSignalStrength(int)
            cppSelf->QtMobility::QGeoSatelliteInfo::setSignalStrength(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoSatelliteInfoFunc_setSignalStrength_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfo.setSignalStrength", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoFunc_signalStrength(PyObject* self)
{
    QtMobility::QGeoSatelliteInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // signalStrength()const
            int cppResult = cppSelf->QtMobility::QGeoSatelliteInfo::signalStrength();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QGeoSatelliteInfo_methods[] = {
    {"attribute", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_attribute, METH_O},
    {"hasAttribute", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_hasAttribute, METH_O},
    {"prnNumber", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_prnNumber, METH_NOARGS},
    {"removeAttribute", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_removeAttribute, METH_O},
    {"setAttribute", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_setAttribute, METH_VARARGS},
    {"setPrnNumber", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_setPrnNumber, METH_O},
    {"setSignalStrength", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_setSignalStrength, METH_O},
    {"signalStrength", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoFunc_signalStrength, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QGeoSatelliteInfo_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QGeoSatelliteInfo& cpp_self = *Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QGeoSatelliteInfo & >::isConvertible(other)) {
                // operator!=(const QtMobility::QGeoSatelliteInfo & other) const
                QtMobility::QGeoSatelliteInfo* cpp_other = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QGeoSatelliteInfo  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QGeoSatelliteInfo_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QGeoSatelliteInfo & >::isConvertible(other)) {
                // operator==(const QtMobility::QGeoSatelliteInfo & other) const
                QtMobility::QGeoSatelliteInfo* cpp_other = Shiboken::Converter<QtMobility::QGeoSatelliteInfo* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QGeoSatelliteInfo  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QGeoSatelliteInfo_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QGeoSatelliteInfo_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QGeoSatelliteInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QGeoSatelliteInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QGeoSatelliteInfo_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QGeoSatelliteInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QGeoSatelliteInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QGeoSatelliteInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QGeoSatelliteInfo",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Attribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QGeoSatelliteInfo(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QGeoSatelliteInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QGeoSatelliteInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QGeoSatelliteInfo_Type));
    PyModule_AddObject(module, "QGeoSatelliteInfo",
        ((PyObject*)&SbkQtMobility_QGeoSatelliteInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Attribute
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFO_ATTRIBUTE_IDX] = &SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type);
    PyDict_SetItemString(SbkQtMobility_QGeoSatelliteInfo_Type.super.ht_type.tp_dict,
            "Attribute",((PyObject*)&SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type,
        (long) QtMobility::QGeoSatelliteInfo::Elevation, "Elevation");
    PyDict_SetItemString(SbkQtMobility_QGeoSatelliteInfo_Type.super.ht_type.tp_dict,
        "Elevation", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type.tp_dict,
        "Elevation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type,
        (long) QtMobility::QGeoSatelliteInfo::Azimuth, "Azimuth");
    PyDict_SetItemString(SbkQtMobility_QGeoSatelliteInfo_Type.super.ht_type.tp_dict,
        "Azimuth", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoSatelliteInfo_Attribute_Type.tp_dict,
        "Azimuth", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QGeoSatelliteInfo::Attribute");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QGeoSatelliteInfo >("QtMobility::QGeoSatelliteInfo");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoSatelliteInfo >("QtMobility::QGeoSatelliteInfo*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QGeoSatelliteInfo >(typeid(QtMobility::QGeoSatelliteInfo).name());
    PySide::initQtMetaType<QtMobility::QGeoSatelliteInfo >();
}

