/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_location_python.h"

#include "qtmobility_qgeocoordinate_wrapper.h"

// Extra includes
#include <qgeocoordinate.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QGeoCoordinate_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QGeoCoordinate >()))
        return -1;

    QtMobility::QGeoCoordinate* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoCoordinate", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    // Overloaded function decisor
    // 0: QGeoCoordinate()
    // 1: QGeoCoordinate(QtMobility::QGeoCoordinate)
    // 2: QGeoCoordinate(double,double)
    // 3: QGeoCoordinate(double,double,double)
    if (numArgs == 0) {
        overloadId = 0; // QGeoCoordinate()
    } else if (numArgs >= 2 && SbkNumber_Check(pyargs[0]) && SbkNumber_Check(pyargs[1])) {
        if (numArgs == 2) {
            overloadId = 2; // QGeoCoordinate(double,double)
        } else if (numArgs == 3 && SbkNumber_Check(pyargs[2])) {
            overloadId = 3; // QGeoCoordinate(double,double,double)
        }
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(pyargs[0])) {
        overloadId = 1; // QGeoCoordinate(QtMobility::QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinate_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QGeoCoordinate()
            {

                if(!PyErr_Occurred()) {
                // QGeoCoordinate()
                cptr = new QtMobility::QGeoCoordinate();
                }
                break;
            }
            case 1: // QGeoCoordinate(QtMobility::QGeoCoordinate)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QGeoCoordinate* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QGeoCoordinate(QtMobility::QGeoCoordinate)
                cptr = new QtMobility::QGeoCoordinate(*cpp_arg0);
                }
                break;
            }
            case 2: // QGeoCoordinate(double,double)
            {
                double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
                double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // QGeoCoordinate(double,double)
                cptr = new QtMobility::QGeoCoordinate(cpp_arg0, cpp_arg1);
                }
                break;
            }
            case 3: // QGeoCoordinate(double,double,double)
            {
                double cpp_arg0 = Shiboken::Converter<double >::toCpp(pyargs[0]);
                double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
                double cpp_arg2 = Shiboken::Converter<double >::toCpp(pyargs[2]);

                if(!PyErr_Occurred()) {
                // QGeoCoordinate(double,double,double)
                cptr = new QtMobility::QGeoCoordinate(cpp_arg0, cpp_arg1, cpp_arg2);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QGeoCoordinate >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QGeoCoordinate_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QGeoCoordinate_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Location.QGeoCoordinate", "float, float", "float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoCoordinate", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_altitude(PyObject* self)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // altitude()const
            double cppResult = cppSelf->QtMobility::QGeoCoordinate::altitude();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_azimuthTo(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: azimuthTo(QtMobility::QGeoCoordinate)const
    if (Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(arg)) {
        overloadId = 0; // azimuthTo(QtMobility::QGeoCoordinate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinateFunc_azimuthTo_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QGeoCoordinate* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // azimuthTo(QtMobility::QGeoCoordinate)const
            qreal cppResult = cppSelf->QtMobility::QGeoCoordinate::azimuthTo(*cpp_arg0);
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoCoordinateFunc_azimuthTo_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoCoordinate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoCoordinate.azimuthTo", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_distanceTo(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: distanceTo(QtMobility::QGeoCoordinate)const
    if (Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(arg)) {
        overloadId = 0; // distanceTo(QtMobility::QGeoCoordinate)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinateFunc_distanceTo_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QGeoCoordinate* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // distanceTo(QtMobility::QGeoCoordinate)const
            qreal cppResult = cppSelf->QtMobility::QGeoCoordinate::distanceTo(*cpp_arg0);
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoCoordinateFunc_distanceTo_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoCoordinate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoCoordinate.distanceTo", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_isValid(PyObject* self)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QGeoCoordinate::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_latitude(PyObject* self)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // latitude()const
            double cppResult = cppSelf->QtMobility::QGeoCoordinate::latitude();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_longitude(PyObject* self)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // longitude()const
            double cppResult = cppSelf->QtMobility::QGeoCoordinate::longitude();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_setAltitude(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAltitude(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setAltitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinateFunc_setAltitude_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAltitude(double)
            cppSelf->QtMobility::QGeoCoordinate::setAltitude(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoCoordinateFunc_setAltitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoCoordinate.setAltitude", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_setLatitude(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLatitude(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setLatitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinateFunc_setLatitude_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLatitude(double)
            cppSelf->QtMobility::QGeoCoordinate::setLatitude(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoCoordinateFunc_setLatitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoCoordinate.setLatitude", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_setLongitude(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLongitude(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setLongitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinateFunc_setLongitude_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLongitude(double)
            cppSelf->QtMobility::QGeoCoordinate::setLongitude(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoCoordinateFunc_setLongitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoCoordinate.setLongitude", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_toString(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "format" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoCoordinate.toString(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QGeoCoordinate.toString(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:toString", &arg))
        return 0;


    // Overloaded function decisor
    // 0: toString(QtMobility::QGeoCoordinate::CoordinateFormat)const
    if (numArgs == 0) {
        overloadId = 0; // toString(QtMobility::QGeoCoordinate::CoordinateFormat)const
    } else if (Shiboken::Converter<QtMobility::QGeoCoordinate::CoordinateFormat >::isConvertible(arg)) {
        overloadId = 0; // toString(QtMobility::QGeoCoordinate::CoordinateFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoCoordinateFunc_toString_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "format");
                if (value) {
                    if (arg)
                        errorArgName = "format";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoCoordinate.toString(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QGeoCoordinate::CoordinateFormat cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QGeoCoordinate::CoordinateFormat >::toCpp(arg) : QtMobility::QGeoCoordinate::DegreesMinutesSecondsWithHemisphere;

            if(!PyErr_Occurred()) {
            // toString(QtMobility::QGeoCoordinate::CoordinateFormat)const
            QString cppResult = cppSelf->QtMobility::QGeoCoordinate::toString(cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoCoordinateFunc_toString_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoCoordinate.CoordinateFormat = DegreesMinutesSecondsWithHemisphere", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoCoordinate.toString", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoCoordinateFunc_type(PyObject* self)
{
    QtMobility::QGeoCoordinate* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QGeoCoordinate::CoordinateType cppResult = cppSelf->QtMobility::QGeoCoordinate::type();
            pyResult = Shiboken::Converter<QtMobility::QGeoCoordinate::CoordinateType >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QGeoCoordinate_methods[] = {
    {"altitude", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_altitude, METH_NOARGS},
    {"azimuthTo", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_azimuthTo, METH_O},
    {"distanceTo", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_distanceTo, METH_O},
    {"isValid", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_isValid, METH_NOARGS},
    {"latitude", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_latitude, METH_NOARGS},
    {"longitude", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_longitude, METH_NOARGS},
    {"setAltitude", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_setAltitude, METH_O},
    {"setLatitude", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_setLatitude, METH_O},
    {"setLongitude", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_setLongitude, METH_O},
    {"toString", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_toString, METH_VARARGS|METH_KEYWORDS},
    {"type", (PyCFunction)SbkQtMobility_QGeoCoordinateFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QGeoCoordinate_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QGeoCoordinate& cpp_self = *Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(other)) {
                // operator!=(const QtMobility::QGeoCoordinate & other) const
                QtMobility::QGeoCoordinate* cpp_other = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QGeoCoordinate  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QGeoCoordinate_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(other)) {
                // operator==(const QtMobility::QGeoCoordinate & other) const
                QtMobility::QGeoCoordinate* cpp_other = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QGeoCoordinate  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QGeoCoordinate_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QGeoCoordinate_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QGeoCoordinate_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QGeoCoordinate",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QGeoCoordinate_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QGeoCoordinate_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QGeoCoordinate_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QGeoCoordinate >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QGeoCoordinate",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CoordinateFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CoordinateType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QGeoCoordinate(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOCOORDINATE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QGeoCoordinate_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QGeoCoordinate_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QGeoCoordinate_Type));
    PyModule_AddObject(module, "QGeoCoordinate",
        ((PyObject*)&SbkQtMobility_QGeoCoordinate_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CoordinateFormat
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOCOORDINATE_COORDINATEFORMAT_IDX] = &SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type);
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
            "CoordinateFormat",((PyObject*)&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type,
        (long) QtMobility::QGeoCoordinate::Degrees, "Degrees");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "Degrees", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type.tp_dict,
        "Degrees", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type,
        (long) QtMobility::QGeoCoordinate::DegreesWithHemisphere, "DegreesWithHemisphere");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "DegreesWithHemisphere", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type.tp_dict,
        "DegreesWithHemisphere", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type,
        (long) QtMobility::QGeoCoordinate::DegreesMinutes, "DegreesMinutes");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "DegreesMinutes", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type.tp_dict,
        "DegreesMinutes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type,
        (long) QtMobility::QGeoCoordinate::DegreesMinutesWithHemisphere, "DegreesMinutesWithHemisphere");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "DegreesMinutesWithHemisphere", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type.tp_dict,
        "DegreesMinutesWithHemisphere", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type,
        (long) QtMobility::QGeoCoordinate::DegreesMinutesSeconds, "DegreesMinutesSeconds");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "DegreesMinutesSeconds", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type.tp_dict,
        "DegreesMinutesSeconds", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type,
        (long) QtMobility::QGeoCoordinate::DegreesMinutesSecondsWithHemisphere, "DegreesMinutesSecondsWithHemisphere");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "DegreesMinutesSecondsWithHemisphere", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateFormat_Type.tp_dict,
        "DegreesMinutesSecondsWithHemisphere", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QGeoCoordinate::CoordinateFormat");

    // init enum class: CoordinateType
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOCOORDINATE_COORDINATETYPE_IDX] = &SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type);
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
            "CoordinateType",((PyObject*)&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type,
        (long) QtMobility::QGeoCoordinate::InvalidCoordinate, "InvalidCoordinate");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "InvalidCoordinate", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type.tp_dict,
        "InvalidCoordinate", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type,
        (long) QtMobility::QGeoCoordinate::Coordinate2D, "Coordinate2D");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "Coordinate2D", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type.tp_dict,
        "Coordinate2D", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type,
        (long) QtMobility::QGeoCoordinate::Coordinate3D, "Coordinate3D");
    PyDict_SetItemString(SbkQtMobility_QGeoCoordinate_Type.super.ht_type.tp_dict,
        "Coordinate3D", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoCoordinate_CoordinateType_Type.tp_dict,
        "Coordinate3D", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QGeoCoordinate::CoordinateType");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QGeoCoordinate >("QtMobility::QGeoCoordinate");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoCoordinate >("QtMobility::QGeoCoordinate*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QGeoCoordinate >(typeid(QtMobility::QGeoCoordinate).name());
    PySide::initQtMetaType<QtMobility::QGeoCoordinate >();
}

