/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactringtone_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactringtone.h>
#include <qurl.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactRingtone_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactRingtone >()))
        return -1;

    QtMobility::QContactRingtone* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactRingtone", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactRingtone(QtMobility::QContactRingtone)
    // 1: QContactRingtone()
    // 2: QContactRingtone(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactRingtone()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactRingtone(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactRingtone & >::isConvertible(arg)) {
        overloadId = 0; // QContactRingtone(QtMobility::QContactRingtone)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRingtone_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactRingtone(QtMobility::QContactRingtone)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactRingtone > cpp_arg0_auto_ptr;
                QtMobility::QContactRingtone* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactRingtone >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactRingtone >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactRingtone(QtMobility::QContactRingtone)
                cptr = new QtMobility::QContactRingtone(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactRingtone()
            {

                if(!PyErr_Occurred()) {
                // QContactRingtone()
                cptr = new QtMobility::QContactRingtone();
                }
                break;
            }
            case 2: // QContactRingtone(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactRingtone(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactRingtone(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactRingtone >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactRingtone_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactRingtone_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRingtone", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactRingtone", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactRingtoneFunc_audioRingtoneUrl(PyObject* self)
{
    QtMobility::QContactRingtone* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // audioRingtoneUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactRingtone::audioRingtoneUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRingtoneFunc_setAudioRingtoneUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRingtone* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAudioRingtoneUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setAudioRingtoneUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRingtoneFunc_setAudioRingtoneUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setAudioRingtoneUrl(QUrl)
            cppSelf->QtMobility::QContactRingtone::setAudioRingtoneUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRingtoneFunc_setAudioRingtoneUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRingtone.setAudioRingtoneUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRingtoneFunc_setVibrationRingtoneUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRingtone* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setVibrationRingtoneUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setVibrationRingtoneUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRingtoneFunc_setVibrationRingtoneUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setVibrationRingtoneUrl(QUrl)
            cppSelf->QtMobility::QContactRingtone::setVibrationRingtoneUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRingtoneFunc_setVibrationRingtoneUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRingtone.setVibrationRingtoneUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRingtoneFunc_setVideoRingtoneUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRingtone* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setVideoRingtoneUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setVideoRingtoneUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRingtoneFunc_setVideoRingtoneUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setVideoRingtoneUrl(QUrl)
            cppSelf->QtMobility::QContactRingtone::setVideoRingtoneUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRingtoneFunc_setVideoRingtoneUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRingtone.setVideoRingtoneUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRingtoneFunc_vibrationRingtoneUrl(PyObject* self)
{
    QtMobility::QContactRingtone* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // vibrationRingtoneUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactRingtone::vibrationRingtoneUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRingtoneFunc_videoRingtoneUrl(PyObject* self)
{
    QtMobility::QContactRingtone* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRingtone* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // videoRingtoneUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactRingtone::videoRingtoneUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactRingtone_methods[] = {
    {"audioRingtoneUrl", (PyCFunction)SbkQtMobility_QContactRingtoneFunc_audioRingtoneUrl, METH_NOARGS},
    {"setAudioRingtoneUrl", (PyCFunction)SbkQtMobility_QContactRingtoneFunc_setAudioRingtoneUrl, METH_O},
    {"setVibrationRingtoneUrl", (PyCFunction)SbkQtMobility_QContactRingtoneFunc_setVibrationRingtoneUrl, METH_O},
    {"setVideoRingtoneUrl", (PyCFunction)SbkQtMobility_QContactRingtoneFunc_setVideoRingtoneUrl, METH_O},
    {"vibrationRingtoneUrl", (PyCFunction)SbkQtMobility_QContactRingtoneFunc_vibrationRingtoneUrl, METH_NOARGS},
    {"videoRingtoneUrl", (PyCFunction)SbkQtMobility_QContactRingtoneFunc_videoRingtoneUrl, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactRingtone_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactRingtone",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactRingtone_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactRingtone_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactRingtone >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactRingtone",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactRingtone(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRINGTONE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactRingtone_Type);

    SbkQtMobility_QContactRingtone_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactRingtone_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactRingtone_Type));
    PyModule_AddObject(module, "QContactRingtone",
        ((PyObject*)&SbkQtMobility_QContactRingtone_Type));

    PyDict_SetItemString(SbkQtMobility_QContactRingtone_Type.super.ht_type.tp_dict, "FieldVibrationRingtoneUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactRingtone::FieldVibrationRingtoneUrl));
    PyDict_SetItemString(SbkQtMobility_QContactRingtone_Type.super.ht_type.tp_dict, "FieldAudioRingtoneUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactRingtone::FieldAudioRingtoneUrl));
    PyDict_SetItemString(SbkQtMobility_QContactRingtone_Type.super.ht_type.tp_dict, "FieldVideoRingtoneUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactRingtone::FieldVideoRingtoneUrl));
    PyDict_SetItemString(SbkQtMobility_QContactRingtone_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactRingtone::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactRingtone >("QtMobility::QContactRingtone");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactRingtone >("QtMobility::QContactRingtone*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactRingtone >(typeid(QtMobility::QContactRingtone).name());
    PySide::initQtMetaType<QtMobility::QContactRingtone >();
}

