/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactrelationship_wrapper.h"

// Extra includes
#include <qcontactid.h>
#include <qcontactrelationship.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactRelationship_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactRelationship >()))
        return -1;

    QtMobility::QContactRelationship* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactRelationship", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactRelationship()
    // 1: QContactRelationship(QtMobility::QContactRelationship)
    if (numArgs == 0) {
        overloadId = 0; // QContactRelationship()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactRelationship & >::isConvertible(arg)) {
        overloadId = 1; // QContactRelationship(QtMobility::QContactRelationship)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationship_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactRelationship()
            {

                if(!PyErr_Occurred()) {
                // QContactRelationship()
                cptr = new QtMobility::QContactRelationship();
                }
                break;
            }
            case 1: // QContactRelationship(QtMobility::QContactRelationship)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactRelationship* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactRelationship(QtMobility::QContactRelationship)
                cptr = new QtMobility::QContactRelationship(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactRelationship >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactRelationship_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactRelationship_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactRelationship", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactRelationship", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactRelationshipFunc_first(PyObject* self)
{
    QtMobility::QContactRelationship* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // first()const
            QtMobility::QContactId cppResult = cppSelf->QtMobility::QContactRelationship::first();
            pyResult = Shiboken::Converter<QtMobility::QContactId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRelationshipFunc_relationshipType(PyObject* self)
{
    QtMobility::QContactRelationship* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // relationshipType()const
            QString cppResult = cppSelf->QtMobility::QContactRelationship::relationshipType();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRelationshipFunc_second(PyObject* self)
{
    QtMobility::QContactRelationship* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // second()const
            QtMobility::QContactId cppResult = cppSelf->QtMobility::QContactRelationship::second();
            pyResult = Shiboken::Converter<QtMobility::QContactId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRelationshipFunc_setFirst(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRelationship* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setFirst(QtMobility::QContactId)
    if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(arg)) {
        overloadId = 0; // setFirst(QtMobility::QContactId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFunc_setFirst_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactId* cpp_arg0 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setFirst(QtMobility::QContactId)
            cppSelf->QtMobility::QContactRelationship::setFirst(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRelationshipFunc_setFirst_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRelationship.setFirst", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRelationshipFunc_setRelationshipType(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRelationship* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRelationshipType(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setRelationshipType(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFunc_setRelationshipType_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRelationshipType(QString)
            cppSelf->QtMobility::QContactRelationship::setRelationshipType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRelationshipFunc_setRelationshipType_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRelationship.setRelationshipType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRelationshipFunc_setSecond(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRelationship* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSecond(QtMobility::QContactId)
    if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(arg)) {
        overloadId = 0; // setSecond(QtMobility::QContactId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFunc_setSecond_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactId* cpp_arg0 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSecond(QtMobility::QContactId)
            cppSelf->QtMobility::QContactRelationship::setSecond(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRelationshipFunc_setSecond_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRelationship.setSecond", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactRelationship_methods[] = {
    {"first", (PyCFunction)SbkQtMobility_QContactRelationshipFunc_first, METH_NOARGS},
    {"relationshipType", (PyCFunction)SbkQtMobility_QContactRelationshipFunc_relationshipType, METH_NOARGS},
    {"second", (PyCFunction)SbkQtMobility_QContactRelationshipFunc_second, METH_NOARGS},
    {"setFirst", (PyCFunction)SbkQtMobility_QContactRelationshipFunc_setFirst, METH_O},
    {"setRelationshipType", (PyCFunction)SbkQtMobility_QContactRelationshipFunc_setRelationshipType, METH_O},
    {"setSecond", (PyCFunction)SbkQtMobility_QContactRelationshipFunc_setSecond, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContactRelationship_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContactRelationship& cpp_self = *Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContactRelationship & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContactRelationship & other) const
                QtMobility::QContactRelationship* cpp_other = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactRelationship  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContactRelationship_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContactRelationship & >::isConvertible(other)) {
                // operator==(const QtMobility::QContactRelationship & other) const
                QtMobility::QContactRelationship* cpp_other = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactRelationship  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContactRelationship_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContactRelationship_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QContactRelationship_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QContactRelationship >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactRelationship_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactRelationship",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QContactRelationship_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContactRelationship_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactRelationship_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactRelationship_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactRelationship >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactRelationship",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Role",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactRelationship(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactRelationship_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactRelationship_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactRelationship_Type));
    PyModule_AddObject(module, "QContactRelationship",
        ((PyObject*)&SbkQtMobility_QContactRelationship_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Role
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIP_ROLE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type);
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict,
            "Role",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type,
        (long) QtMobility::QContactRelationship::First, "First");
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict,
        "First", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type.tp_dict,
        "First", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type,
        (long) QtMobility::QContactRelationship::Second, "Second");
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict,
        "Second", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type.tp_dict,
        "Second", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type,
        (long) QtMobility::QContactRelationship::Either, "Either");
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict,
        "Either", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactRelationship_Role_Type.tp_dict,
        "Either", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactRelationship::Role");

    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict, "HasManager", Shiboken::Converter<QString >::toPython(QtMobility::QContactRelationship::HasManager));
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict, "HasMember", Shiboken::Converter<QString >::toPython(QtMobility::QContactRelationship::HasMember));
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict, "IsSameAs", Shiboken::Converter<QString >::toPython(QtMobility::QContactRelationship::IsSameAs));
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict, "HasSpouse", Shiboken::Converter<QString >::toPython(QtMobility::QContactRelationship::HasSpouse));
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict, "HasAssistant", Shiboken::Converter<QString >::toPython(QtMobility::QContactRelationship::HasAssistant));
    PyDict_SetItemString(SbkQtMobility_QContactRelationship_Type.super.ht_type.tp_dict, "Aggregates", Shiboken::Converter<QString >::toPython(QtMobility::QContactRelationship::Aggregates));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactRelationship >("QtMobility::QContactRelationship");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactRelationship >("QtMobility::QContactRelationship*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactRelationship >(typeid(QtMobility::QContactRelationship).name());
    PySide::initQtMetaType<QtMobility::QContactRelationship >();
}

