/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactpresence_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactpresence.h>
#include <qdatetime.h>
#include <qurl.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactPresence_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactPresence >()))
        return -1;

    QtMobility::QContactPresence* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactPresence", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactPresence(QtMobility::QContactPresence)
    // 1: QContactPresence()
    // 2: QContactPresence(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactPresence()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactPresence(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactPresence & >::isConvertible(arg)) {
        overloadId = 0; // QContactPresence(QtMobility::QContactPresence)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresence_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactPresence(QtMobility::QContactPresence)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactPresence > cpp_arg0_auto_ptr;
                QtMobility::QContactPresence* cpp_arg0 = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactPresence >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactPresence >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactPresence(QtMobility::QContactPresence)
                cptr = new QtMobility::QContactPresence(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactPresence()
            {

                if(!PyErr_Occurred()) {
                // QContactPresence()
                cptr = new QtMobility::QContactPresence();
                }
                break;
            }
            case 2: // QContactPresence(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactPresence(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactPresence(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactPresence >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactPresence_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactPresence_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactPresence", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactPresence", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_customMessage(PyObject* self)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // customMessage()const
            QString cppResult = cppSelf->QtMobility::QContactPresence::customMessage();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_nickname(PyObject* self)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // nickname()const
            QString cppResult = cppSelf->QtMobility::QContactPresence::nickname();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_presenceState(PyObject* self)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // presenceState()const
            QtMobility::QContactPresence::PresenceState cppResult = cppSelf->QtMobility::QContactPresence::presenceState();
            pyResult = Shiboken::Converter<QtMobility::QContactPresence::PresenceState >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_presenceStateImageUrl(PyObject* self)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // presenceStateImageUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactPresence::presenceStateImageUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_presenceStateText(PyObject* self)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // presenceStateText()const
            QString cppResult = cppSelf->QtMobility::QContactPresence::presenceStateText();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_setCustomMessage(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCustomMessage(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setCustomMessage(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresenceFunc_setCustomMessage_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCustomMessage(QString)
            cppSelf->QtMobility::QContactPresence::setCustomMessage(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPresenceFunc_setCustomMessage_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPresence.setCustomMessage", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_setNickname(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setNickname(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setNickname(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresenceFunc_setNickname_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setNickname(QString)
            cppSelf->QtMobility::QContactPresence::setNickname(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPresenceFunc_setNickname_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPresence.setNickname", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_setPresenceState(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPresenceState(QtMobility::QContactPresence::PresenceState)
    if (Shiboken::Converter<QtMobility::QContactPresence::PresenceState >::isConvertible(arg)) {
        overloadId = 0; // setPresenceState(QtMobility::QContactPresence::PresenceState)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresenceFunc_setPresenceState_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactPresence::PresenceState cpp_arg0 = Shiboken::Converter<QtMobility::QContactPresence::PresenceState >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPresenceState(QtMobility::QContactPresence::PresenceState)
            cppSelf->QtMobility::QContactPresence::setPresenceState(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPresenceFunc_setPresenceState_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactPresence.PresenceState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPresence.setPresenceState", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_setPresenceStateImageUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPresenceStateImageUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setPresenceStateImageUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresenceFunc_setPresenceStateImageUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setPresenceStateImageUrl(QUrl)
            cppSelf->QtMobility::QContactPresence::setPresenceStateImageUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPresenceFunc_setPresenceStateImageUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPresence.setPresenceStateImageUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_setPresenceStateText(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPresenceStateText(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setPresenceStateText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresenceFunc_setPresenceStateText_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPresenceStateText(QString)
            cppSelf->QtMobility::QContactPresence::setPresenceStateText(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPresenceFunc_setPresenceStateText_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPresence.setPresenceStateText", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_setTimestamp(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setTimestamp(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setTimestamp(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPresenceFunc_setTimestamp_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setTimestamp(QDateTime)
            cppSelf->QtMobility::QContactPresence::setTimestamp(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPresenceFunc_setTimestamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPresence.setTimestamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPresenceFunc_timestamp(PyObject* self)
{
    QtMobility::QContactPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // timestamp()const
            QDateTime cppResult = cppSelf->QtMobility::QContactPresence::timestamp();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactPresence_methods[] = {
    {"customMessage", (PyCFunction)SbkQtMobility_QContactPresenceFunc_customMessage, METH_NOARGS},
    {"nickname", (PyCFunction)SbkQtMobility_QContactPresenceFunc_nickname, METH_NOARGS},
    {"presenceState", (PyCFunction)SbkQtMobility_QContactPresenceFunc_presenceState, METH_NOARGS},
    {"presenceStateImageUrl", (PyCFunction)SbkQtMobility_QContactPresenceFunc_presenceStateImageUrl, METH_NOARGS},
    {"presenceStateText", (PyCFunction)SbkQtMobility_QContactPresenceFunc_presenceStateText, METH_NOARGS},
    {"setCustomMessage", (PyCFunction)SbkQtMobility_QContactPresenceFunc_setCustomMessage, METH_O},
    {"setNickname", (PyCFunction)SbkQtMobility_QContactPresenceFunc_setNickname, METH_O},
    {"setPresenceState", (PyCFunction)SbkQtMobility_QContactPresenceFunc_setPresenceState, METH_O},
    {"setPresenceStateImageUrl", (PyCFunction)SbkQtMobility_QContactPresenceFunc_setPresenceStateImageUrl, METH_O},
    {"setPresenceStateText", (PyCFunction)SbkQtMobility_QContactPresenceFunc_setPresenceStateText, METH_O},
    {"setTimestamp", (PyCFunction)SbkQtMobility_QContactPresenceFunc_setTimestamp, METH_O},
    {"timestamp", (PyCFunction)SbkQtMobility_QContactPresenceFunc_timestamp, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactPresence_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactPresence",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactPresence_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactPresence_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactPresence >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactPresence",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PresenceState",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactPresence(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTPRESENCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactPresence_Type);

    SbkQtMobility_QContactPresence_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactPresence_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactPresence_Type));
    PyModule_AddObject(module, "QContactPresence",
        ((PyObject*)&SbkQtMobility_QContactPresence_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PresenceState
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTPRESENCE_PRESENCESTATE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type);
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
            "PresenceState",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceUnknown, "PresenceUnknown");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceUnknown", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceUnknown", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceAvailable, "PresenceAvailable");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceAvailable", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceAvailable", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceHidden, "PresenceHidden");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceHidden", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceHidden", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceBusy, "PresenceBusy");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceBusy", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceBusy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceAway, "PresenceAway");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceAway", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceAway", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceExtendedAway, "PresenceExtendedAway");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceExtendedAway", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceExtendedAway", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type,
        (long) QtMobility::QContactPresence::PresenceOffline, "PresenceOffline");
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict,
        "PresenceOffline", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactPresence_PresenceState_Type.tp_dict,
        "PresenceOffline", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactPresence::PresenceState");

    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "FieldPresenceStateText", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::FieldPresenceStateText));
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "FieldPresenceStateImageUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::FieldPresenceStateImageUrl));
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "FieldPresenceState", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::FieldPresenceState));
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "FieldNickname", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::FieldNickname));
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "FieldTimestamp", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::FieldTimestamp));
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "FieldCustomMessage", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::FieldCustomMessage));
    PyDict_SetItemString(SbkQtMobility_QContactPresence_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactPresence::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactPresence >("QtMobility::QContactPresence");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactPresence >("QtMobility::QContactPresence*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactPresence >(typeid(QtMobility::QContactPresence).name());
    PySide::initQtMetaType<QtMobility::QContactPresence >();
}

