/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactorganization_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactorganization.h>
#include <qurl.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactOrganization_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactOrganization >()))
        return -1;

    QtMobility::QContactOrganization* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactOrganization", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactOrganization(QtMobility::QContactOrganization)
    // 1: QContactOrganization()
    // 2: QContactOrganization(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactOrganization()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactOrganization(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactOrganization & >::isConvertible(arg)) {
        overloadId = 0; // QContactOrganization(QtMobility::QContactOrganization)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganization_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactOrganization(QtMobility::QContactOrganization)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactOrganization > cpp_arg0_auto_ptr;
                QtMobility::QContactOrganization* cpp_arg0 = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactOrganization >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactOrganization >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactOrganization(QtMobility::QContactOrganization)
                cptr = new QtMobility::QContactOrganization(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactOrganization()
            {

                if(!PyErr_Occurred()) {
                // QContactOrganization()
                cptr = new QtMobility::QContactOrganization();
                }
                break;
            }
            case 2: // QContactOrganization(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactOrganization(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactOrganization(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactOrganization >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactOrganization_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactOrganization_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactOrganization", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactOrganization", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_assistantName(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // assistantName()const
            QString cppResult = cppSelf->QtMobility::QContactOrganization::assistantName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_department(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // department()const
            QStringList cppResult = cppSelf->QtMobility::QContactOrganization::department();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_location(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // location()const
            QString cppResult = cppSelf->QtMobility::QContactOrganization::location();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_logoUrl(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // logoUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactOrganization::logoUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_name(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // name()const
            QString cppResult = cppSelf->QtMobility::QContactOrganization::name();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_role(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // role()const
            QString cppResult = cppSelf->QtMobility::QContactOrganization::role();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setAssistantName(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAssistantName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setAssistantName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setAssistantName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAssistantName(QString)
            cppSelf->QtMobility::QContactOrganization::setAssistantName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setAssistantName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setAssistantName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setDepartment(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDepartment(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // setDepartment(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setDepartment_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDepartment(QStringList)
            cppSelf->QtMobility::QContactOrganization::setDepartment(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setDepartment_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setDepartment", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setLocation(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLocation(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setLocation(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setLocation_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLocation(QString)
            cppSelf->QtMobility::QContactOrganization::setLocation(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setLocation_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setLocation", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setLogoUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLogoUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setLogoUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setLogoUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setLogoUrl(QUrl)
            cppSelf->QtMobility::QContactOrganization::setLogoUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setLogoUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setLogoUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setName(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->QtMobility::QContactOrganization::setName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setRole(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRole(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setRole_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRole(QString)
            cppSelf->QtMobility::QContactOrganization::setRole(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setRole_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setRole", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_setTitle(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setTitle(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOrganizationFunc_setTitle_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setTitle(QString)
            cppSelf->QtMobility::QContactOrganization::setTitle(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOrganizationFunc_setTitle_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOrganization.setTitle", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOrganizationFunc_title(PyObject* self)
{
    QtMobility::QContactOrganization* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOrganization* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // title()const
            QString cppResult = cppSelf->QtMobility::QContactOrganization::title();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactOrganization_methods[] = {
    {"assistantName", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_assistantName, METH_NOARGS},
    {"department", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_department, METH_NOARGS},
    {"location", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_location, METH_NOARGS},
    {"logoUrl", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_logoUrl, METH_NOARGS},
    {"name", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_name, METH_NOARGS},
    {"role", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_role, METH_NOARGS},
    {"setAssistantName", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setAssistantName, METH_O},
    {"setDepartment", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setDepartment, METH_O},
    {"setLocation", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setLocation, METH_O},
    {"setLogoUrl", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setLogoUrl, METH_O},
    {"setName", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setName, METH_O},
    {"setRole", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setRole, METH_O},
    {"setTitle", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_setTitle, METH_O},
    {"title", (PyCFunction)SbkQtMobility_QContactOrganizationFunc_title, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactOrganization_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactOrganization",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactOrganization_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactOrganization_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactOrganization >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactOrganization",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactOrganization(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTORGANIZATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactOrganization_Type);

    SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactOrganization_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactOrganization_Type));
    PyModule_AddObject(module, "QContactOrganization",
        ((PyObject*)&SbkQtMobility_QContactOrganization_Type));

    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldAssistantName", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldAssistantName));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldLogoUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldLogoUrl));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldLocation", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldLocation));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldTitle", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldTitle));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldRole", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldRole));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldDepartment", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldDepartment));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "FieldName", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::FieldName));
    PyDict_SetItemString(SbkQtMobility_QContactOrganization_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactOrganization::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactOrganization >("QtMobility::QContactOrganization");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactOrganization >("QtMobility::QContactOrganization*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactOrganization >(typeid(QtMobility::QContactOrganization).name());
    PySide::initQtMetaType<QtMobility::QContactOrganization >();
}

