/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactmanager_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <QStringList>
#include <qbytearray.h>
#include <qcontact.h>
#include <qcontactdetaildefinition.h>
#include <qcontactfetchhint.h>
#include <qcontactfilter.h>
#include <qcontactid.h>
#include <qcontactmanager.h>
#include <qcontactrelationship.h>
#include <qcontactsortorder.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QContactManagerWrapper::QContactManagerWrapper(QObject * parent) : QtMobility::QContactManager(parent), m_metaObject(0) {
    // ... middle
}

QContactManagerWrapper::QContactManagerWrapper(const QString & managerName, const QMap<QString, QString > & parameters, QObject * parent) : QtMobility::QContactManager(managerName, parameters, parent), m_metaObject(0) {
    // ... middle
}

QContactManagerWrapper::QContactManagerWrapper(const QString & managerName, int implementationVersion, const QMap<QString, QString > & parameters, QObject * parent) : QtMobility::QContactManager(managerName, implementationVersion, parameters, parent), m_metaObject(0) {
    // ... middle
}

void QContactManagerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QContactManagerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QContactManagerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QContactManagerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QContactManagerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManager.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QContactManagerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManager.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QContactManagerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QContactManagerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QContactManager::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QContactManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QContactManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QContactManagerWrapper::~QContactManagerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactManager_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactManager >()))
        return -1;

    QContactManagerWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "managerName", "parameters", "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 3, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOO:QContactManager", &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    // Overloaded function decisor
    // 0: QContactManager(QObject*)
    // 1: QContactManager(QString,QMap<QString,QString>,QObject*)
    // 2: QContactManager(QString,int,QMap<QString,QString>,QObject*)
    if (numArgs == 0) {
        overloadId = 1; // QContactManager(QString,QMap<QString,QString>,QObject*)
    } else if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // QContactManager(QString,QMap<QString,QString>,QObject*)
        } else if (SbkNumber_Check(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 2; // QContactManager(QString,int,QMap<QString,QString>,QObject*)
            } else if (Shiboken::Converter< QMap<QString, QString >  >::isConvertible(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 2; // QContactManager(QString,int,QMap<QString,QString>,QObject*)
                } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[3])) {
                    overloadId = 2; // QContactManager(QString,int,QMap<QString,QString>,QObject*)
                }
            }
        } else if (Shiboken::Converter< QMap<QString, QString >  >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // QContactManager(QString,QMap<QString,QString>,QObject*)
            } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
                overloadId = 1; // QContactManager(QString,QMap<QString,QString>,QObject*)
            }
        }
    } else if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        overloadId = 0; // QContactManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManager_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactManager(QObject*)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QContactManager(QObject*)
                cptr = new QContactManagerWrapper(cpp_arg0);
                Shiboken::setParent(pyargs[0], self);
                }
                break;
            }
            case 1: // QContactManager(QString,QMap<QString,QString>,QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "managerName");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "managerName";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "parameters");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "parameters";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "parent";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QString cpp_arg0 = pyargs[0] ? Shiboken::Converter<QString >::toCpp(pyargs[0]) : QString();
                QMap<QString, QString > cpp_arg1 = pyargs[1] ? Shiboken::Converter<QMap<QString, QString > >::toCpp(pyargs[1]) : (QMap< QString,QString >());
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = pyargs[2] ? Shiboken::Converter<QObject* >::toCpp(pyargs[2]) : 0;

                if(!PyErr_Occurred()) {
                // QContactManager(QString,QMap<QString,QString>,QObject*)
                cptr = new QContactManagerWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
                }
                break;
            }
            case 2: // QContactManager(QString,int,QMap<QString,QString>,QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "parameters");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "parameters";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "parent";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
                QMap<QString, QString > cpp_arg2 = pyargs[2] ? Shiboken::Converter<QMap<QString, QString > >::toCpp(pyargs[2]) : (QMap< QString,QString >());
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return -1;
                QObject* cpp_arg3 = pyargs[3] ? Shiboken::Converter<QObject* >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // QContactManager(QString,int,QMap<QString,QString>,QObject*)
                cptr = new QContactManagerWrapper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                Shiboken::setParent(pyargs[3], self);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactManager_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QContactManager_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", "QString = QString(), dict = (QMap< QString,QString >()), PySide.QtCore.QObject = None", "QString, int, dict = (QMap< QString,QString >()), PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactManagerFunc_availableManagers(PyObject* self)
{
    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // availableManagers()
            QStringList cppResult = QtMobility::QContactManager::availableManagers();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_buildUri(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "implementationVersion" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.buildUri(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.buildUri(): too many arguments");
        return 0;
    } else if (numArgs < 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.buildUri(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOO:buildUri", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: buildUri(QString,QMap<QString,QString>,int)
    if (numArgs >= 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter< QMap<QString, QString >  >::isConvertible(pyargs[1])) {
        if (numArgs == 2) {
            overloadId = 0; // buildUri(QString,QMap<QString,QString>,int)
        } else if (SbkNumber_Check(pyargs[2])) {
            overloadId = 0; // buildUri(QString,QMap<QString,QString>,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_buildUri_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "implementationVersion");
                if (value) {
                    if (pyargs[2])
                        errorArgName = "implementationVersion";
                    else
                        pyargs[2] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.buildUri(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QMap<QString, QString > cpp_arg1 = Shiboken::Converter<QMap<QString, QString > >::toCpp(pyargs[1]);
            int cpp_arg2 = pyargs[2] ? Shiboken::Converter<int >::toCpp(pyargs[2]) : -1;

            if(!PyErr_Occurred()) {
            // buildUri(QString,QMap<QString,QString>,int)
            QString cppResult = QtMobility::QContactManager::buildUri(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_buildUri_TypeError:
        const char* overloads[] = {"QString, dict, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.buildUri", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_compatibleContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: compatibleContact(QtMobility::QContact)
    if (Shiboken::Converter<const QtMobility::QContact & >::isConvertible(arg)) {
        overloadId = 0; // compatibleContact(QtMobility::QContact)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_compatibleContact_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // compatibleContact(QtMobility::QContact)
            QtMobility::QContact cppResult = cppSelf->QtMobility::QContactManager::compatibleContact(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QContact >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_compatibleContact_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.compatibleContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_contact(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "fetchHint" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contact(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contact(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contact(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:contact", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint)const
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint)const
        } else if (Shiboken::Converter<const QtMobility::QContactFetchHint & >::isConvertible(pyargs[1])) {
            overloadId = 0; // contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_contact_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "fetchHint");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "fetchHint";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contact(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContactFetchHint cpp_arg1_tmp = QtMobility::QContactFetchHint();
            QtMobility::QContactFetchHint* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;

            if(!PyErr_Occurred()) {
            // contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint)const
            QtMobility::QContact cppResult = cppSelf->QtMobility::QContactManager::contact(cpp_arg0, *cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QContact >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_contact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId, QtMobility.Contacts.QtMobility::QContactFetchHint = QtMobility.QContactFetchHint()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.contact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_contactIds(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "sortOrders" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contactIds(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contactIds(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:contactIds", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: contactIds(QList<QtMobility::QContactSortOrder>)const
    // 1: contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>)const
    if (numArgs == 0) {
        overloadId = 0; // contactIds(QList<QtMobility::QContactSortOrder>)const
    } else if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>)const
        } else if (Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[1])) {
            overloadId = 1; // contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>)const
        }
    } else if (Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[0])) {
        overloadId = 0; // contactIds(QList<QtMobility::QContactSortOrder>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_contactIds_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // contactIds(QList<QtMobility::QContactSortOrder>)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "sortOrders");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "sortOrders";
                        else
                            pyargs[0] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contactIds(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QList<QtMobility::QContactSortOrder > cpp_arg0 = pyargs[0] ? Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[0]) : QList< QtMobility::QContactSortOrder >();

                if(!PyErr_Occurred()) {
                // contactIds(QList<QtMobility::QContactSortOrder>)const
                QList<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactManager::contactIds(cpp_arg0);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toPython(cppResult);
                }
                break;
            }
            case 1: // contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "sortOrders");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "sortOrders";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contactIds(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(pyargs[0]);
                QList<QtMobility::QContactSortOrder > cpp_arg1 = pyargs[1] ? Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[1]) : QList< QtMobility::QContactSortOrder >();

                if(!PyErr_Occurred()) {
                // contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>)const
                QList<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactManager::contactIds(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_contactIds_TypeError:
        const char* overloads[] = {"list = QList< QtMobility.QContactSortOrder >()", "QtMobility.Contacts.QtMobility::QContactFilter, list = QList< QtMobility.QContactSortOrder >()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.contactIds", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_contacts(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "fetchHint", "sortOrders" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 2, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contacts(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contacts(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOO:contacts", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: contacts(QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
    // 1: contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
    if (numArgs == 0) {
        overloadId = 0; // contacts(QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
    } else if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
        } else if (Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
            } else if (Shiboken::Converter<const QtMobility::QContactFetchHint & >::isConvertible(pyargs[2])) {
                overloadId = 1; // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
            }
        }
    } else if (Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // contacts(QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
        } else if (Shiboken::Converter<const QtMobility::QContactFetchHint & >::isConvertible(pyargs[1])) {
            overloadId = 0; // contacts(QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_contacts_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // contacts(QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "sortOrders");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "sortOrders";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "fetchHint");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "fetchHint";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contacts(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QList<QtMobility::QContactSortOrder > cpp_arg0 = pyargs[0] ? Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[0]) : QList< QtMobility::QContactSortOrder >();
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QContactFetchHint cpp_arg1_tmp = QtMobility::QContactFetchHint();
                QtMobility::QContactFetchHint* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;

                if(!PyErr_Occurred()) {
                // contacts(QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
                QList<QtMobility::QContact > cppResult = cppSelf->QtMobility::QContactManager::contacts(cpp_arg0, *cpp_arg1);
                pyResult = Shiboken::Converter<QList<QtMobility::QContact > >::toPython(cppResult);
                }
                break;
            }
            case 1: // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "sortOrders");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "sortOrders";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "fetchHint");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "fetchHint";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.contacts(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(pyargs[0]);
                QList<QtMobility::QContactSortOrder > cpp_arg1 = pyargs[1] ? Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[1]) : QList< QtMobility::QContactSortOrder >();
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                QtMobility::QContactFetchHint cpp_arg2_tmp = QtMobility::QContactFetchHint();
                QtMobility::QContactFetchHint* cpp_arg2 = pyargs[2] ? Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(pyargs[2]) : &cpp_arg2_tmp;

                if(!PyErr_Occurred()) {
                // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint)const
                QList<QtMobility::QContact > cppResult = cppSelf->QtMobility::QContactManager::contacts(*cpp_arg0, cpp_arg1, *cpp_arg2);
                pyResult = Shiboken::Converter<QList<QtMobility::QContact > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_contacts_TypeError:
        const char* overloads[] = {"list = QList< QtMobility.QContactSortOrder >(), QtMobility.Contacts.QtMobility::QContactFetchHint = QtMobility.QContactFetchHint()", "QtMobility.Contacts.QtMobility::QContactFilter, list = QList< QtMobility.QContactSortOrder >(), QtMobility.Contacts.QtMobility::QContactFetchHint = QtMobility.QContactFetchHint()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.contacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_detailDefinition(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "contactType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinition(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinition(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinition(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:detailDefinition", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: detailDefinition(QString,QString)const
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // detailDefinition(QString,QString)const
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // detailDefinition(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_detailDefinition_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "contactType");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "contactType";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinition(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QContactType::TypeContact;

            if(!PyErr_Occurred()) {
            // detailDefinition(QString,QString)const
            QtMobility::QContactDetailDefinition cppResult = cppSelf->QtMobility::QContactManager::detailDefinition(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QContactDetailDefinition >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_detailDefinition_TypeError:
        const char* overloads[] = {"QString, QString = QContactType.TypeContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.detailDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_detailDefinitions(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "contactType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinitions(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinitions(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:detailDefinitions", &arg))
        return 0;


    // Overloaded function decisor
    // 0: detailDefinitions(QString)const
    if (numArgs == 0) {
        overloadId = 0; // detailDefinitions(QString)const
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // detailDefinitions(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_detailDefinitions_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "contactType");
                if (value) {
                    if (arg)
                        errorArgName = "contactType";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.detailDefinitions(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = arg ? Shiboken::Converter<QString >::toCpp(arg) : QContactType::TypeContact;

            if(!PyErr_Occurred()) {
            // detailDefinitions(QString)const
            QMap<QString, QtMobility::QContactDetailDefinition > cppResult = cppSelf->QtMobility::QContactManager::detailDefinitions(cpp_arg0);
            pyResult = Shiboken::Converter<QMap<QString, QtMobility::QContactDetailDefinition > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_detailDefinitions_TypeError:
        const char* overloads[] = {"QString = QContactType.TypeContact", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.detailDefinitions", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_error(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QContactManager::Error cppResult = cppSelf->QtMobility::QContactManager::error();
            pyResult = Shiboken::Converter<QtMobility::QContactManager::Error >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_fromUri(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.fromUri(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.fromUri(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.fromUri(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromUri", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: fromUri(QString,QObject*)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // fromUri(QString,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            overloadId = 0; // fromUri(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_fromUri_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "parent";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.fromUri(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QObject* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QObject* >::toCpp(pyargs[1]) : 0;

            if(!PyErr_Occurred()) {
            // fromUri(QString,QObject*)
            QtMobility::QContactManager * cppResult = QtMobility::QContactManager::fromUri(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QContactManager * >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_fromUri_TypeError:
        const char* overloads[] = {"QString, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.fromUri", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_hasFeature(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "contactType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.hasFeature(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.hasFeature(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.hasFeature(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:hasFeature", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
    if (Shiboken::Converter<QtMobility::QContactManager::ManagerFeature >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_hasFeature_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "contactType");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "contactType";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.hasFeature(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QContactManager::ManagerFeature cpp_arg0 = Shiboken::Converter<QtMobility::QContactManager::ManagerFeature >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QContactType::TypeContact;

            if(!PyErr_Occurred()) {
            // hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
            bool cppResult = cppSelf->QtMobility::QContactManager::hasFeature(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_hasFeature_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactManager.ManagerFeature, QString = QContactType.TypeContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.hasFeature", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_isFilterSupported(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: isFilterSupported(QtMobility::QContactFilter)const
    if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // isFilterSupported(QtMobility::QContactFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_isFilterSupported_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // isFilterSupported(QtMobility::QContactFilter)const
            bool cppResult = cppSelf->QtMobility::QContactManager::isFilterSupported(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_isFilterSupported_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.isFilterSupported", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_isRelationshipTypeSupported(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "contactType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.isRelationshipTypeSupported(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.isRelationshipTypeSupported(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.isRelationshipTypeSupported(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:isRelationshipTypeSupported", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: isRelationshipTypeSupported(QString,QString)const
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // isRelationshipTypeSupported(QString,QString)const
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // isRelationshipTypeSupported(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_isRelationshipTypeSupported_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "contactType");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "contactType";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.isRelationshipTypeSupported(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QContactType::TypeContact;

            if(!PyErr_Occurred()) {
            // isRelationshipTypeSupported(QString,QString)const
            bool cppResult = cppSelf->QtMobility::QContactManager::isRelationshipTypeSupported(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_isRelationshipTypeSupported_TypeError:
        const char* overloads[] = {"QString, QString = QContactType.TypeContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.isRelationshipTypeSupported", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_managerName(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerName()const
            QString cppResult = cppSelf->QtMobility::QContactManager::managerName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_managerParameters(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerParameters()const
            QMap<QString, QString > cppResult = cppSelf->QtMobility::QContactManager::managerParameters();
            pyResult = Shiboken::Converter<QMap<QString, QString > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_managerUri(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerUri()const
            QString cppResult = cppSelf->QtMobility::QContactManager::managerUri();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_managerVersion(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerVersion()const
            int cppResult = cppSelf->QtMobility::QContactManager::managerVersion();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_parseUri(PyObject* self, PyObject* args)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "parseUri", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: parseUri(QString,QString*,QMap<QString,QString>*)
    if (numArgs == 3 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString * >::isConvertible(pyargs[1]) && Shiboken::Converter<QMap<QString, QString > * >::isConvertible(pyargs[2])) {
        overloadId = 0; // parseUri(QString,QString*,QMap<QString,QString>*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_parseUri_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString * cpp_arg1 = Shiboken::Converter<QString * >::toCpp(pyargs[1]);
            QMap<QString, QString > * cpp_arg2 = Shiboken::Converter<QMap<QString, QString > * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // parseUri(QString,QString*,QMap<QString,QString>*)
            bool cppResult = QtMobility::QContactManager::parseUri(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_parseUri_TypeError:
        const char* overloads[] = {"QString, QString, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.parseUri", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_relationships(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "participantId", "relationshipType", "role" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 3, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.relationships(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.relationships(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOO:relationships", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
    // 1: relationships(QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
    if (numArgs == 0) {
        overloadId = 0; // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
    } else if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // relationships(QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
        } else if (Shiboken::Converter<QtMobility::QContactRelationship::Role >::isConvertible(pyargs[1])) {
            overloadId = 1; // relationships(QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
        }
    } else if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
        } else if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
            } else if (Shiboken::Converter<QtMobility::QContactRelationship::Role >::isConvertible(pyargs[2])) {
                overloadId = 0; // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_relationships_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "relationshipType");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "relationshipType";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "participantId");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "participantId";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "role");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "role";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.relationships(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                QString cpp_arg0 = pyargs[0] ? Shiboken::Converter<QString >::toCpp(pyargs[0]) : QString();
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QContactId cpp_arg1_tmp = QtMobility::QContactId();
                QtMobility::QContactId* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QContactId* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                QtMobility::QContactRelationship::Role cpp_arg2 = pyargs[2] ? Shiboken::Converter<QtMobility::QContactRelationship::Role >::toCpp(pyargs[2]) : QtMobility::QContactRelationship::Either;

                if(!PyErr_Occurred()) {
                // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
                QList<QtMobility::QContactRelationship > cppResult = cppSelf->QtMobility::QContactManager::relationships(cpp_arg0, *cpp_arg1, cpp_arg2);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toPython(cppResult);
                }
                break;
            }
            case 1: // relationships(QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "role");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "role";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.relationships(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QContactId* cpp_arg0 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(pyargs[0]);
                QtMobility::QContactRelationship::Role cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QContactRelationship::Role >::toCpp(pyargs[1]) : QtMobility::QContactRelationship::Either;

                if(!PyErr_Occurred()) {
                // relationships(QtMobility::QContactId,QtMobility::QContactRelationship::Role)const
                QList<QtMobility::QContactRelationship > cppResult = cppSelf->QtMobility::QContactManager::relationships(*cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_relationships_TypeError:
        const char* overloads[] = {"QString = QString(), QtMobility.Contacts.QtMobility::QContactId = QtMobility.QContactId(), QtMobility.Contacts.QtMobility::QContactRelationship.Role = QContactRelationship.Either", "QtMobility.Contacts.QtMobility::QContactId, QtMobility.Contacts.QtMobility::QContactRelationship.Role = QContactRelationship.Either", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.relationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_removeContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeContact(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // removeContact(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_removeContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeContact(QtMobility::QContactLocalId)
            bool cppResult = cppSelf->QtMobility::QContactManager::removeContact(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_removeContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.removeContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_removeContacts(PyObject* self, PyObject* args)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeContacts", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeContacts(QList<QtMobility::QContactLocalId>,QMap<int,QtMobility::QContactManager::Error>*)
    if (numArgs == 2 && Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1])) {
        overloadId = 0; // removeContacts(QList<QtMobility::QContactLocalId>,QMap<int,QtMobility::QContactManager::Error>*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_removeContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // removeContacts(QList<QtMobility::QContactLocalId>,QMap<int,QtMobility::QContactManager::Error>*)
            bool cppResult = cppSelf->QtMobility::QContactManager::removeContacts(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_removeContacts_TypeError:
        const char* overloads[] = {"list, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.removeContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_removeDetailDefinition(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "contactType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.removeDetailDefinition(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.removeDetailDefinition(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.removeDetailDefinition(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:removeDetailDefinition", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeDetailDefinition(QString,QString)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // removeDetailDefinition(QString,QString)
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // removeDetailDefinition(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_removeDetailDefinition_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "contactType");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "contactType";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.removeDetailDefinition(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QContactType::TypeContact;

            if(!PyErr_Occurred()) {
            // removeDetailDefinition(QString,QString)
            bool cppResult = cppSelf->QtMobility::QContactManager::removeDetailDefinition(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_removeDetailDefinition_TypeError:
        const char* overloads[] = {"QString, QString = QContactType.TypeContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.removeDetailDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_removeRelationship(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeRelationship(QtMobility::QContactRelationship)
    if (Shiboken::Converter<const QtMobility::QContactRelationship & >::isConvertible(arg)) {
        overloadId = 0; // removeRelationship(QtMobility::QContactRelationship)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_removeRelationship_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactRelationship* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeRelationship(QtMobility::QContactRelationship)
            bool cppResult = cppSelf->QtMobility::QContactManager::removeRelationship(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_removeRelationship_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationship", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.removeRelationship", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_removeRelationships(PyObject* self, PyObject* args)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeRelationships", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeRelationships(QList<QtMobility::QContactRelationship>,QMap<int,QtMobility::QContactManager::Error>*)
    if (numArgs == 2 && Shiboken::Converter< QList<QtMobility::QContactRelationship >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1])) {
        overloadId = 0; // removeRelationships(QList<QtMobility::QContactRelationship>,QMap<int,QtMobility::QContactManager::Error>*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_removeRelationships_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactRelationship > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // removeRelationships(QList<QtMobility::QContactRelationship>,QMap<int,QtMobility::QContactManager::Error>*)
            bool cppResult = cppSelf->QtMobility::QContactManager::removeRelationships(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_removeRelationships_TypeError:
        const char* overloads[] = {"list, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.removeRelationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_saveContact(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: saveContact(QtMobility::QContact*)
    if (Shiboken::Converter<QtMobility::QContact * >::isConvertible(arg)) {
        overloadId = 0; // saveContact(QtMobility::QContact*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_saveContact_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // saveContact(QtMobility::QContact*)
            bool cppResult = cppSelf->QtMobility::QContactManager::saveContact(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_saveContact_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.saveContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_saveContacts(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: saveContacts(QList<QtMobility::QContact>*,QMap<int,QtMobility::QContactManager::Error>*)
    if (PySequence_Check(arg)) {
        overloadId = 0; // saveContacts(QList<QtMobility::QContact>*,QMap<int,QtMobility::QContactManager::Error>*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_saveContacts_TypeError;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // saveContacts(QList<QtMobility::QContact>*,QMap<int,QtMobility::QContactManager::Error>*)
            // Begin code injection
            
            int numItems = PySequence_Length(arg);
            QList<QtMobility::QContact> contacts;
            for (int i=0; i < numItems; i++) {
               Shiboken::AutoDecRef contact(PySequence_GetItem(arg, i));
               contacts.append(Shiboken::Converter<QtMobility::QContact >::toCpp(contact));
            }
            
            QMap<int, QtMobility::QContactManager::Error> errorMap;
            bool retval_ = cppSelf->saveContacts(&contacts, &errorMap);
            pyResult = Shiboken::makeTuple(retval_, errorMap);
            
            // End of code injection


            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_saveContacts_TypeError:
        const char* overloads[] = {"list, dict", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.saveContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_saveDetailDefinition(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "contactType" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.saveDetailDefinition(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.saveDetailDefinition(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactManager.saveDetailDefinition(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:saveDetailDefinition", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: saveDetailDefinition(QtMobility::QContactDetailDefinition,QString)
    if (Shiboken::Converter<const QtMobility::QContactDetailDefinition & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // saveDetailDefinition(QtMobility::QContactDetailDefinition,QString)
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // saveDetailDefinition(QtMobility::QContactDetailDefinition,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_saveDetailDefinition_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "contactType");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "contactType";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactManager.saveDetailDefinition(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetailDefinition* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailDefinition* >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QContactType::TypeContact;

            if(!PyErr_Occurred()) {
            // saveDetailDefinition(QtMobility::QContactDetailDefinition,QString)
            bool cppResult = cppSelf->QtMobility::QContactManager::saveDetailDefinition(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_saveDetailDefinition_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailDefinition, QString = QContactType.TypeContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.saveDetailDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_saveRelationship(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: saveRelationship(QtMobility::QContactRelationship*)
    if (Shiboken::Converter<QtMobility::QContactRelationship * >::isConvertible(arg)) {
        overloadId = 0; // saveRelationship(QtMobility::QContactRelationship*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_saveRelationship_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactRelationship* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // saveRelationship(QtMobility::QContactRelationship*)
            bool cppResult = cppSelf->QtMobility::QContactManager::saveRelationship(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_saveRelationship_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationship", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.saveRelationship", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_saveRelationships(PyObject* self, PyObject* args)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveRelationships", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: saveRelationships(QList<QtMobility::QContactRelationship>*,QMap<int,QtMobility::QContactManager::Error>*)
    if (numArgs == 2 && Shiboken::Converter<QList<QtMobility::QContactRelationship > * >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1])) {
        overloadId = 0; // saveRelationships(QList<QtMobility::QContactRelationship>*,QMap<int,QtMobility::QContactManager::Error>*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_saveRelationships_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactRelationship > * cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactRelationship > * >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // saveRelationships(QList<QtMobility::QContactRelationship>*,QMap<int,QtMobility::QContactManager::Error>*)
            bool cppResult = cppSelf->QtMobility::QContactManager::saveRelationships(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_saveRelationships_TypeError:
        const char* overloads[] = {"list, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManager.saveRelationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_selfContactId(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // selfContactId()const
            QtMobility::QContactLocalId cppResult = cppSelf->QtMobility::QContactManager::selfContactId();
            pyResult = Shiboken::Converter<QtMobility::QContactLocalId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_setSelfContactId(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSelfContactId(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // setSelfContactId(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_setSelfContactId_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSelfContactId(QtMobility::QContactLocalId)
            bool cppResult = cppSelf->QtMobility::QContactManager::setSelfContactId(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_setSelfContactId_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.setSelfContactId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_supportedContactTypes(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedContactTypes()const
            QStringList cppResult = cppSelf->QtMobility::QContactManager::supportedContactTypes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_supportedDataTypes(PyObject* self)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedDataTypes()const
            QList<QVariant::Type > cppResult = cppSelf->QtMobility::QContactManager::supportedDataTypes();
            pyResult = Shiboken::Converter<QList<QVariant::Type > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerFunc_synthesizeContactDisplayLabel(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: synthesizeContactDisplayLabel(QtMobility::QContact*)const
    if (Shiboken::Converter<QtMobility::QContact * >::isConvertible(arg)) {
        overloadId = 0; // synthesizeContactDisplayLabel(QtMobility::QContact*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_synthesizeContactDisplayLabel_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // synthesizeContactDisplayLabel(QtMobility::QContact*)const
            cppSelf->QtMobility::QContactManager::synthesizeContactDisplayLabel(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerFunc_synthesizeContactDisplayLabel_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.synthesizeContactDisplayLabel", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerFunc_synthesizedContactDisplayLabel(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: synthesizedContactDisplayLabel(QtMobility::QContact)const
    if (Shiboken::Converter<const QtMobility::QContact & >::isConvertible(arg)) {
        overloadId = 0; // synthesizedContactDisplayLabel(QtMobility::QContact)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerFunc_synthesizedContactDisplayLabel_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // synthesizedContactDisplayLabel(QtMobility::QContact)const
            QString cppResult = cppSelf->QtMobility::QContactManager::synthesizedContactDisplayLabel(*cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerFunc_synthesizedContactDisplayLabel_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManager.synthesizedContactDisplayLabel", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactManager_methods[] = {
    {"availableManagers", (PyCFunction)SbkQtMobility_QContactManagerFunc_availableManagers, METH_NOARGS|METH_STATIC},
    {"buildUri", (PyCFunction)SbkQtMobility_QContactManagerFunc_buildUri, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"compatibleContact", (PyCFunction)SbkQtMobility_QContactManagerFunc_compatibleContact, METH_O},
    {"contact", (PyCFunction)SbkQtMobility_QContactManagerFunc_contact, METH_VARARGS|METH_KEYWORDS},
    {"contactIds", (PyCFunction)SbkQtMobility_QContactManagerFunc_contactIds, METH_VARARGS|METH_KEYWORDS},
    {"contacts", (PyCFunction)SbkQtMobility_QContactManagerFunc_contacts, METH_VARARGS|METH_KEYWORDS},
    {"detailDefinition", (PyCFunction)SbkQtMobility_QContactManagerFunc_detailDefinition, METH_VARARGS|METH_KEYWORDS},
    {"detailDefinitions", (PyCFunction)SbkQtMobility_QContactManagerFunc_detailDefinitions, METH_VARARGS|METH_KEYWORDS},
    {"error", (PyCFunction)SbkQtMobility_QContactManagerFunc_error, METH_NOARGS},
    {"fromUri", (PyCFunction)SbkQtMobility_QContactManagerFunc_fromUri, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"hasFeature", (PyCFunction)SbkQtMobility_QContactManagerFunc_hasFeature, METH_VARARGS|METH_KEYWORDS},
    {"isFilterSupported", (PyCFunction)SbkQtMobility_QContactManagerFunc_isFilterSupported, METH_O},
    {"isRelationshipTypeSupported", (PyCFunction)SbkQtMobility_QContactManagerFunc_isRelationshipTypeSupported, METH_VARARGS|METH_KEYWORDS},
    {"managerName", (PyCFunction)SbkQtMobility_QContactManagerFunc_managerName, METH_NOARGS},
    {"managerParameters", (PyCFunction)SbkQtMobility_QContactManagerFunc_managerParameters, METH_NOARGS},
    {"managerUri", (PyCFunction)SbkQtMobility_QContactManagerFunc_managerUri, METH_NOARGS},
    {"managerVersion", (PyCFunction)SbkQtMobility_QContactManagerFunc_managerVersion, METH_NOARGS},
    {"parseUri", (PyCFunction)SbkQtMobility_QContactManagerFunc_parseUri, METH_VARARGS|METH_STATIC},
    {"relationships", (PyCFunction)SbkQtMobility_QContactManagerFunc_relationships, METH_VARARGS|METH_KEYWORDS},
    {"removeContact", (PyCFunction)SbkQtMobility_QContactManagerFunc_removeContact, METH_O},
    {"removeContacts", (PyCFunction)SbkQtMobility_QContactManagerFunc_removeContacts, METH_VARARGS},
    {"removeDetailDefinition", (PyCFunction)SbkQtMobility_QContactManagerFunc_removeDetailDefinition, METH_VARARGS|METH_KEYWORDS},
    {"removeRelationship", (PyCFunction)SbkQtMobility_QContactManagerFunc_removeRelationship, METH_O},
    {"removeRelationships", (PyCFunction)SbkQtMobility_QContactManagerFunc_removeRelationships, METH_VARARGS},
    {"saveContact", (PyCFunction)SbkQtMobility_QContactManagerFunc_saveContact, METH_O},
    {"saveContacts", (PyCFunction)SbkQtMobility_QContactManagerFunc_saveContacts, METH_O},
    {"saveDetailDefinition", (PyCFunction)SbkQtMobility_QContactManagerFunc_saveDetailDefinition, METH_VARARGS|METH_KEYWORDS},
    {"saveRelationship", (PyCFunction)SbkQtMobility_QContactManagerFunc_saveRelationship, METH_O},
    {"saveRelationships", (PyCFunction)SbkQtMobility_QContactManagerFunc_saveRelationships, METH_VARARGS},
    {"selfContactId", (PyCFunction)SbkQtMobility_QContactManagerFunc_selfContactId, METH_NOARGS},
    {"setSelfContactId", (PyCFunction)SbkQtMobility_QContactManagerFunc_setSelfContactId, METH_O},
    {"supportedContactTypes", (PyCFunction)SbkQtMobility_QContactManagerFunc_supportedContactTypes, METH_NOARGS},
    {"supportedDataTypes", (PyCFunction)SbkQtMobility_QContactManagerFunc_supportedDataTypes, METH_NOARGS},
    {"synthesizeContactDisplayLabel", (PyCFunction)SbkQtMobility_QContactManagerFunc_synthesizeContactDisplayLabel, METH_O},
    {"synthesizedContactDisplayLabel", (PyCFunction)SbkQtMobility_QContactManagerFunc_synthesizedContactDisplayLabel, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactManager_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactManager >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactManager*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QContactManager_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QContactManager*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QContactManager_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactManager_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactManager_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactManager_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactManager_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactManager_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ManagerFeature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactManager(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactManager_Type);

    SbkQtMobility_QContactManager_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QContactManager_Type.type_discovery = &SbkQtMobility_QContactManager_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QContactManager_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactManager_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactManager_Type));
    PyModule_AddObject(module, "QContactManager",
        ((PyObject*)&SbkQtMobility_QContactManager_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGER_ERROR_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::NoError, "NoError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::DoesNotExistError, "DoesNotExistError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "DoesNotExistError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "DoesNotExistError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::AlreadyExistsError, "AlreadyExistsError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "AlreadyExistsError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "AlreadyExistsError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::InvalidDetailError, "InvalidDetailError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "InvalidDetailError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "InvalidDetailError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::InvalidRelationshipError, "InvalidRelationshipError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "InvalidRelationshipError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "InvalidRelationshipError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::LockedError, "LockedError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "LockedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "LockedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::DetailAccessError, "DetailAccessError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "DetailAccessError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "DetailAccessError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::PermissionsError, "PermissionsError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "PermissionsError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "PermissionsError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::OutOfMemoryError, "OutOfMemoryError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "OutOfMemoryError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "OutOfMemoryError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::NotSupportedError, "NotSupportedError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "NotSupportedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "NotSupportedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::BadArgumentError, "BadArgumentError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "BadArgumentError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "BadArgumentError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::UnspecifiedError, "UnspecifiedError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "UnspecifiedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "UnspecifiedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::VersionMismatchError, "VersionMismatchError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "VersionMismatchError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "VersionMismatchError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::LimitReachedError, "LimitReachedError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "LimitReachedError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "LimitReachedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type,
        (long) QtMobility::QContactManager::InvalidContactTypeError, "InvalidContactTypeError");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "InvalidContactTypeError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_Error_Type.tp_dict,
        "InvalidContactTypeError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactManager::Error");

    // init enum class: ManagerFeature
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGER_MANAGERFEATURE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
            "ManagerFeature",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::Groups, "Groups");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "Groups", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "Groups", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::ActionPreferences, "ActionPreferences");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "ActionPreferences", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "ActionPreferences", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::MutableDefinitions, "MutableDefinitions");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "MutableDefinitions", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "MutableDefinitions", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::Relationships, "Relationships");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "Relationships", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "Relationships", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::ArbitraryRelationshipTypes, "ArbitraryRelationshipTypes");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "ArbitraryRelationshipTypes", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "ArbitraryRelationshipTypes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::DetailOrdering, "DetailOrdering");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "DetailOrdering", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "DetailOrdering", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::SelfContact, "SelfContact");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "SelfContact", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "SelfContact", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::Anonymous, "Anonymous");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "Anonymous", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "Anonymous", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type,
        (long) QtMobility::QContactManager::ChangeLogs, "ChangeLogs");
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict,
        "ChangeLogs", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactManager_ManagerFeature_Type.tp_dict,
        "ChangeLogs", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactManager::ManagerFeature");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("contactsChanged", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "contactsChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("dataChanged", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "dataChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("contactsAdded", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "contactsAdded", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("selfContactIdChanged", "const QtMobility::QContactLocalId&,const QtMobility::QContactLocalId&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "selfContactIdChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("relationshipsAdded", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "relationshipsAdded", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("contactsRemoved", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "contactsRemoved", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("relationshipsRemoved", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManager_Type.super.ht_type.tp_dict, "relationshipsRemoved", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManager >("QtMobility::QContactManager*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManager >(typeid(QtMobility::QContactManager).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManager >(typeid(QContactManagerWrapper).name());
    PySide::initQtMetaType<QtMobility::QContactManager* >();
}

