/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactinvalidfilter_wrapper.h"

// Extra includes
#include <qcontactfilter.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactInvalidFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactInvalidFilter >()))
        return -1;

    QtMobility::QContactInvalidFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactInvalidFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactInvalidFilter(QtMobility::QContactInvalidFilter)
    // 1: QContactInvalidFilter()
    // 2: QContactInvalidFilter(QtMobility::QContactFilter)
    if (numArgs == 0) {
        overloadId = 1; // QContactInvalidFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 2; // QContactInvalidFilter(QtMobility::QContactFilter)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactInvalidFilter & >::isConvertible(arg)) {
        overloadId = 0; // QContactInvalidFilter(QtMobility::QContactInvalidFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactInvalidFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactInvalidFilter(QtMobility::QContactInvalidFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactInvalidFilter > cpp_arg0_auto_ptr;
                QtMobility::QContactInvalidFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactInvalidFilter* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactInvalidFilter >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactInvalidFilter >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactInvalidFilter(QtMobility::QContactInvalidFilter)
                cptr = new QtMobility::QContactInvalidFilter(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactInvalidFilter()
            {

                if(!PyErr_Occurred()) {
                // QContactInvalidFilter()
                cptr = new QtMobility::QContactInvalidFilter();
                }
                break;
            }
            case 2: // QContactInvalidFilter(QtMobility::QContactFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactInvalidFilter(QtMobility::QContactFilter)
                cptr = new QtMobility::QContactInvalidFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactInvalidFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactInvalidFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactInvalidFilter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactInvalidFilter", "", "QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactInvalidFilter", overloads);
        return -1;
}

static PyMethodDef SbkQtMobility_QContactInvalidFilter_methods[] = {
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactInvalidFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactInvalidFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactInvalidFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactInvalidFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactInvalidFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactInvalidFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactInvalidFilter(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTINVALIDFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactInvalidFilter_Type);

    SbkQtMobility_QContactInvalidFilter_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactInvalidFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactInvalidFilter_Type));
    PyModule_AddObject(module, "QContactInvalidFilter",
        ((PyObject*)&SbkQtMobility_QContactInvalidFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactInvalidFilter >("QtMobility::QContactInvalidFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactInvalidFilter >("QtMobility::QContactInvalidFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactInvalidFilter >(typeid(QtMobility::QContactInvalidFilter).name());
    PySide::initQtMetaType<QtMobility::QContactInvalidFilter >();
}

