/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactintersectionfilter_wrapper.h"

// Extra includes
#include <QList>
#include <qcontactfilter.h>
#include <qcontactintersectionfilter.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactIntersectionFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactIntersectionFilter >()))
        return -1;

    QtMobility::QContactIntersectionFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactIntersectionFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactIntersectionFilter(QtMobility::QContactIntersectionFilter)
    // 1: QContactIntersectionFilter()
    // 2: QContactIntersectionFilter(QtMobility::QContactFilter)
    if (numArgs == 0) {
        overloadId = 1; // QContactIntersectionFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 2; // QContactIntersectionFilter(QtMobility::QContactFilter)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactIntersectionFilter & >::isConvertible(arg)) {
        overloadId = 0; // QContactIntersectionFilter(QtMobility::QContactIntersectionFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIntersectionFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactIntersectionFilter(QtMobility::QContactIntersectionFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactIntersectionFilter > cpp_arg0_auto_ptr;
                QtMobility::QContactIntersectionFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactIntersectionFilter >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactIntersectionFilter >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactIntersectionFilter(QtMobility::QContactIntersectionFilter)
                cptr = new QtMobility::QContactIntersectionFilter(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactIntersectionFilter()
            {

                if(!PyErr_Occurred()) {
                // QContactIntersectionFilter()
                cptr = new QtMobility::QContactIntersectionFilter();
                }
                break;
            }
            case 2: // QContactIntersectionFilter(QtMobility::QContactFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactIntersectionFilter(QtMobility::QContactFilter)
                cptr = new QtMobility::QContactIntersectionFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactIntersectionFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactIntersectionFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactIntersectionFilter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactIntersectionFilter", "", "QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactIntersectionFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactIntersectionFilterFunc_append(PyObject* self, PyObject* arg)
{
    QtMobility::QContactIntersectionFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: append(QtMobility::QContactFilter)
    if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // append(QtMobility::QContactFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIntersectionFilterFunc_append_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // append(QtMobility::QContactFilter)
            cppSelf->QtMobility::QContactIntersectionFilter::append(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactIntersectionFilterFunc_append_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactIntersectionFilter.append", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactIntersectionFilterFunc_filters(PyObject* self)
{
    QtMobility::QContactIntersectionFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // filters()const
            QList<QtMobility::QContactFilter > cppResult = cppSelf->QtMobility::QContactIntersectionFilter::filters();
            pyResult = Shiboken::Converter<QList<QtMobility::QContactFilter > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactIntersectionFilterFunc_prepend(PyObject* self, PyObject* arg)
{
    QtMobility::QContactIntersectionFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: prepend(QtMobility::QContactFilter)
    if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // prepend(QtMobility::QContactFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIntersectionFilterFunc_prepend_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // prepend(QtMobility::QContactFilter)
            cppSelf->QtMobility::QContactIntersectionFilter::prepend(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactIntersectionFilterFunc_prepend_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactIntersectionFilter.prepend", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactIntersectionFilterFunc_remove(PyObject* self, PyObject* arg)
{
    QtMobility::QContactIntersectionFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: remove(QtMobility::QContactFilter)
    if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // remove(QtMobility::QContactFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIntersectionFilterFunc_remove_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // remove(QtMobility::QContactFilter)
            cppSelf->QtMobility::QContactIntersectionFilter::remove(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactIntersectionFilterFunc_remove_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactIntersectionFilter.remove", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactIntersectionFilterFunc_setFilters(PyObject* self, PyObject* arg)
{
    QtMobility::QContactIntersectionFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setFilters(QList<QtMobility::QContactFilter>)
    if (Shiboken::Converter< QList<QtMobility::QContactFilter >  >::isConvertible(arg)) {
        overloadId = 0; // setFilters(QList<QtMobility::QContactFilter>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIntersectionFilterFunc_setFilters_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactFilter > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactFilter > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setFilters(QList<QtMobility::QContactFilter>)
            cppSelf->QtMobility::QContactIntersectionFilter::setFilters(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactIntersectionFilterFunc_setFilters_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactIntersectionFilter.setFilters", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactIntersectionFilter_methods[] = {
    {"append", (PyCFunction)SbkQtMobility_QContactIntersectionFilterFunc_append, METH_O},
    {"filters", (PyCFunction)SbkQtMobility_QContactIntersectionFilterFunc_filters, METH_NOARGS},
    {"prepend", (PyCFunction)SbkQtMobility_QContactIntersectionFilterFunc_prepend, METH_O},
    {"remove", (PyCFunction)SbkQtMobility_QContactIntersectionFilterFunc_remove, METH_O},
    {"setFilters", (PyCFunction)SbkQtMobility_QContactIntersectionFilterFunc_setFilters, METH_O},
    {0} // Sentinel
};

static PyObject* SbkQtMobility_QContactIntersectionFilterFunc___lshift__(PyObject* self, PyObject* arg)
{
    QtMobility::QContactIntersectionFilter* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QContactIntersectionFilter >::checkType(arg) && !Shiboken::Converter<QtMobility::QContactIntersectionFilter >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactIntersectionFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator<<(QtMobility::QContactFilter)
    if (!isReverse && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // operator<<(QtMobility::QContactFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIntersectionFilterFunc___lshift___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator<<(QtMobility::QContactFilter)
            QtMobility::QContactIntersectionFilter & cppResult = (*cppSelf) << (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QContactIntersectionFilter & >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactIntersectionFilterFunc___lshift___TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactIntersectionFilter.__lshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQtMobility_QContactIntersectionFilter_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQtMobility_QContactIntersectionFilterFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactIntersectionFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactIntersectionFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQtMobility_QContactIntersectionFilter_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactIntersectionFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactIntersectionFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactIntersectionFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactIntersectionFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactIntersectionFilter(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTINTERSECTIONFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactIntersectionFilter_Type);

    SbkQtMobility_QContactIntersectionFilter_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactIntersectionFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactIntersectionFilter_Type));
    PyModule_AddObject(module, "QContactIntersectionFilter",
        ((PyObject*)&SbkQtMobility_QContactIntersectionFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactIntersectionFilter >("QtMobility::QContactIntersectionFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactIntersectionFilter >("QtMobility::QContactIntersectionFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactIntersectionFilter >(typeid(QtMobility::QContactIntersectionFilter).name());
    PySide::initQtMetaType<QtMobility::QContactIntersectionFilter >();
}

