/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactid_wrapper.h"

// Extra includes
#include <qcontactid.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactId_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactId >()))
        return -1;

    QtMobility::QContactId* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactId", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactId()
    // 1: QContactId(QtMobility::QContactId)
    if (numArgs == 0) {
        overloadId = 0; // QContactId()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(arg)) {
        overloadId = 1; // QContactId(QtMobility::QContactId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactId_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactId()
            {

                if(!PyErr_Occurred()) {
                // QContactId()
                cptr = new QtMobility::QContactId();
                }
                break;
            }
            case 1: // QContactId(QtMobility::QContactId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactId* cpp_arg0 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactId(QtMobility::QContactId)
                cptr = new QtMobility::QContactId(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactId >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactId_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactId_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactId", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactIdFunc_localId(PyObject* self)
{
    QtMobility::QContactId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // localId()const
            QtMobility::QContactLocalId cppResult = cppSelf->QtMobility::QContactId::localId();
            pyResult = Shiboken::Converter<QtMobility::QContactLocalId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactIdFunc_managerUri(PyObject* self)
{
    QtMobility::QContactId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerUri()const
            QString cppResult = cppSelf->QtMobility::QContactId::managerUri();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactIdFunc_setLocalId(PyObject* self, PyObject* arg)
{
    QtMobility::QContactId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactId* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLocalId(QtMobility::QContactLocalId)
    if (Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(arg)) {
        overloadId = 0; // setLocalId(QtMobility::QContactLocalId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIdFunc_setLocalId_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLocalId(QtMobility::QContactLocalId)
            cppSelf->QtMobility::QContactId::setLocalId(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactIdFunc_setLocalId_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactId.setLocalId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactIdFunc_setManagerUri(PyObject* self, PyObject* arg)
{
    QtMobility::QContactId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactId* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setManagerUri(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setManagerUri(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactIdFunc_setManagerUri_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setManagerUri(QString)
            cppSelf->QtMobility::QContactId::setManagerUri(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactIdFunc_setManagerUri_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactId.setManagerUri", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactId_methods[] = {
    {"localId", (PyCFunction)SbkQtMobility_QContactIdFunc_localId, METH_NOARGS},
    {"managerUri", (PyCFunction)SbkQtMobility_QContactIdFunc_managerUri, METH_NOARGS},
    {"setLocalId", (PyCFunction)SbkQtMobility_QContactIdFunc_setLocalId, METH_O},
    {"setManagerUri", (PyCFunction)SbkQtMobility_QContactIdFunc_setManagerUri, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContactId_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContactId& cpp_self = *Shiboken::Converter<QtMobility::QContactId* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContactId & other) const
                QtMobility::QContactId* cpp_other = Shiboken::Converter<QtMobility::QContactId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactId  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContactId_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(other)) {
                // operator<(const QtMobility::QContactId & other) const
                QtMobility::QContactId* cpp_other = Shiboken::Converter<QtMobility::QContactId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactId  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else goto SbkQtMobility_QContactId_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(other)) {
                // operator==(const QtMobility::QContactId & other) const
                QtMobility::QContactId* cpp_other = Shiboken::Converter<QtMobility::QContactId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactId  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContactId_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContactId_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QContactId_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QContactId >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactId_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactId",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QContactId_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContactId_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactId_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactId_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactId >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactId",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactId(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTID_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactId_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactId_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactId_Type));
    PyModule_AddObject(module, "QContactId",
        ((PyObject*)&SbkQtMobility_QContactId_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactId >("QtMobility::QContactId");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactId >("QtMobility::QContactId*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactId >(typeid(QtMobility::QContactId).name());
    PySide::initQtMetaType<QtMobility::QContactId >();
}

