/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactgender_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactgender.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactGender_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactGender >()))
        return -1;

    QtMobility::QContactGender* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactGender", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactGender(QtMobility::QContactGender)
    // 1: QContactGender()
    // 2: QContactGender(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactGender()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactGender(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactGender & >::isConvertible(arg)) {
        overloadId = 0; // QContactGender(QtMobility::QContactGender)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGender_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactGender(QtMobility::QContactGender)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactGender > cpp_arg0_auto_ptr;
                QtMobility::QContactGender* cpp_arg0 = Shiboken::Converter<QtMobility::QContactGender* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactGender >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactGender >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactGender(QtMobility::QContactGender)
                cptr = new QtMobility::QContactGender(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactGender()
            {

                if(!PyErr_Occurred()) {
                // QContactGender()
                cptr = new QtMobility::QContactGender();
                }
                break;
            }
            case 2: // QContactGender(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactGender(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactGender(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactGender >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactGender_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactGender_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactGender", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactGender", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactGenderFunc_gender(PyObject* self)
{
    QtMobility::QContactGender* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGender* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // gender()const
            QString cppResult = cppSelf->QtMobility::QContactGender::gender();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGenderFunc_setGender(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGender* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGender* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setGender(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setGender(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGenderFunc_setGender_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setGender(QString)
            cppSelf->QtMobility::QContactGender::setGender(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGenderFunc_setGender_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGender.setGender", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactGender_methods[] = {
    {"gender", (PyCFunction)SbkQtMobility_QContactGenderFunc_gender, METH_NOARGS},
    {"setGender", (PyCFunction)SbkQtMobility_QContactGenderFunc_setGender, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactGender_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactGender",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactGender_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactGender_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactGender >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactGender",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactGender(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGENDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactGender_Type);

    SbkQtMobility_QContactGender_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactGender_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactGender_Type));
    PyModule_AddObject(module, "QContactGender",
        ((PyObject*)&SbkQtMobility_QContactGender_Type));

    PyDict_SetItemString(SbkQtMobility_QContactGender_Type.super.ht_type.tp_dict, "GenderFemale", Shiboken::Converter<QString >::toPython(QtMobility::QContactGender::GenderFemale));
    PyDict_SetItemString(SbkQtMobility_QContactGender_Type.super.ht_type.tp_dict, "FieldGender", Shiboken::Converter<QString >::toPython(QtMobility::QContactGender::FieldGender));
    PyDict_SetItemString(SbkQtMobility_QContactGender_Type.super.ht_type.tp_dict, "GenderMale", Shiboken::Converter<QString >::toPython(QtMobility::QContactGender::GenderMale));
    PyDict_SetItemString(SbkQtMobility_QContactGender_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactGender::DefinitionName));
    PyDict_SetItemString(SbkQtMobility_QContactGender_Type.super.ht_type.tp_dict, "GenderUnspecified", Shiboken::Converter<QString >::toPython(QtMobility::QContactGender::GenderUnspecified));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactGender >("QtMobility::QContactGender");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactGender >("QtMobility::QContactGender*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactGender >(typeid(QtMobility::QContactGender).name());
    PySide::initQtMetaType<QtMobility::QContactGender >();
}

