/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactfilter_wrapper.h"

// Extra includes
#include <qcontactfilter.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactFilter >()))
        return -1;

    QtMobility::QContactFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactFilter()
    // 1: QContactFilter(QtMobility::QContactFilter)
    if (numArgs == 0) {
        overloadId = 0; // QContactFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 1; // QContactFilter(QtMobility::QContactFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactFilter()
            {

                if(!PyErr_Occurred()) {
                // QContactFilter()
                cptr = new QtMobility::QContactFilter();
                }
                break;
            }
            case 1: // QContactFilter(QtMobility::QContactFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactFilter(QtMobility::QContactFilter)
                cptr = new QtMobility::QContactFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactFilter_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactFilterFunc_type(PyObject* self)
{
    QtMobility::QContactFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QContactFilter::FilterType cppResult = cppSelf->QtMobility::QContactFilter::type();
            pyResult = Shiboken::Converter<QtMobility::QContactFilter::FilterType >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactFilter_methods[] = {
    {"type", (PyCFunction)SbkQtMobility_QContactFilterFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContactFilter_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContactFilter& cpp_self = *Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContactFilter & other) const
                QtMobility::QContactFilter* cpp_other = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactFilter  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContactFilter_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(other)) {
                // operator==(const QtMobility::QContactFilter & other) const
                QtMobility::QContactFilter* cpp_other = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactFilter  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContactFilter_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContactFilter_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContactFilter_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactFilter",
    /*user_data*/           0
};
} //extern

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::checkType(self) && Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toPython(
        Shiboken::Converter<QtMobility::QContactFilter::MatchFlags>::toCpp(self)
        & Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::checkType(self) && Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toPython(
        Shiboken::Converter<QtMobility::QContactFilter::MatchFlags>::toCpp(self)
        | Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::checkType(self) && Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toPython(
        Shiboken::Converter<QtMobility::QContactFilter::MatchFlags>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QContactFilter::MatchFlags >::toPython(
        ~Shiboken::Converter<QtMobility::QContactFilter::MatchFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MatchFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MatchFlags",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};


static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FilterType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactFilter(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactFilter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactFilter_Type));
    PyModule_AddObject(module, "QContactFilter",
        ((PyObject*)&SbkQtMobility_QContactFilter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: MatchFlag
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_MATCHFLAG_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type);
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
            "MatchFlag",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type));

    // init flags class: QFlags<QtMobility::QContactFilter::MatchFlag>
    SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTFILTER_MATCHFLAG__IDX] = &SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlags_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlags_Type);
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
            "MatchFlags",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchExactly, "MatchExactly");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchExactly", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchExactly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchContains, "MatchContains");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchContains", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchContains", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchStartsWith, "MatchStartsWith");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchStartsWith", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchStartsWith", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchEndsWith, "MatchEndsWith");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchEndsWith", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchEndsWith", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchFixedString, "MatchFixedString");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchFixedString", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchFixedString", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchCaseSensitive, "MatchCaseSensitive");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchCaseSensitive", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchCaseSensitive", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchPhoneNumber, "MatchPhoneNumber");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchPhoneNumber", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchPhoneNumber", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type,
        (long) QtMobility::QContactFilter::MatchKeypadCollation, "MatchKeypadCollation");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "MatchKeypadCollation", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_MatchFlag_Type.tp_dict,
        "MatchKeypadCollation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactFilter::MatchFlag");

    // init enum class: FilterType
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_FILTERTYPE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type);
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
            "FilterType",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::InvalidFilter, "InvalidFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "InvalidFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "InvalidFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::ContactDetailFilter, "ContactDetailFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "ContactDetailFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "ContactDetailFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::ContactDetailRangeFilter, "ContactDetailRangeFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "ContactDetailRangeFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "ContactDetailRangeFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::ChangeLogFilter, "ChangeLogFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "ChangeLogFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "ChangeLogFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::ActionFilter, "ActionFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "ActionFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "ActionFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::RelationshipFilter, "RelationshipFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "RelationshipFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "RelationshipFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::IntersectionFilter, "IntersectionFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "IntersectionFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "IntersectionFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::UnionFilter, "UnionFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "UnionFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "UnionFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::LocalIdFilter, "LocalIdFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "LocalIdFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "LocalIdFilter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type,
        (long) QtMobility::QContactFilter::DefaultFilter, "DefaultFilter");
    PyDict_SetItemString(SbkQtMobility_QContactFilter_Type.super.ht_type.tp_dict,
        "DefaultFilter", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFilter_FilterType_Type.tp_dict,
        "DefaultFilter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactFilter::FilterType");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactFilter >("QtMobility::QContactFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactFilter >("QtMobility::QContactFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactFilter >(typeid(QtMobility::QContactFilter).name());
    PySide::initQtMetaType<QtMobility::QContactFilter >();
}

