/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactfamily_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactfamily.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactFamily_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactFamily >()))
        return -1;

    QtMobility::QContactFamily* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactFamily", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactFamily(QtMobility::QContactFamily)
    // 1: QContactFamily()
    // 2: QContactFamily(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactFamily()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactFamily(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFamily & >::isConvertible(arg)) {
        overloadId = 0; // QContactFamily(QtMobility::QContactFamily)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFamily_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactFamily(QtMobility::QContactFamily)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactFamily > cpp_arg0_auto_ptr;
                QtMobility::QContactFamily* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFamily* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactFamily >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactFamily >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactFamily(QtMobility::QContactFamily)
                cptr = new QtMobility::QContactFamily(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactFamily()
            {

                if(!PyErr_Occurred()) {
                // QContactFamily()
                cptr = new QtMobility::QContactFamily();
                }
                break;
            }
            case 2: // QContactFamily(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactFamily(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactFamily(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactFamily >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactFamily_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactFamily_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFamily", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactFamily", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactFamilyFunc_children(PyObject* self)
{
    QtMobility::QContactFamily* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFamily* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // children()const
            QStringList cppResult = cppSelf->QtMobility::QContactFamily::children();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFamilyFunc_setChildren(PyObject* self, PyObject* arg)
{
    QtMobility::QContactFamily* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFamily* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setChildren(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // setChildren(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFamilyFunc_setChildren_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setChildren(QStringList)
            cppSelf->QtMobility::QContactFamily::setChildren(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFamilyFunc_setChildren_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactFamily.setChildren", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFamilyFunc_setSpouse(PyObject* self, PyObject* arg)
{
    QtMobility::QContactFamily* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFamily* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSpouse(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSpouse(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFamilyFunc_setSpouse_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSpouse(QString)
            cppSelf->QtMobility::QContactFamily::setSpouse(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFamilyFunc_setSpouse_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactFamily.setSpouse", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFamilyFunc_spouse(PyObject* self)
{
    QtMobility::QContactFamily* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFamily* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // spouse()const
            QString cppResult = cppSelf->QtMobility::QContactFamily::spouse();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactFamily_methods[] = {
    {"children", (PyCFunction)SbkQtMobility_QContactFamilyFunc_children, METH_NOARGS},
    {"setChildren", (PyCFunction)SbkQtMobility_QContactFamilyFunc_setChildren, METH_O},
    {"setSpouse", (PyCFunction)SbkQtMobility_QContactFamilyFunc_setSpouse, METH_O},
    {"spouse", (PyCFunction)SbkQtMobility_QContactFamilyFunc_spouse, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactFamily_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactFamily",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactFamily_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactFamily_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactFamily >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactFamily",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactFamily(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFAMILY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactFamily_Type);

    SbkQtMobility_QContactFamily_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactFamily_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactFamily_Type));
    PyModule_AddObject(module, "QContactFamily",
        ((PyObject*)&SbkQtMobility_QContactFamily_Type));

    PyDict_SetItemString(SbkQtMobility_QContactFamily_Type.super.ht_type.tp_dict, "FieldSpouse", Shiboken::Converter<QString >::toPython(QtMobility::QContactFamily::FieldSpouse));
    PyDict_SetItemString(SbkQtMobility_QContactFamily_Type.super.ht_type.tp_dict, "FieldChildren", Shiboken::Converter<QString >::toPython(QtMobility::QContactFamily::FieldChildren));
    PyDict_SetItemString(SbkQtMobility_QContactFamily_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactFamily::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactFamily >("QtMobility::QContactFamily");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactFamily >("QtMobility::QContactFamily*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactFamily >(typeid(QtMobility::QContactFamily).name());
    PySide::initQtMetaType<QtMobility::QContactFamily >();
}

