/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactdetailfielddefinition_wrapper.h"

// Extra includes
#include <QList>
#include <qcontactdetailfielddefinition.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactDetailFieldDefinition_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactDetailFieldDefinition >()))
        return -1;

    QtMobility::QContactDetailFieldDefinition* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactDetailFieldDefinition", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactDetailFieldDefinition()
    // 1: QContactDetailFieldDefinition(QtMobility::QContactDetailFieldDefinition)
    if (numArgs == 0) {
        overloadId = 0; // QContactDetailFieldDefinition()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetailFieldDefinition & >::isConvertible(arg)) {
        overloadId = 1; // QContactDetailFieldDefinition(QtMobility::QContactDetailFieldDefinition)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFieldDefinition_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactDetailFieldDefinition()
            {

                if(!PyErr_Occurred()) {
                // QContactDetailFieldDefinition()
                cptr = new QtMobility::QContactDetailFieldDefinition();
                }
                break;
            }
            case 1: // QContactDetailFieldDefinition(QtMobility::QContactDetailFieldDefinition)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetailFieldDefinition* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactDetailFieldDefinition(QtMobility::QContactDetailFieldDefinition)
                cptr = new QtMobility::QContactDetailFieldDefinition(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactDetailFieldDefinition >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactDetailFieldDefinition_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactDetailFieldDefinition_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactDetailFieldDefinition", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactDetailFieldDefinition", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactDetailFieldDefinitionFunc_allowableValues(PyObject* self)
{
    QtMobility::QContactDetailFieldDefinition* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // allowableValues()const
            QList<QVariant > cppResult = cppSelf->QtMobility::QContactDetailFieldDefinition::allowableValues();
            pyResult = Shiboken::Converter<QList<QVariant > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFieldDefinitionFunc_dataType(PyObject* self)
{
    QtMobility::QContactDetailFieldDefinition* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // dataType()const
            QVariant::Type cppResult = cppSelf->QtMobility::QContactDetailFieldDefinition::dataType();
            pyResult = Shiboken::Converter<QVariant::Type >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactDetailFieldDefinitionFunc_setAllowableValues(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetailFieldDefinition* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAllowableValues(const QList<QVariant>)
    if (Shiboken::Converter< QList<QVariant > >::isConvertible(arg)) {
        overloadId = 0; // setAllowableValues(const QList<QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFieldDefinitionFunc_setAllowableValues_TypeError;

    // Call function/method
    {
        {
            QList<QVariant > cpp_arg0 = Shiboken::Converter<QList<QVariant > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAllowableValues(const QList<QVariant>)
            cppSelf->QtMobility::QContactDetailFieldDefinition::setAllowableValues(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFieldDefinitionFunc_setAllowableValues_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetailFieldDefinition.setAllowableValues", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactDetailFieldDefinitionFunc_setDataType(PyObject* self, PyObject* arg)
{
    QtMobility::QContactDetailFieldDefinition* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDataType(QVariant::Type)
    if (Shiboken::Converter<QVariant::Type >::isConvertible(arg)) {
        overloadId = 0; // setDataType(QVariant::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactDetailFieldDefinitionFunc_setDataType_TypeError;

    // Call function/method
    {
        {
            QVariant::Type cpp_arg0 = Shiboken::Converter<QVariant::Type >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDataType(QVariant::Type)
            cppSelf->QtMobility::QContactDetailFieldDefinition::setDataType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactDetailFieldDefinitionFunc_setDataType_TypeError:
        const char* overloads[] = {"QVariant::Type", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactDetailFieldDefinition.setDataType", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactDetailFieldDefinition_methods[] = {
    {"allowableValues", (PyCFunction)SbkQtMobility_QContactDetailFieldDefinitionFunc_allowableValues, METH_NOARGS},
    {"dataType", (PyCFunction)SbkQtMobility_QContactDetailFieldDefinitionFunc_dataType, METH_NOARGS},
    {"setAllowableValues", (PyCFunction)SbkQtMobility_QContactDetailFieldDefinitionFunc_setAllowableValues, METH_O},
    {"setDataType", (PyCFunction)SbkQtMobility_QContactDetailFieldDefinitionFunc_setDataType, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContactDetailFieldDefinition_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContactDetailFieldDefinition& cpp_self = *Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContactDetailFieldDefinition & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContactDetailFieldDefinition & other) const
                QtMobility::QContactDetailFieldDefinition* cpp_other = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactDetailFieldDefinition  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContactDetailFieldDefinition_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContactDetailFieldDefinition & >::isConvertible(other)) {
                // operator==(const QtMobility::QContactDetailFieldDefinition & other) const
                QtMobility::QContactDetailFieldDefinition* cpp_other = Shiboken::Converter<QtMobility::QContactDetailFieldDefinition* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactDetailFieldDefinition  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContactDetailFieldDefinition_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContactDetailFieldDefinition_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactDetailFieldDefinition_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactDetailFieldDefinition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContactDetailFieldDefinition_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactDetailFieldDefinition_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactDetailFieldDefinition_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactDetailFieldDefinition >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactDetailFieldDefinition",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactDetailFieldDefinition(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAILFIELDDEFINITION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactDetailFieldDefinition_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactDetailFieldDefinition_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactDetailFieldDefinition_Type));
    PyModule_AddObject(module, "QContactDetailFieldDefinition",
        ((PyObject*)&SbkQtMobility_QContactDetailFieldDefinition_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDetailFieldDefinition >("QtMobility::QContactDetailFieldDefinition");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactDetailFieldDefinition >("QtMobility::QContactDetailFieldDefinition*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactDetailFieldDefinition >(typeid(QtMobility::QContactDetailFieldDefinition).name());
    PySide::initQtMetaType<QtMobility::QContactDetailFieldDefinition >();
}

